/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.internal;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.bulkhead.event.BulkheadEvent;
import io.github.resilience4j.bulkhead.event.BulkheadOnCallFinishedEvent;
import io.github.resilience4j.bulkhead.event.BulkheadOnCallPermittedEvent;
import io.github.resilience4j.bulkhead.event.BulkheadOnCallRejectedEvent;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.EventProcessor;
import io.github.resilience4j.core.exception.AcquirePermissionCancelledException;
import io.github.resilience4j.core.lang.Nullable;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class SemaphoreBulkhead
implements Bulkhead {
    private static final String CONFIG_MUST_NOT_BE_NULL = "Config must not be null";
    private static final String TAGS_MUST_NOTE_BE_NULL = "Tags must not be null";
    private final String name;
    private final Semaphore semaphore;
    private final BulkheadMetrics metrics;
    private final BulkheadEventProcessor eventProcessor;
    private final Object configChangesLock = new Object();
    private final Map<String, String> tags;
    private volatile BulkheadConfig config;

    public SemaphoreBulkhead(String name, @Nullable BulkheadConfig bulkheadConfig) {
        this(name, bulkheadConfig, (Map<String, String>)HashMap.empty());
    }

    public SemaphoreBulkhead(String name, @Nullable BulkheadConfig bulkheadConfig, Map<String, String> tags) {
        this.name = name;
        this.config = Objects.requireNonNull(bulkheadConfig, CONFIG_MUST_NOT_BE_NULL);
        this.tags = Objects.requireNonNull(tags, TAGS_MUST_NOTE_BE_NULL);
        this.semaphore = new Semaphore(this.config.getMaxConcurrentCalls(), this.config.isFairCallHandlingEnabled());
        this.metrics = new BulkheadMetrics();
        this.eventProcessor = new BulkheadEventProcessor();
    }

    public SemaphoreBulkhead(String name) {
        this(name, BulkheadConfig.ofDefaults(), (Map<String, String>)HashMap.empty());
    }

    public SemaphoreBulkhead(String name, Supplier<BulkheadConfig> configSupplier) {
        this(name, configSupplier.get(), (Map<String, String>)HashMap.empty());
    }

    public SemaphoreBulkhead(String name, Supplier<BulkheadConfig> configSupplier, Map<String, String> tags) {
        this(name, configSupplier.get(), tags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeConfig(BulkheadConfig newConfig) {
        Object object = this.configChangesLock;
        synchronized (object) {
            int delta = newConfig.getMaxConcurrentCalls() - this.config.getMaxConcurrentCalls();
            if (delta < 0) {
                this.semaphore.acquireUninterruptibly(-delta);
            } else if (delta > 0) {
                this.semaphore.release(delta);
            }
            this.config = newConfig;
        }
    }

    @Override
    public boolean tryAcquirePermission() {
        boolean callPermitted = this.tryEnterBulkhead();
        this.publishBulkheadEvent(() -> callPermitted ? new BulkheadOnCallPermittedEvent(this.name) : new BulkheadOnCallRejectedEvent(this.name));
        return callPermitted;
    }

    @Override
    public void acquirePermission() {
        boolean permitted = this.tryAcquirePermission();
        if (permitted) {
            return;
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new AcquirePermissionCancelledException();
        }
        throw BulkheadFullException.createBulkheadFullException(this);
    }

    @Override
    public void releasePermission() {
        this.semaphore.release();
    }

    @Override
    public void onComplete() {
        this.semaphore.release();
        this.publishBulkheadEvent(() -> new BulkheadOnCallFinishedEvent(this.name));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BulkheadConfig getBulkheadConfig() {
        return this.config;
    }

    @Override
    public Bulkhead.Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public Bulkhead.EventPublisher getEventPublisher() {
        return this.eventProcessor;
    }

    public String toString() {
        return String.format("Bulkhead '%s'", this.name);
    }

    boolean tryEnterBulkhead() {
        long timeout = this.config.getMaxWaitDuration().toMillis();
        try {
            return this.semaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private void publishBulkheadEvent(Supplier<BulkheadEvent> eventSupplier) {
        if (this.eventProcessor.hasConsumers()) {
            this.eventProcessor.consumeEvent(eventSupplier.get());
        }
    }

    private final class BulkheadMetrics
    implements Bulkhead.Metrics {
        private BulkheadMetrics() {
        }

        @Override
        public int getAvailableConcurrentCalls() {
            return SemaphoreBulkhead.this.semaphore.availablePermits();
        }

        @Override
        public int getMaxAllowedConcurrentCalls() {
            return SemaphoreBulkhead.this.config.getMaxConcurrentCalls();
        }
    }

    private class BulkheadEventProcessor
    extends EventProcessor<BulkheadEvent>
    implements Bulkhead.EventPublisher,
    EventConsumer<BulkheadEvent> {
        private BulkheadEventProcessor() {
        }

        @Override
        public Bulkhead.EventPublisher onCallPermitted(EventConsumer<BulkheadOnCallPermittedEvent> onCallPermittedEventConsumer) {
            this.registerConsumer(BulkheadOnCallPermittedEvent.class.getName(), onCallPermittedEventConsumer);
            return this;
        }

        @Override
        public Bulkhead.EventPublisher onCallRejected(EventConsumer<BulkheadOnCallRejectedEvent> onCallRejectedEventConsumer) {
            this.registerConsumer(BulkheadOnCallRejectedEvent.class.getName(), onCallRejectedEventConsumer);
            return this;
        }

        @Override
        public Bulkhead.EventPublisher onCallFinished(EventConsumer<BulkheadOnCallFinishedEvent> onCallFinishedEventConsumer) {
            this.registerConsumer(BulkheadOnCallFinishedEvent.class.getName(), onCallFinishedEventConsumer);
            return this;
        }

        public void consumeEvent(BulkheadEvent event) {
            super.processEvent((Object)event);
        }
    }
}

