/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.service.engine.index.scheduler;

import com.xebialabs.deployit.core.rest.exception.StitchException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.stitch.configuration.XldConfigWithFallback;
import com.xebialabs.deployit.plugin.stitch.model.ci.GitSource;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.scheduler.GitSourceBranchesSyncTask;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.scheduler.PeriodicSyncTask;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.service.controltask.ControlTaskService;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronSequenceGenerator;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@Autowired
@ScalaSignature(bytes="\u0006\u0005\u0005}f\u0001B\n\u0015\u0001\u001dB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0015\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003Z\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u001dA\u0007A1A\u0005\n%Da!\u001e\u0001!\u0002\u0013Q\u0007b\u0002<\u0001\u0001\u0004%Ia\u001e\u0005\n\u0003G\u0001\u0001\u0019!C\u0005\u0003KAq!a\u0005\u0001A\u0003&\u0001\u0010C\u0004\u0002<\u0001!\t!!\u0010\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R!9\u0011q\r\u0001\u0005\u0002\u0005%\u0004bBA7\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003g\u0002A\u0011AA;\u0011\u001d\ti\b\u0001C\u0005\u0003\u007fBq!!%\u0001\t\u0013\t\u0019\nC\u0004\u0002\u001a\u0002!I!a'\u0003'M{WO]2f'ft7mU2iK\u0012,H.\u001a:\u000b\u0005U1\u0012!C:dQ\u0016$W\u000f\\3s\u0015\t9\u0002$A\u0003j]\u0012,\u0007P\u0003\u0002\u001a5\u00051QM\\4j]\u0016T!a\u0007\u000f\u0002\u000fM,'O^5dK*\u0011QDH\u0001\u0007gRLGo\u00195\u000b\u0005}\u0001\u0013A\u00029mk\u001eLgN\u0003\u0002\"E\u0005AA-\u001a9m_fLGO\u0003\u0002$I\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002K\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u000b\t\u0003S1j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QF\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\u001bQ\f7o[*dQ\u0016$W\u000f\\3s!\t\u0001\u0014(D\u00012\u0015\t\u00114'\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001N\u001b\u0002\u0015M\u001c\u0007.\u001a3vY&twM\u0003\u00027o\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u00019\u0003\ry'oZ\u0005\u0003uE\u0012q\u0003\u00165sK\u0006$\u0007k\\8m)\u0006\u001c8nU2iK\u0012,H.\u001a:)\t\u0005adi\u0012\t\u0003{\u0011k\u0011A\u0010\u0006\u0003\u007f\u0001\u000b!\"\u00198o_R\fG/[8o\u0015\t\t%)A\u0004gC\u000e$xN]=\u000b\u0005\r+\u0014!\u00022fC:\u001c\u0018BA#?\u0005%\tV/\u00197jM&,'/A\u0003wC2,X-I\u0001I\u0003]!\bN]3bIB{w\u000e\u001c+bg.\u001c6\r[3ek2,'/A\tsKB|7/\u001b;pef\u001cVM\u001d<jG\u0016\u0004\"a\u0013(\u000e\u00031S!!\u0014\u0011\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002P\u0019\n\t\"+\u001a9pg&$xN]=TKJ4\u0018nY3\u0002%\r|g\u000e\u001e:pYR\u000b7o[*feZL7-\u001a\t\u0003%Zk\u0011a\u0015\u0006\u0003)V\u000b1bY8oiJ|G\u000e^1tW*\u00111\u0004I\u0005\u0003/N\u0013!cQ8oiJ|G\u000eV1tWN+'O^5dK\u0006)\u0002\u0010\u001c3D_:4\u0017nZ,ji\"4\u0015\r\u001c7cC\u000e\\\u0007C\u0001.^\u001b\u0005Y&B\u0001/\u001d\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u0011al\u0017\u0002\u001612$7i\u001c8gS\u001e<\u0016\u000e\u001e5GC2d'-Y2l\u0003\u0019a\u0014N\\5u}Q)\u0011mY3gOB\u0011!\rA\u0007\u0002)!)a&\u0002a\u0001_!\"1\r\u0010$H\u0011\u0015IU\u00011\u0001K\u0011\u0015\u0001V\u00011\u0001R\u0011\u0015AV\u00011\u0001Z\u0003-!(/[4hKJ,\u0005\u0010\u001d:\u0016\u0003)\u0004\"a\u001b:\u000f\u00051\u0004\bCA7+\u001b\u0005q'BA8'\u0003\u0019a$o\\8u}%\u0011\u0011OK\u0001\u0007!J,G-\u001a4\n\u0005M$(AB*ue&twM\u0003\u0002rU\u0005aAO]5hO\u0016\u0014X\t\u001f9sA\u0005\u00012o\u00195fIVdW\r\u001a+bg.l\u0015\r]\u000b\u0002qB!1.\u001f6|\u0013\tQHOA\u0002NCB\u00044\u0001`A\b!\u0015i\u0018qAA\u0006\u001b\u0005q(B\u0001\u001a\u0000\u0015\u0011\t\t!a\u0001\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u000b\tAA[1wC&\u0019\u0011\u0011\u0002@\u0003\u001fM\u001b\u0007.\u001a3vY\u0016$g)\u001e;ve\u0016\u0004B!!\u0004\u0002\u00101\u0001AaCA\t\u0015\u0005\u0005\t\u0011!B\u0001\u0003+\u00111a\u0018\u00132\u0003E\u00198\r[3ek2,G\rV1tW6\u000b\u0007\u000fI\t\u0005\u0003/\ti\u0002E\u0002*\u00033I1!a\u0007+\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!KA\u0010\u0013\r\t\tC\u000b\u0002\u0004\u0003:L\u0018\u0001F:dQ\u0016$W\u000f\\3e)\u0006\u001c8.T1q?\u0012*\u0017\u000f\u0006\u0003\u0002(\u00055\u0002cA\u0015\u0002*%\u0019\u00111\u0006\u0016\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003_I\u0011\u0011!a\u0001\u0003c\t1\u0001\u001f\u00132!\u0015Y\u0017P[A\u001aa\u0011\t)$!\u000f\u0011\u000bu\f9!a\u000e\u0011\t\u00055\u0011\u0011\b\u0003\r\u0003#\ti#!A\u0001\u0002\u000b\u0005\u0011QC\u0001\tg\u000eDW\rZ;mKR\u0011\u0011q\u0005\u0015\u0004\u0017\u0005\u0005\u0003\u0003BA\"\u0003\u0017j!!!\u0012\u000b\u0007}\n9E\u0003\u0002\u0002J\u0005)!.\u0019<bq&!\u0011QJA#\u00055\u0001vn\u001d;D_:\u001cHO];di\u0006)R\u000f\u001d3bi\u0016,\u00050[:uS:<7I]8o\u0015>\u0014G\u0003BA\u0014\u0003'Bq!!\u0016\r\u0001\u0004\t9&\u0001\u0004t_V\u00148-\u001a\t\u0005\u00033\n\u0019'\u0004\u0002\u0002\\)!\u0011QLA0\u0003\t\u0019\u0017NC\u0002\u0002bq\tQ!\\8eK2LA!!\u001a\u0002\\\tIq)\u001b;T_V\u00148-Z\u0001\u0013g\u000eDW\rZ;mK:+wo\u0011:p]*{'\r\u0006\u0003\u0002(\u0005-\u0004bBA+\u001b\u0001\u0007\u0011qK\u0001\u0016I\u0016dW\r^3Fq&\u001cH/\u001b8h\u0007J|gNS8c)\u0011\t9#!\u001d\t\u000f\u0005Uc\u00021\u0001\u0002X\u00051b.^7cKJ|emU2iK\u0012,H.\u001a3UCN\\7\u000f\u0006\u0002\u0002xA\u0019\u0011&!\u001f\n\u0007\u0005m$FA\u0002J]R\f\u0001CZ3uG\"\u001c%o\u001c8Ue&<w-\u001a:\u0015\t\u0005\u0005\u0015Q\u0012\t\u0005\u0003\u0007\u000bI)\u0004\u0002\u0002\u0006*\u0019\u0011qQ\u001a\u0002\u000fM,\b\u000f]8si&!\u00111RAC\u0005-\u0019%o\u001c8Ue&<w-\u001a:\t\r\u0005=\u0005\u00031\u0001k\u00039\u0019'o\u001c8FqB\u0014Xm]:j_:\fQ\u0002Z3mKR,7I]8o\u0015>\u0014G\u0003BA\u0014\u0003+Ca!a&\u0012\u0001\u0004Q\u0017A\u0002;bg.LE-A\thKR\u0014%/\u00198dQ\u0016\u001cH+Y:l\u0013\u0012$B!!(\u0002(B!\u0011qTAS\u001b\t\t\tK\u0003\u0003\u0002$\u0006\r\u0011\u0001\u00027b]\u001eL1a]AQ\u0011\u001d\t)F\u0005a\u0001\u0003/B3\u0001AAV!\u0011\ti+a-\u000e\u0005\u0005=&bAAYk\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005U\u0016q\u0016\u0002\b'\u0016\u0014h/[2fQ\r\u0001\u0011\u0011\u0018\t\u0004{\u0005m\u0016bAA_}\tI\u0011)\u001e;po&\u0014X\r\u001a")
public class SourceSyncScheduler {
    @Qualifier(value="threadPoolTaskScheduler")
    private final ThreadPoolTaskScheduler taskScheduler;
    private final RepositoryService repositoryService;
    private final ControlTaskService controlTaskService;
    private final String triggerExpr;
    private Map<String, ScheduledFuture<?>> scheduledTaskMap;

    private String triggerExpr() {
        return this.triggerExpr;
    }

    private Map<String, ScheduledFuture<?>> scheduledTaskMap() {
        return this.scheduledTaskMap;
    }

    private void scheduledTaskMap_$eq(Map<String, ScheduledFuture<?>> x$1) {
        this.scheduledTaskMap = x$1;
    }

    @PostConstruct
    public void schedule() {
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.repositoryService.listEntities(new SearchParameters().setType(Type.valueOf(GitSource.class)))).asScala().filter((Function1 & Serializable)source -> BoxesRunTime.boxToBoolean((boolean)SourceSyncScheduler.$anonfun$schedule$1(source)))).foreach((Function1 & Serializable)source -> {
            this.scheduleNewCronJob(source);
            return BoxedUnit.UNIT;
        });
    }

    public void updateExistingCronJob(GitSource source) {
        this.deleteExistingCronJob(source);
        this.scheduleNewCronJob(source);
    }

    public void scheduleNewCronJob(GitSource source) {
        if (source.syncAutomatically()) {
            this.scheduledTaskMap_$eq((Map)this.scheduledTaskMap().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)source.getId()), (Object)this.taskScheduler.schedule((Runnable)new PeriodicSyncTask(source, this.controlTaskService), (Trigger)this.fetchCronTrigger(source.cronExpression())))));
        }
        if (source.branchSyncAutomatically()) {
            this.scheduledTaskMap_$eq((Map)this.scheduledTaskMap().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.getBranchesTaskId(source)), (Object)this.taskScheduler.schedule((Runnable)new GitSourceBranchesSyncTask(source, this.controlTaskService), (Trigger)this.fetchCronTrigger(source.branchCronExpression())))));
            return;
        }
    }

    public void deleteExistingCronJob(GitSource source) {
        this.deleteCronJob(source.getId());
        this.deleteCronJob(this.getBranchesTaskId(source));
    }

    public int numberOfScheduledTasks() {
        return this.scheduledTaskMap().size();
    }

    private CronTrigger fetchCronTrigger(String cronExpression) {
        String string;
        String string2 = cronExpression;
        if (string2 != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((string = string2).trim()))) {
            return new CronTrigger(string);
        }
        return new CronTrigger(this.triggerExpr());
    }

    private void deleteCronJob(String taskId) {
        Object object = this.scheduledTaskMap().getOrElse((Object)taskId, (Function0 & Serializable)() -> None$.MODULE$);
        if (object instanceof ScheduledFuture) {
            ScheduledFuture scheduledFuture = (ScheduledFuture)object;
            scheduledFuture.cancel(true);
            this.scheduledTaskMap_$eq((Map)this.scheduledTaskMap().$minus((Object)taskId));
            return;
        }
    }

    private String getBranchesTaskId(GitSource source) {
        return source.getId() + "-branches";
    }

    private static final /* synthetic */ Date liftedTree1$1(String value$1, String triggerExprConf$1) {
        Date date;
        try {
            date = new CronSequenceGenerator(value$1).next(new Date());
        }
        catch (IllegalArgumentException e) {
            throw new StitchException("Expression [" + value$1 + "] defined in configuration for value [" + triggerExprConf$1 + "] is not a valid cron expression", e);
        }
        return date;
    }

    public static final /* synthetic */ boolean $anonfun$schedule$1(GitSource source) {
        return source.syncAutomatically() || source.branchSyncAutomatically();
    }

    public SourceSyncScheduler(@Qualifier(value="threadPoolTaskScheduler") ThreadPoolTaskScheduler taskScheduler, RepositoryService repositoryService, ControlTaskService controlTaskService, XldConfigWithFallback xldConfigWithFallback) {
        this.taskScheduler = taskScheduler;
        this.repositoryService = repositoryService;
        this.controlTaskService = controlTaskService;
        String triggerExprConf = "xl.source-polling.cron-trigger";
        String value = xldConfigWithFallback.xldConfig().getString(triggerExprConf);
        SourceSyncScheduler.liftedTree1$1(value, triggerExprConf);
        this.triggerExpr = value;
        this.scheduledTaskMap = Predef$.MODULE$.Map().empty();
    }
}

