/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view.predicate;

import org.apache.activemq.artemis.core.management.impl.view.SessionField;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ActiveMQFilterPredicate;
import org.apache.activemq.artemis.core.server.ServerSession;

public class SessionFilterPredicate
extends ActiveMQFilterPredicate<ServerSession> {
    private SessionField f;

    @Override
    public boolean test(ServerSession session) {
        if (this.f == null) {
            return true;
        }
        switch (this.f) {
            case ID: {
                return this.matches(session.getName());
            }
            case CONNECTION_ID: {
                return this.matches(session.getConnectionID());
            }
            case CONSUMER_COUNT: {
                return this.matches(session.getServerConsumers().size());
            }
            case PRODUCER_COUNT: {
                return this.matches(session.getServerProducers().size());
            }
            case PROTOCOL: {
                return this.matches(session.getRemotingConnection().getProtocolName());
            }
            case CLIENT_ID: {
                return this.matches(session.getRemotingConnection().getClientID());
            }
            case LOCAL_ADDRESS: {
                return this.matches(session.getRemotingConnection().getTransportConnection().getLocalAddress());
            }
            case REMOTE_ADDRESS: {
                return this.matches(session.getRemotingConnection().getTransportConnection().getRemoteAddress());
            }
        }
        return true;
    }

    @Override
    public void setField(String field) {
        if (field != null && !field.equals("")) {
            this.f = SessionField.valueOfName(field);
            if (this.f == null) {
                this.f = SessionField.valueOf(field);
            }
        }
    }
}

