/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.service;

import com.xebialabs.deployit.core.rest.api.TaskSpecificationServiceImpl;
import com.xebialabs.deployit.deployment.planner.Planner;
import com.xebialabs.deployit.deployment.rules.PlanCreationContextFactory;
import com.xebialabs.deployit.deployment.service.ArtifactTransformerFactory;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.plugin.stitch.dao.jpa.processor.ProcessorRepository;
import com.xebialabs.deployit.plugin.stitch.model.Processor;
import com.xebialabs.deployit.plugin.stitch.service.ChangeSet;
import com.xebialabs.deployit.plugin.stitch.service.DryRunProcessors;
import com.xebialabs.deployit.plugin.stitch.service.HasDryRunPreview;
import com.xebialabs.deployit.plugin.stitch.service.HasPreview;
import com.xebialabs.deployit.plugin.stitch.service.PreviewServiceContext$;
import com.xebialabs.deployit.plugin.stitch.service.ProcessorBreakpoint;
import com.xebialabs.deployit.plugin.stitch.service.ProcessorDryRunBreakpoint;
import com.xebialabs.deployit.plugin.stitch.service.StitchPreviewArtifactTransformerFactory;
import com.xebialabs.deployit.plugin.stitch.service.StitchPreviewFailedException;
import com.xebialabs.deployit.plugin.stitch.service.util.WorkdirHelper$;
import com.xebialabs.deployit.repository.RepositoryAdapterFactory;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.service.dependency.DependencyService;
import com.xebialabs.deployit.service.deployment.DeploymentService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.UUID;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@Component
@Autowired
@ScalaSignature(bytes="\u0006\u0005\u0005]e\u0001\u0002\t\u0012\u0001yA\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011!a\u0005A!A!\u0002\u0013i\u0005\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\t\u0011m\u0003!\u0011!Q\u0001\nqC\u0001B\u0019\u0001\u0003\u0002\u0003\u0006Ia\u0019\u0005\u0006Q\u0002!\t!\u001b\u0005\u0006i\u0002!\t!\u001e\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u001d\ti\u0001\u0001C\u0001\u0003gAa\u0001\u001e\u0001\u0005\u0002\u0005]\u0003bBA0\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0003K\u0002A\u0011BA4\u0005y\u0019F/\u001b;dQR\u000b7o[*qK\u000eLg-[2bi&|gnU3sm&\u001cWM\u0003\u0002\u0013'\u000591/\u001a:wS\u000e,'B\u0001\u000b\u0016\u0003\u0019\u0019H/\u001b;dQ*\u0011acF\u0001\u0007a2,x-\u001b8\u000b\u0005aI\u0012\u0001\u00033fa2|\u00170\u001b;\u000b\u0005iY\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005a\u0012aA2p[\u000e\u00011c\u0001\u0001 SA\u0011\u0001eJ\u0007\u0002C)\u0011!eI\u0001\u0004CBL'B\u0001\u0013&\u0003\u0011\u0011Xm\u001d;\u000b\u0005\u0019:\u0012\u0001B2pe\u0016L!\u0001K\u0011\u00039Q\u000b7o[*qK\u000eLg-[2bi&|gnU3sm&\u001cW-S7qYB\u0011!fL\u0007\u0002W)\u0011A&L\u0001\u0006g24GG\u001b\u0006\u0002]\u0005AqM]5{u2,G-\u0003\u00021W\t9Aj\\4hS:<\u0017!\u0005:fa>\u001c\u0018\u000e^8ssN+'O^5dKB\u00111GN\u0007\u0002i)\u0011QgF\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u001c5\u0005E\u0011V\r]8tSR|'/_*feZL7-Z\u0001\u0012I\u0016\u0004XM\u001c3f]\u000eL8+\u001a:wS\u000e,\u0007C\u0001\u001e?\u001b\u0005Y$B\u0001\u001f>\u0003)!W\r]3oI\u0016t7-\u001f\u0006\u0003%]I!aP\u001e\u0003#\u0011+\u0007/\u001a8eK:\u001c\u0017pU3sm&\u001cW-\u0001\bx_J\\G)\u001b:GC\u000e$xN]=\u0011\u0005M\u0012\u0015BA\"5\u000599vN]6ESJ4\u0015m\u0019;pef\fq\u0001\u001d7b]:,'\u000f\u0005\u0002G\u00156\tqI\u0003\u0002E\u0011*\u0011\u0011jF\u0001\u000bI\u0016\u0004Hn\\=nK:$\u0018BA&H\u0005\u001d\u0001F.\u00198oKJ\f1\u0003\u001d:pG\u0016\u001c8o\u001c:SKB|7/\u001b;pef\u0004\"AT+\u000e\u0003=S!\u0001U)\u0002\u0013A\u0014xnY3tg>\u0014(B\u0001*T\u0003\rQ\u0007/\u0019\u0006\u0003)N\t1\u0001Z1p\u0013\t1vJA\nQe>\u001cWm]:peJ+\u0007o\\:ji>\u0014\u00180A\tsKB|7/\u001b;pef4\u0015m\u0019;pef\u0004\"aM-\n\u0005i#$\u0001\u0007*fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\u001a\u000b7\r^8ss\u0006Q\u0002\u000f\\1o\u0007J,\u0017\r^5p]\u000e{g\u000e^3yi\u001a\u000b7\r^8ssB\u0011Q\fY\u0007\u0002=*\u0011q\fS\u0001\u0006eVdWm]\u0005\u0003Cz\u0013!\u0004\u00157b]\u000e\u0013X-\u0019;j_:\u001cuN\u001c;fqR4\u0015m\u0019;pef\f!$\u0019:uS\u001a\f7\r\u001e+sC:\u001chm\u001c:nKJ4\u0015m\u0019;pef\u0004\"\u0001\u001a4\u000e\u0003\u0015T!A\u0005%\n\u0005\u001d,'AG!si&4\u0017m\u0019;Ue\u0006t7OZ8s[\u0016\u0014h)Y2u_JL\u0018A\u0002\u001fj]&$h\bF\u0005kY6tw\u000e]9sgB\u00111\u000eA\u0007\u0002#!)\u0011'\u0003a\u0001e!)\u0001(\u0003a\u0001s!)\u0001)\u0003a\u0001\u0003\")A)\u0003a\u0001\u000b\")A*\u0003a\u0001\u001b\")q+\u0003a\u00011\")1,\u0003a\u00019\")!-\u0003a\u0001G\u0006)\u0002O]3wS\u0016<H)\u001a9m_flWM\u001c;UCN\\GC\u0001<\u007f!\t9H0D\u0001y\u0015\tI(0\u0001\u0004uCN\\WM\u001d\u0006\u0003w^\ta!\u001a8hS:,\u0017BA?y\u0005E!\u0016m]6Ta\u0016\u001c\u0017NZ5dCRLwN\u001c\u0005\u0006\u0013*\u0001\ra \t\u0005\u0003\u0003\tI!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003\r!Go\u001c\u0006\u0003EiLA!a\u0003\u0002\u0004\tQA)\u001a9m_flWM\u001c;\u00027A\u0014XM^5fo\u0012+\u0007\u000f\\8z[\u0016tG\u000fV1tW\u0012\u0013\u0018PU;o)\u001d1\u0018\u0011CA\n\u0003SAQ!S\u0006A\u0002}Dq!!\u0006\f\u0001\u0004\t9\"A\u0005dQ\u0006tw-Z*fiB1\u0011\u0011DA\u0010\u0003Gi!!a\u0007\u000b\u0005\u0005u\u0011!B:dC2\f\u0017\u0002BA\u0011\u00037\u0011aa\u00149uS>t\u0007cA6\u0002&%\u0019\u0011qE\t\u0003\u0013\rC\u0017M\\4f'\u0016$\bbBA\u0016\u0017\u0001\u0007\u0011QF\u0001\u0010C\u0012$wJ\u001c)s_\u000e,7o]8sgB\u00191.a\f\n\u0007\u0005E\u0012C\u0001\tEef\u0014VO\u001c)s_\u000e,7o]8sgRIa/!\u000e\u00028\u0005e\u0012Q\n\u0005\u0006\u00132\u0001\ra \u0005\b\u0003+a\u0001\u0019AA\f\u0011\u001d\tY\u0004\u0004a\u0001\u0003{\t1\u0002\u001d:pG\u0016\u001c8o\u001c:JIB!\u0011qHA%\u001b\t\t\tE\u0003\u0003\u0002D\u0005\u0015\u0013\u0001B;uS2T!!a\u0012\u0002\t)\fg/Y\u0005\u0005\u0003\u0017\n\tE\u0001\u0003V+&#\u0005bBA(\u0019\u0001\u0007\u0011\u0011K\u0001\u0010S:4xnY1uS>t\u0017J\u001c3fqB!\u0011\u0011DA*\u0013\u0011\t)&a\u0007\u0003\u0007%sG\u000fF\u0004w\u00033\nY&!\u0018\t\u000b%k\u0001\u0019A@\t\u000f\u0005mR\u00021\u0001\u0002>!9\u0011qJ\u0007A\u0002\u0005E\u0013a\t9sKZLWm\u001e#fa2|\u00170\\3oiR\u000b7o[,ji\",e/\u00197vCRLwN\u001c\u000b\u0004m\u0006\r\u0004\"B%\u000f\u0001\u0004y\u0018a\u0005<bY&$\u0017\r^3Qe>\u001cWm]:pe&#G\u0003BA\u001f\u0003SBq!a\u000f\u0010\u0001\u0004\ti\u0004K\u0002\u0001\u0003[\u0002B!a\u001c\u0002\u00066\u0011\u0011\u0011\u000f\u0006\u0005\u0003g\n)(\u0001\u0006b]:|G/\u0019;j_:TA!a\u001e\u0002z\u00059a-Y2u_JL(\u0002BA>\u0003{\nQAY3b]NTA!a \u0002\u0002\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002\u0004\u0006\u0019qN]4\n\t\u0005\u001d\u0015\u0011\u000f\u0002\n\u0003V$xn^5sK\u0012D3\u0001AAF!\u0011\ti)a%\u000e\u0005\u0005=%\u0002BAI\u0003{\n!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t)*a$\u0003\u0013\r{W\u000e]8oK:$\b")
public class StitchTaskSpecificationService
extends TaskSpecificationServiceImpl
implements Logging {
    private final ProcessorRepository processorRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        StitchTaskSpecificationService stitchTaskSpecificationService = this;
        synchronized (stitchTaskSpecificationService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public TaskSpecification previewDeploymentTask(Deployment deployment) {
        return (TaskSpecification)WorkdirHelper$.MODULE$.manageWorkDir("preview", (Function0 & Serializable)() -> {
            this.info((Function0<Object>)(Function0 & Serializable)() -> "Processing stitch preview for deployed application " + deployment.getDeployedApplication().getName());
            return this.createDeploymentTask(deployment, true);
        });
    }

    public TaskSpecification previewDeploymentTaskDryRun(Deployment deployment, Option<ChangeSet> changeSet, DryRunProcessors addOnProcessors) {
        return (TaskSpecification)WorkdirHelper$.MODULE$.manageWorkDir("preview", (Function0 & Serializable)() -> {
            this.info((Function0<Object>)(Function0 & Serializable)() -> "Processing stitch preview for Dry Run of deployed application " + deployment.getDeployedApplication().getName());
            return (TaskSpecification)PreviewServiceContext$.MODULE$.previewContext().withValue((Object)new HasDryRunPreview(changeSet, addOnProcessors), (Function0 & Serializable)() -> this.createDeploymentTask(deployment, true));
        });
    }

    public TaskSpecification previewDeploymentTaskDryRun(Deployment deployment, Option<ChangeSet> changeSet, UUID processorId, int invocationIndex) {
        return (TaskSpecification)WorkdirHelper$.MODULE$.manageWorkDir("preview", (Function0 & Serializable)() -> {
            this.info((Function0<Object>)(Function0 & Serializable)() -> "Processing stitch preview processor difference for Dry run of deployed application " + deployment.getDeployedApplication().getName() + " on invocation #" + invocationIndex + " and processorId " + processorId);
            return (TaskSpecification)PreviewServiceContext$.MODULE$.previewContext().withValue((Object)new ProcessorDryRunBreakpoint(changeSet, processorId), (Function0 & Serializable)() -> this.createDeploymentTask(deployment, true));
        });
    }

    public TaskSpecification previewDeploymentTask(Deployment deployment, UUID processorId, int invocationIndex) {
        return (TaskSpecification)WorkdirHelper$.MODULE$.manageWorkDir("preview", (Function0 & Serializable)() -> {
            this.validateProcessorId(processorId);
            this.info((Function0<Object>)(Function0 & Serializable)() -> "Processing stitch preview processor difference for deployed application " + deployment.getDeployedApplication().getName() + " on invocation #" + invocationIndex + " and processorId " + processorId);
            return (TaskSpecification)PreviewServiceContext$.MODULE$.previewContext().withValue((Object)new ProcessorBreakpoint(processorId), (Function0 & Serializable)() -> this.createDeploymentTask(deployment, true));
        });
    }

    public TaskSpecification previewDeploymentTaskWithEvaluation(Deployment deployment) {
        return (TaskSpecification)WorkdirHelper$.MODULE$.manageWorkDir("preview", (Function0 & Serializable)() -> {
            this.info((Function0<Object>)(Function0 & Serializable)() -> "Processing stitch preview evaluator " + deployment.getDeployedApplication().getName());
            return (TaskSpecification)PreviewServiceContext$.MODULE$.previewContext().withValue((Object)new HasPreview(), (Function0 & Serializable)() -> this.createDeploymentTask(deployment, true));
        });
    }

    private UUID validateProcessorId(UUID processorId) {
        Option option = this.processorRepository.get(processorId);
        if (option instanceof Some) {
            Some some = (Some)option;
            Processor value = (Processor)some.value();
            return value.id();
        }
        if (None$.MODULE$.equals(option)) {
            this.error((Function0<Object>)(Function0 & Serializable)() -> "Expected valid processorId but got [" + processorId + "]  - processor diff will not be displayed");
            throw new StitchPreviewFailedException("Error occurred while generating processor diff - please close current preview and try again");
        }
        throw new MatchError(option);
    }

    public StitchTaskSpecificationService(RepositoryService repositoryService, DependencyService dependencyService, WorkDirFactory workDirFactory, Planner planner, ProcessorRepository processorRepository, RepositoryAdapterFactory repositoryFactory, PlanCreationContextFactory planCreationContextFactory, ArtifactTransformerFactory artifactTransformerFactory) {
        this.processorRepository = processorRepository;
        super(repositoryService, new DeploymentService(planner, repositoryFactory, planCreationContextFactory, (ArtifactTransformerFactory)new StitchPreviewArtifactTransformerFactory(artifactTransformerFactory)), dependencyService, workDirFactory);
        Logging.$init$((Logging)this);
    }
}

