/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.james.mime4j.util.MimeUtil;

public class MimeParameterMapping {
    private final Map<String, String> parameters = new HashMap<String, String>();

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void addParameter(String name, String value) {
        String key = this.removeSectionFromName(name).toLowerCase();
        if (this.parameters.containsKey(key)) {
            this.parameters.put(key, this.decodeParameterValue(this.parameters.get(key) + value));
        } else {
            this.parameters.put(key, this.decodeParameterValue(value));
        }
    }

    private String decodeParameterValue(String value) {
        if (value == null) {
            return null;
        }
        int charsetEnd = value.indexOf("'");
        int languageEnd = value.indexOf("'", charsetEnd + 1);
        if (charsetEnd < 0 || languageEnd < 0) {
            return MimeUtil.unscrambleHeaderValue(value);
        }
        String charset = value.substring(0, charsetEnd);
        String fileName = value.substring(languageEnd + 1);
        try {
            return URLDecoder.decode(fileName, charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return MimeUtil.unscrambleHeaderValue(value);
        }
    }

    private String removeSectionFromName(String parameterName) {
        int position = parameterName.indexOf(42);
        return parameterName.substring(0, position < 0 ? parameterName.length() : position);
    }
}

