/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.service;

import com.xebialabs.deployit.core.rest.dto.CheckConnectionDTO;
import com.xebialabs.deployit.core.rest.exception.StitchException;
import com.xebialabs.deployit.core.rest.exception.StitchException$;
import com.xebialabs.deployit.plugin.stitch.configuration.git.GitUserCredentials;
import com.xebialabs.deployit.plugin.stitch.configuration.git.GitUserCredentials$;
import com.xebialabs.deployit.plugin.stitch.model.ci.GitSource;
import com.xebialabs.deployit.plugin.stitch.model.ci.GitUrlValidator$;
import com.xebialabs.deployit.plugin.stitch.service.GitOpsService;
import com.xebialabs.deployit.plugin.stitch.service.SourceService;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Service
@Autowired
@ScalaSignature(bytes="\u0006\u0005E4AAB\u0004\u0001)!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005C\u0003$\u0001\u0011\u0005A\u0005C\u0003(\u0001\u0011%\u0001\u0006C\u0003(\u0001\u0011\u00053\tC\u0003(\u0001\u0011\u0005\u0003K\u0001\u000bEK\u001a\fW\u000f\u001c;T_V\u00148-Z*feZL7-\u001a\u0006\u0003\u0011%\tqa]3sm&\u001cWM\u0003\u0002\u000b\u0017\u000511\u000f^5uG\"T!\u0001D\u0007\u0002\rAdWoZ5o\u0015\tqq\"\u0001\u0005eKBdw._5u\u0015\t\u0001\u0012#A\u0005yK\nL\u0017\r\\1cg*\t!#A\u0002d_6\u001c\u0001aE\u0002\u0001+m\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0007C\u0001\u000f\u001e\u001b\u00059\u0011B\u0001\u0010\b\u00055\u0019v.\u001e:dKN+'O^5dK\u0006iq-\u001b;PaN\u001cVM\u001d<jG\u0016\u0004\"\u0001H\u0011\n\u0005\t:!!D$ji>\u00038oU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0003K\u0019\u0002\"\u0001\b\u0001\t\u000b}\u0011\u0001\u0019\u0001\u0011\u0002\u001f\rDWmY6D_:tWm\u0019;j_:$2!\u000b\u0017:!\t1\"&\u0003\u0002,/\t!QK\\5u\u0011\u0015i3\u00011\u0001/\u0003\r)(\u000f\u001c\t\u0003_Yr!\u0001\r\u001b\u0011\u0005E:R\"\u0001\u001a\u000b\u0005M\u001a\u0012A\u0002\u001fs_>$h(\u0003\u00026/\u00051\u0001K]3eK\u001aL!a\u000e\u001d\u0003\rM#(/\u001b8h\u0015\t)t\u0003C\u0003;\u0007\u0001\u00071(A\u0006de\u0016$WM\u001c;jC2\u001c\bC\u0001\u001fB\u001b\u0005i$B\u0001 @\u0003\r9\u0017\u000e\u001e\u0006\u0003\u0001&\tQbY8oM&<WO]1uS>t\u0017B\u0001\">\u0005I9\u0015\u000e^+tKJ\u001c%/\u001a3f]RL\u0017\r\\:\u0015\u0005%\"\u0005\"B#\u0005\u0001\u00041\u0015AE2iK\u000e\\7i\u001c8oK\u000e$\u0018n\u001c8E)>\u0003\"a\u0012(\u000e\u0003!S!!\u0013&\u0002\u0007\u0011$xN\u0003\u0002L\u0019\u0006!!/Z:u\u0015\tiU\"\u0001\u0003d_J,\u0017BA(I\u0005I\u0019\u0005.Z2l\u0007>tg.Z2uS>tG\tV(\u0015\u0005%\n\u0006\"\u0002*\u0006\u0001\u0004\u0019\u0016AB:pkJ\u001cW\r\u0005\u0002U36\tQK\u0003\u0002W/\u0006\u00111-\u001b\u0006\u00031&\tQ!\\8eK2L!AW+\u0003\u0013\u001dKGoU8ve\u000e,\u0007F\u0001\u0001]!\ti\u0006.D\u0001_\u0015\ty\u0006-\u0001\u0006b]:|G/\u0019;j_:T!!\u00192\u0002\u000f\u0019\f7\r^8ss*\u00111\rZ\u0001\u0006E\u0016\fgn\u001d\u0006\u0003K\u001a\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002O\u0006\u0019qN]4\n\u0005%t&!C!vi><\u0018N]3eQ\t\u00011\u000e\u0005\u0002m_6\tQN\u0003\u0002oI\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\u0005Al'aB*feZL7-\u001a")
public class DefaultSourceService
implements SourceService {
    private final GitOpsService gitOpsService;

    private void checkConnection(String url, GitUserCredentials credentials) {
        try {
            this.gitOpsService.getGitSourceBranchNames(credentials, url);
        }
        catch (Throwable e) {
            throw new StitchException("Exception during source connection check.", e);
        }
    }

    @Override
    public void checkConnection(CheckConnectionDTO checkConnectionDTO) {
        String gitUrl = checkConnectionDTO.repositoryUrl();
        GitUrlValidator$.MODULE$.validateUrl(gitUrl).orElse((Function0 & Serializable)() -> {
            throw new StitchException(GitUrlValidator$.MODULE$.urlInvalidMessage(gitUrl), StitchException$.MODULE$.apply$default$2());
        }).foreach((Function1 & Serializable)x$1 -> {
            this.checkConnection(x$1, GitUserCredentials$.MODULE$.apply(checkConnectionDTO));
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void checkConnection(GitSource source) {
        this.checkConnection(source.repositoryUrl(), GitUserCredentials$.MODULE$.apply(source));
    }

    public DefaultSourceService(GitOpsService gitOpsService) {
        this.gitOpsService = gitOpsService;
    }
}

