/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session;

import java.time.Duration;
import java.time.Instant;
import java.util.Set;

public interface Session {
    public String getId();

    public String changeSessionId();

    public <T> T getAttribute(String var1);

    default public <T> T getRequiredAttribute(String name) {
        T result = this.getAttribute(name);
        if (result == null) {
            throw new IllegalArgumentException("Required attribute '" + name + "' is missing.");
        }
        return result;
    }

    default public <T> T getAttributeOrDefault(String name, T defaultValue) {
        T result = this.getAttribute(name);
        return result != null ? result : defaultValue;
    }

    public Set<String> getAttributeNames();

    public void setAttribute(String var1, Object var2);

    public void removeAttribute(String var1);

    public Instant getCreationTime();

    public void setLastAccessedTime(Instant var1);

    public Instant getLastAccessedTime();

    public void setMaxInactiveInterval(Duration var1);

    public Duration getMaxInactiveInterval();

    public boolean isExpired();
}

