/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.util.ContentUtil;

public abstract class SingleBody
implements Body {
    private Entity parent = null;

    protected SingleBody() {
    }

    @Override
    public Entity getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Entity parent) {
        this.parent = parent;
    }

    public abstract InputStream getInputStream() throws IOException;

    public void writeTo(OutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException();
        }
        InputStream in = this.getInputStream();
        ContentUtil.copy((InputStream)in, (OutputStream)out);
        in.close();
    }

    public long size() throws IOException {
        return IOUtils.copyLarge((InputStream)this.getInputStream(), (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
    }

    public SingleBody copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispose() {
    }
}

