/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.servlet;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.ApplicationContextFactory;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextFactory;
import org.springframework.boot.autoconfigure.web.servlet.ServletWebServerFactoryAutoConfiguration;
import org.springframework.boot.web.context.ConfigurableWebServerApplicationContext;
import org.springframework.boot.web.servlet.context.AnnotationConfigServletWebServerApplicationContext;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;

class ServletManagementContextFactory
implements ManagementContextFactory {
    ServletManagementContextFactory() {
    }

    @Override
    public ConfigurableWebServerApplicationContext createManagementContext(ApplicationContext parent, Class<?> ... configClasses) {
        Environment parentEnvironment = parent.getEnvironment();
        ConfigurableEnvironment childEnvironment = ApplicationContextFactory.DEFAULT.createEnvironment(WebApplicationType.SERVLET);
        if (parentEnvironment instanceof ConfigurableEnvironment) {
            childEnvironment.setConversionService(((ConfigurableEnvironment)parentEnvironment).getConversionService());
        }
        AnnotationConfigServletWebServerApplicationContext child = new AnnotationConfigServletWebServerApplicationContext();
        child.setEnvironment(childEnvironment);
        child.setParent(parent);
        ArrayList combinedClasses = new ArrayList(Arrays.asList(configClasses));
        combinedClasses.add(ServletWebServerFactoryAutoConfiguration.class);
        child.register(ClassUtils.toClassArray(combinedClasses));
        this.registerServletWebServerFactory(parent, child);
        return child;
    }

    private void registerServletWebServerFactory(ApplicationContext parent, AnnotationConfigServletWebServerApplicationContext childContext) {
        try {
            ConfigurableListableBeanFactory beanFactory = childContext.getBeanFactory();
            if (beanFactory instanceof BeanDefinitionRegistry) {
                BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
                registry.registerBeanDefinition("ServletWebServerFactory", (BeanDefinition)new RootBeanDefinition(this.determineServletWebServerFactoryClass(parent)));
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }

    private Class<?> determineServletWebServerFactoryClass(ApplicationContext parent) throws NoSuchBeanDefinitionException {
        Class<?> factoryClass = ((ServletWebServerFactory)parent.getBean(ServletWebServerFactory.class)).getClass();
        if (this.cannotBeInstantiated(factoryClass)) {
            throw new FatalBeanException("ServletWebServerFactory implementation " + factoryClass.getName() + " cannot be instantiated. To allow a separate management port to be used, a top-level class or static inner class should be used instead");
        }
        return factoryClass;
    }

    private boolean cannotBeInstantiated(Class<?> factoryClass) {
        return factoryClass.isLocalClass() || factoryClass.isMemberClass() && !Modifier.isStatic(factoryClass.getModifiers()) || factoryClass.isAnonymousClass();
    }
}

