/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.security;

import com.google.common.base.Preconditions;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.security.CommonTlsContextUtil;
import io.grpc.xds.internal.security.ReferenceCountingMap;
import io.grpc.xds.internal.security.SslContextProvider;
import io.grpc.xds.internal.security.certprovider.CertProviderServerSslContextProviderFactory;
import java.util.Map;

final class ServerSslContextProviderFactory
implements ReferenceCountingMap.ValueFactory<EnvoyServerProtoData.DownstreamTlsContext, SslContextProvider> {
    private Bootstrapper.BootstrapInfo bootstrapInfo;
    private final CertProviderServerSslContextProviderFactory certProviderServerSslContextProviderFactory;

    ServerSslContextProviderFactory(Bootstrapper.BootstrapInfo bootstrapInfo) {
        this(bootstrapInfo, CertProviderServerSslContextProviderFactory.getInstance());
    }

    ServerSslContextProviderFactory(Bootstrapper.BootstrapInfo bootstrapInfo, CertProviderServerSslContextProviderFactory factory) {
        this.bootstrapInfo = bootstrapInfo;
        this.certProviderServerSslContextProviderFactory = factory;
    }

    @Override
    public SslContextProvider create(EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext) {
        Preconditions.checkNotNull((Object)downstreamTlsContext, (Object)"downstreamTlsContext");
        Preconditions.checkNotNull((Object)downstreamTlsContext.getCommonTlsContext(), (Object)"downstreamTlsContext should have CommonTlsContext");
        if (CommonTlsContextUtil.hasCertProviderInstance(downstreamTlsContext.getCommonTlsContext())) {
            return this.certProviderServerSslContextProviderFactory.getProvider(downstreamTlsContext, this.bootstrapInfo.node().toEnvoyProtoNode(), (Map<String, Bootstrapper.CertificateProviderInfo>)this.bootstrapInfo.certProviders());
        }
        throw new UnsupportedOperationException("Unsupported configurations in DownstreamTlsContext!");
    }
}

