/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.web.reactive.function.OAuth2BodyExtractors;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public abstract class AbstractWebClientReactiveOAuth2AccessTokenResponseClient<T extends AbstractOAuth2AuthorizationGrantRequest>
implements ReactiveOAuth2AccessTokenResponseClient<T> {
    private WebClient webClient = WebClient.builder().build();
    private Converter<T, WebClient.RequestHeadersSpec<?>> requestEntityConverter = this::validatingPopulateRequest;
    private Converter<T, HttpHeaders> headersConverter = this::populateTokenRequestHeaders;
    private Converter<T, MultiValueMap<String, String>> parametersConverter = this::populateTokenRequestParameters;
    private BodyExtractor<Mono<OAuth2AccessTokenResponse>, ReactiveHttpInputMessage> bodyExtractor = OAuth2BodyExtractors.oauth2AccessTokenResponse();

    AbstractWebClientReactiveOAuth2AccessTokenResponseClient() {
    }

    @Override
    public Mono<OAuth2AccessTokenResponse> getTokenResponse(T grantRequest) {
        Assert.notNull(grantRequest, (String)"grantRequest cannot be null");
        return Mono.defer(() -> ((WebClient.RequestHeadersSpec)this.requestEntityConverter.convert((Object)grantRequest)).exchange().flatMap(response -> this.readTokenResponse(grantRequest, (ClientResponse)response)));
    }

    abstract ClientRegistration clientRegistration(T var1);

    private WebClient.RequestHeadersSpec<?> validatingPopulateRequest(T grantRequest) {
        this.validateClientAuthenticationMethod(grantRequest);
        return this.populateRequest(grantRequest);
    }

    private void validateClientAuthenticationMethod(T grantRequest) {
        boolean supportedClientAuthenticationMethod;
        ClientRegistration clientRegistration = ((AbstractOAuth2AuthorizationGrantRequest)grantRequest).getClientRegistration();
        ClientAuthenticationMethod clientAuthenticationMethod = clientRegistration.getClientAuthenticationMethod();
        boolean bl = supportedClientAuthenticationMethod = clientAuthenticationMethod.equals((Object)ClientAuthenticationMethod.NONE) || clientAuthenticationMethod.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_BASIC) || clientAuthenticationMethod.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_POST);
        if (!supportedClientAuthenticationMethod) {
            throw new IllegalArgumentException(String.format("This class supports `client_secret_basic`, `client_secret_post`, and `none` by default. Client [%s] is using [%s] instead. Please use a supported client authentication method, or use `set/addParametersConverter` or `set/addHeadersConverter` to supply an instance that supports [%s].", clientRegistration.getRegistrationId(), clientAuthenticationMethod, clientAuthenticationMethod));
        }
    }

    private WebClient.RequestHeadersSpec<?> populateRequest(T grantRequest) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(this.clientRegistration(grantRequest).getProviderDetails().getTokenUri(), new Object[0])).headers(headers -> {
            HttpHeaders headersToAdd = (HttpHeaders)this.getHeadersConverter().convert((Object)grantRequest);
            if (headersToAdd != null) {
                headers.addAll((MultiValueMap)headersToAdd);
            }
        })).body(this.createTokenRequestBody(grantRequest));
    }

    private HttpHeaders populateTokenRequestHeaders(T grantRequest) {
        HttpHeaders headers = new HttpHeaders();
        ClientRegistration clientRegistration = this.clientRegistration(grantRequest);
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        if (ClientAuthenticationMethod.CLIENT_SECRET_BASIC.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
            String clientId = AbstractWebClientReactiveOAuth2AccessTokenResponseClient.encodeClientCredential(clientRegistration.getClientId());
            String clientSecret = AbstractWebClientReactiveOAuth2AccessTokenResponseClient.encodeClientCredential(clientRegistration.getClientSecret());
            headers.setBasicAuth(clientId, clientSecret);
        }
        return headers;
    }

    private static String encodeClientCredential(String clientCredential) {
        try {
            return URLEncoder.encode(clientCredential, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private MultiValueMap<String, String> populateTokenRequestParameters(T grantRequest) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"grant_type", (Object)((AbstractOAuth2AuthorizationGrantRequest)grantRequest).getGrantType().getValue());
        return parameters;
    }

    private BodyInserters.FormInserter<String> createTokenRequestBody(T grantRequest) {
        MultiValueMap parameters = (MultiValueMap)this.getParametersConverter().convert(grantRequest);
        return this.populateTokenRequestBody(grantRequest, (BodyInserters.FormInserter<String>)BodyInserters.fromFormData((MultiValueMap)parameters));
    }

    BodyInserters.FormInserter<String> populateTokenRequestBody(T grantRequest, BodyInserters.FormInserter<String> body) {
        Set<String> scopes;
        ClientRegistration clientRegistration = this.clientRegistration(grantRequest);
        if (!ClientAuthenticationMethod.CLIENT_SECRET_BASIC.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
            body.with("client_id", (Object)clientRegistration.getClientId());
        }
        if (ClientAuthenticationMethod.CLIENT_SECRET_POST.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
            body.with("client_secret", (Object)clientRegistration.getClientSecret());
        }
        if (!CollectionUtils.isEmpty(scopes = this.scopes(grantRequest))) {
            body.with("scope", (Object)StringUtils.collectionToDelimitedString(scopes, (String)" "));
        }
        return body;
    }

    abstract Set<String> scopes(T var1);

    Set<String> defaultScopes(T grantRequest) {
        return Collections.emptySet();
    }

    private Mono<OAuth2AccessTokenResponse> readTokenResponse(T grantRequest, ClientResponse response) {
        return ((Mono)response.body(this.bodyExtractor)).map(tokenResponse -> this.populateTokenResponse(grantRequest, (OAuth2AccessTokenResponse)tokenResponse));
    }

    OAuth2AccessTokenResponse populateTokenResponse(T grantRequest, OAuth2AccessTokenResponse tokenResponse) {
        if (CollectionUtils.isEmpty((Collection)tokenResponse.getAccessToken().getScopes())) {
            Set<String> defaultScopes = this.defaultScopes(grantRequest);
            tokenResponse = OAuth2AccessTokenResponse.withResponse((OAuth2AccessTokenResponse)tokenResponse).scopes(defaultScopes).build();
        }
        return tokenResponse;
    }

    public void setWebClient(WebClient webClient) {
        Assert.notNull((Object)webClient, (String)"webClient cannot be null");
        this.webClient = webClient;
    }

    final Converter<T, HttpHeaders> getHeadersConverter() {
        return this.headersConverter;
    }

    public final void setHeadersConverter(Converter<T, HttpHeaders> headersConverter) {
        Assert.notNull(headersConverter, (String)"headersConverter cannot be null");
        this.headersConverter = headersConverter;
        this.requestEntityConverter = this::populateRequest;
    }

    public final void addHeadersConverter(Converter<T, HttpHeaders> headersConverter) {
        Assert.notNull(headersConverter, (String)"headersConverter cannot be null");
        Converter currentHeadersConverter = this.headersConverter;
        this.headersConverter = authorizationGrantRequest -> {
            HttpHeaders headersToAdd;
            HttpHeaders headers = (HttpHeaders)currentHeadersConverter.convert(authorizationGrantRequest);
            if (headers == null) {
                headers = new HttpHeaders();
            }
            if ((headersToAdd = (HttpHeaders)headersConverter.convert(authorizationGrantRequest)) != null) {
                headers.addAll((MultiValueMap)headersToAdd);
            }
            return headers;
        };
        this.requestEntityConverter = this::populateRequest;
    }

    final Converter<T, MultiValueMap<String, String>> getParametersConverter() {
        return this.parametersConverter;
    }

    public final void setParametersConverter(Converter<T, MultiValueMap<String, String>> parametersConverter) {
        Assert.notNull(parametersConverter, (String)"parametersConverter cannot be null");
        this.parametersConverter = parametersConverter;
        this.requestEntityConverter = this::populateRequest;
    }

    public final void addParametersConverter(Converter<T, MultiValueMap<String, String>> parametersConverter) {
        Assert.notNull(parametersConverter, (String)"parametersConverter cannot be null");
        Converter currentParametersConverter = this.parametersConverter;
        this.parametersConverter = authorizationGrantRequest -> {
            MultiValueMap parametersToAdd;
            MultiValueMap parameters = (MultiValueMap)currentParametersConverter.convert(authorizationGrantRequest);
            if (parameters == null) {
                parameters = new LinkedMultiValueMap();
            }
            if ((parametersToAdd = (MultiValueMap)parametersConverter.convert(authorizationGrantRequest)) != null) {
                parameters.addAll(parametersToAdd);
            }
            return parameters;
        };
        this.requestEntityConverter = this::populateRequest;
    }

    public final void setBodyExtractor(BodyExtractor<Mono<OAuth2AccessTokenResponse>, ReactiveHttpInputMessage> bodyExtractor) {
        Assert.notNull(bodyExtractor, (String)"bodyExtractor cannot be null");
        this.bodyExtractor = bodyExtractor;
    }
}

