/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.number;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.python.icu.impl.number.FormatQuantity4;
import org.python.icu.impl.number.FormatQuantityBCD;

public class FormatQuantitySelector {
    public static FormatQuantityBCD from(int input) {
        return new FormatQuantity4(input);
    }

    public static FormatQuantityBCD from(long input) {
        return new FormatQuantity4(input);
    }

    public static FormatQuantityBCD from(double input) {
        return new FormatQuantity4(input);
    }

    public static FormatQuantityBCD from(BigInteger input) {
        return new FormatQuantity4(input);
    }

    public static FormatQuantityBCD from(BigDecimal input) {
        return new FormatQuantity4(input);
    }

    public static FormatQuantityBCD from(org.python.icu.math.BigDecimal input) {
        return FormatQuantitySelector.from(input.toBigDecimal());
    }

    public static FormatQuantityBCD from(Number number) {
        if (number instanceof Long) {
            return FormatQuantitySelector.from(number.longValue());
        }
        if (number instanceof Integer) {
            return FormatQuantitySelector.from(number.intValue());
        }
        if (number instanceof Double) {
            return FormatQuantitySelector.from(number.doubleValue());
        }
        if (number instanceof BigInteger) {
            return FormatQuantitySelector.from((BigInteger)number);
        }
        if (number instanceof BigDecimal) {
            return FormatQuantitySelector.from((BigDecimal)number);
        }
        if (number instanceof org.python.icu.math.BigDecimal) {
            return FormatQuantitySelector.from((org.python.icu.math.BigDecimal)number);
        }
        throw new IllegalArgumentException("Number is of an unsupported type: " + number.getClass().getName());
    }
}

