/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.context.ApplicationContext;
import org.springframework.expression.EvaluationContext;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.method.ExpressionAttribute;
import org.springframework.security.authorization.method.ExpressionUtils;
import org.springframework.security.authorization.method.MethodAuthorizationDeniedHandler;
import org.springframework.security.authorization.method.PreAuthorizeExpressionAttribute;
import org.springframework.security.authorization.method.PreAuthorizeExpressionAttributeRegistry;
import org.springframework.security.authorization.method.PrePostTemplateDefaults;
import org.springframework.security.core.Authentication;

public final class PreAuthorizeAuthorizationManager
implements AuthorizationManager<MethodInvocation>,
MethodAuthorizationDeniedHandler {
    private PreAuthorizeExpressionAttributeRegistry registry = new PreAuthorizeExpressionAttributeRegistry();

    public void setExpressionHandler(MethodSecurityExpressionHandler expressionHandler) {
        this.registry.setExpressionHandler(expressionHandler);
    }

    public void setTemplateDefaults(PrePostTemplateDefaults defaults) {
        this.registry.setTemplateDefaults(defaults);
    }

    public void setApplicationContext(ApplicationContext context) {
        this.registry.setApplicationContext(context);
    }

    @Override
    public AuthorizationDecision check(Supplier<Authentication> authentication, MethodInvocation mi) {
        Object attribute = this.registry.getAttribute(mi);
        if (attribute == ExpressionAttribute.NULL_ATTRIBUTE) {
            return null;
        }
        EvaluationContext ctx = this.registry.getExpressionHandler().createEvaluationContext(authentication, mi);
        return (AuthorizationDecision)ExpressionUtils.evaluate(((ExpressionAttribute)attribute).getExpression(), ctx);
    }

    @Override
    public Object handleDeniedInvocation(MethodInvocation methodInvocation, AuthorizationResult authorizationResult) {
        Object attribute = this.registry.getAttribute(methodInvocation);
        PreAuthorizeExpressionAttribute preAuthorizeAttribute = (PreAuthorizeExpressionAttribute)attribute;
        return preAuthorizeAttribute.getHandler().handleDeniedInvocation(methodInvocation, authorizationResult);
    }
}

