/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.derby.iapi.services.io.LimitInputStream;
import org.apache.derby.impl.load.ImportLobFile;
import org.apache.derby.impl.load.LoadError;

class ImportBlob
implements Blob {
    private ImportLobFile lobFile;
    private long blobPosition;
    private long blobLength;
    private byte[] blobData = null;

    public ImportBlob(ImportLobFile importLobFile, long l, long l2) {
        this.lobFile = importLobFile;
        this.blobPosition = l;
        this.blobLength = l2;
    }

    public ImportBlob(byte[] byArray) {
        this.blobData = byArray;
        this.blobLength = byArray.length;
    }

    @Override
    public long length() throws SQLException {
        return this.blobLength;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        try {
            if (this.blobData != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.blobData);
                LimitInputStream limitInputStream = new LimitInputStream(byteArrayInputStream);
                limitInputStream.setLimit((int)this.blobLength);
                return limitInputStream;
            }
            return this.lobFile.getBinaryStream(this.blobPosition, this.blobLength);
        }
        catch (Exception exception) {
            throw LoadError.unexpectedError(exception);
        }
    }

    @Override
    public byte[] getBytes(long l, int n) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public long position(byte[] byArray, long l) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public long position(Blob blob, long l) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public int setBytes(long l, byte[] byArray) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public OutputStream setBinaryStream(long l) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public void truncate(long l) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public void free() throws SQLException {
        throw this.methodNotImplemented();
    }

    private SQLException methodNotImplemented() {
        return LoadError.unexpectedError(new Exception("Method not implemented"));
    }
}

