/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm;

import org.hibernate.dialect.Dialect;
import org.hibernate.query.SemanticException;

public enum TemporalUnit {
    YEAR,
    QUARTER,
    MONTH,
    WEEK,
    DAY,
    HOUR,
    MINUTE,
    SECOND,
    NANOSECOND,
    DAY_OF_WEEK,
    DAY_OF_YEAR,
    DAY_OF_MONTH,
    WEEK_OF_MONTH,
    WEEK_OF_YEAR,
    OFFSET,
    TIMEZONE_HOUR,
    TIMEZONE_MINUTE,
    DATE,
    TIME,
    EPOCH,
    NATIVE;


    public String conversionFactor(TemporalUnit unit, Dialect dialect) {
        long to;
        if (unit == this) {
            return "";
        }
        if (unit.normalized() != this.normalized()) {
            throw new SemanticException("illegal unit conversion " + this + " to " + unit);
        }
        long from = this.normalizationFactor(dialect);
        if (from == (to = unit.normalizationFactor(dialect))) {
            return "";
        }
        return (from < to ? "/" : "*") + TemporalUnit.factorAsString(from < to ? to / from : from / to);
    }

    private long normalizationFactor(Dialect dialect) {
        long factor = 1L;
        switch (this) {
            case YEAR: {
                factor *= 4L;
            }
            case QUARTER: {
                factor *= 3L;
            }
            case MONTH: {
                break;
            }
            case WEEK: {
                factor *= 7L;
            }
            case DAY: {
                factor *= 24L;
            }
            case HOUR: {
                factor *= 60L;
            }
            case MINUTE: {
                factor *= 60L;
            }
            case EPOCH: 
            case SECOND: {
                factor *= 1000000000L;
            }
            case NANOSECOND: {
                break;
            }
            case NATIVE: {
                factor *= dialect.getFractionalSecondPrecisionInNanos();
                break;
            }
            default: {
                throw new SemanticException("inconvertible unit " + this);
            }
        }
        return factor;
    }

    private static String factorAsString(long factor) {
        int len;
        int chop;
        Object string = String.valueOf(factor);
        for (chop = len = ((String)string).length(); chop > 0 && ((String)string).charAt(chop - 1) == '0'; --chop) {
        }
        int e = len - chop;
        if (chop > 0 && e > 2) {
            string = ((String)string).substring(0, chop) + "e" + e;
        }
        return string;
    }

    public boolean isDateUnit() {
        switch (this) {
            case YEAR: 
            case QUARTER: 
            case MONTH: 
            case WEEK: 
            case DAY: 
            case DAY_OF_WEEK: 
            case DAY_OF_MONTH: 
            case DAY_OF_YEAR: 
            case WEEK_OF_MONTH: 
            case WEEK_OF_YEAR: {
                return true;
            }
        }
        return false;
    }

    public boolean isTimeUnit() {
        switch (this) {
            case HOUR: 
            case MINUTE: 
            case SECOND: 
            case NANOSECOND: 
            case NATIVE: 
            case TIMEZONE_HOUR: 
            case TIMEZONE_MINUTE: 
            case OFFSET: {
                return true;
            }
        }
        return false;
    }

    public TemporalUnit normalized() {
        switch (this) {
            case WEEK: 
            case DAY: 
            case HOUR: 
            case MINUTE: 
            case EPOCH: 
            case SECOND: 
            case NANOSECOND: 
            case NATIVE: {
                return NANOSECOND;
            }
            case YEAR: 
            case QUARTER: 
            case MONTH: {
                return MONTH;
            }
        }
        throw new SemanticException("illegal unit " + this);
    }

    public String toString() {
        return super.toString().toLowerCase();
    }
}

