/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria;

import java.util.List;
import java.util.Map;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.entities.EntityInstantiator;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.MatchMode;
import org.hibernate.envers.query.criteria.internal.FunctionFunctionAuditExpression;
import org.hibernate.envers.query.criteria.internal.PropertyFunctionAuditExpression;
import org.hibernate.envers.query.criteria.internal.SimpleFunctionAuditExpression;
import org.hibernate.envers.query.projection.AuditProjection;

public class AuditFunction
implements AuditProjection {
    private final String function;
    private final List<Object> arguments;

    public AuditFunction(String function, List<Object> arguments) {
        this.function = function;
        this.arguments = arguments;
    }

    public String getFunction() {
        return this.function;
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public AuditCriterion eq(Object value) {
        return new SimpleFunctionAuditExpression(this, value, "=");
    }

    public AuditCriterion ne(Object value) {
        return new SimpleFunctionAuditExpression(this, value, "<>");
    }

    public AuditCriterion like(Object value) {
        return new SimpleFunctionAuditExpression(this, value, " like ");
    }

    public AuditCriterion like(String value, MatchMode matchMode) {
        return new SimpleFunctionAuditExpression(this, matchMode.toMatchString(value), " like ");
    }

    public AuditCriterion gt(Object value) {
        return new SimpleFunctionAuditExpression(this, value, ">");
    }

    public AuditCriterion lt(Object value) {
        return new SimpleFunctionAuditExpression(this, value, "<");
    }

    public AuditCriterion le(Object value) {
        return new SimpleFunctionAuditExpression(this, value, "<=");
    }

    public AuditCriterion ge(Object value) {
        return new SimpleFunctionAuditExpression(this, value, ">=");
    }

    public AuditCriterion eqProperty(String propertyName) {
        return this.eqProperty(null, propertyName);
    }

    public AuditCriterion eqProperty(String alias, String propertyName) {
        return new PropertyFunctionAuditExpression(this, alias, propertyName, "=");
    }

    public AuditCriterion neProperty(String propertyName) {
        return this.neProperty(null, propertyName);
    }

    public AuditCriterion neProperty(String alias, String propertyName) {
        return new PropertyFunctionAuditExpression(this, alias, propertyName, "<>");
    }

    public AuditCriterion ltProperty(String propertyName) {
        return this.ltProperty(null, propertyName);
    }

    public AuditCriterion ltProperty(String alias, String propertyName) {
        return new PropertyFunctionAuditExpression(this, alias, propertyName, "<");
    }

    public AuditCriterion leProperty(String propertyName) {
        return this.leProperty(null, propertyName);
    }

    public AuditCriterion leProperty(String alias, String propertyName) {
        return new PropertyFunctionAuditExpression(this, alias, propertyName, "<=");
    }

    public AuditCriterion gtProperty(String propertyName) {
        return this.gtProperty(null, propertyName);
    }

    public AuditCriterion gtProperty(String alias, String propertyName) {
        return new PropertyFunctionAuditExpression(this, alias, propertyName, ">");
    }

    public AuditCriterion geProperty(String propertyName) {
        return this.geProperty(null, propertyName);
    }

    public AuditCriterion geProperty(String alias, String propertyName) {
        return new PropertyFunctionAuditExpression(this, alias, propertyName, ">=");
    }

    public AuditCriterion eqFunction(AuditFunction otherFunction) {
        return new FunctionFunctionAuditExpression(this, otherFunction, "=");
    }

    public AuditCriterion neFunction(AuditFunction otherFunction) {
        return new FunctionFunctionAuditExpression(this, otherFunction, "<>");
    }

    public AuditCriterion ltFunction(AuditFunction otherFunction) {
        return new FunctionFunctionAuditExpression(this, otherFunction, "<");
    }

    public AuditCriterion leFunction(AuditFunction otherFunction) {
        return new FunctionFunctionAuditExpression(this, otherFunction, "<=");
    }

    public AuditCriterion gtFunction(AuditFunction otherFunction) {
        return new FunctionFunctionAuditExpression(this, otherFunction, ">");
    }

    public AuditCriterion geFunction(AuditFunction otherFunction) {
        return new FunctionFunctionAuditExpression(this, otherFunction, ">=");
    }

    @Override
    public void addProjectionToQuery(EnversService enversService, AuditReaderImplementor auditReader, Map<String, String> aliasToEntityNameMap, Map<String, String> aliasToComponentPropertyNameMap, String baseAlias, QueryBuilder queryBuilder) {
        queryBuilder.addProjection(enversService.getConfig(), aliasToEntityNameMap, aliasToComponentPropertyNameMap, this);
    }

    @Override
    public Object convertQueryResult(EnversService enversService, EntityInstantiator entityInstantiator, String entityName, Number revision, Object value) {
        return value;
    }

    @Override
    public String getAlias(String baseAlias) {
        return baseAlias;
    }
}

