/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class JwtBearerGrantRequest
extends AbstractOAuth2AuthorizationGrantRequest {
    private final Jwt jwt;

    public JwtBearerGrantRequest(ClientRegistration clientRegistration, Jwt jwt) {
        super(AuthorizationGrantType.JWT_BEARER, clientRegistration);
        Assert.isTrue((boolean)AuthorizationGrantType.JWT_BEARER.equals((Object)clientRegistration.getAuthorizationGrantType()), (String)"clientRegistration.authorizationGrantType must be AuthorizationGrantType.JWT_BEARER");
        Assert.notNull((Object)jwt, (String)"jwt cannot be null");
        this.jwt = jwt;
    }

    public Jwt getJwt() {
        return this.jwt;
    }

    static MultiValueMap<String, String> defaultParameters(JwtBearerGrantRequest grantRequest) {
        ClientRegistration clientRegistration = grantRequest.getClientRegistration();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (!CollectionUtils.isEmpty(clientRegistration.getScopes())) {
            parameters.set((Object)"scope", (Object)StringUtils.collectionToDelimitedString(clientRegistration.getScopes(), (String)" "));
        }
        parameters.set((Object)"assertion", (Object)grantRequest.getJwt().getTokenValue());
        return parameters;
    }
}

