/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.config;

import com.tqdev.metrics.core.MetricRegistry;
import com.tqdev.metrics.jdbc.InstrumentedDataSource;
import com.xebialabs.deployit.core.config.JpaUtils$;
import com.xebialabs.deployit.core.config.SqlConfiguration$;
import com.xebialabs.deployit.core.config.db.DatabaseConfig;
import com.xebialabs.deployit.core.config.db.MainDatabase;
import com.xebialabs.deployit.core.config.db.ReportingDatabase;
import com.xebialabs.deployit.core.sql.SchemaInfo;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.SqlDialect$;
import com.xebialabs.deployit.core.sql.config.DatabaseDriverConfiguration$;
import com.xebialabs.deployit.core.sql.spring.DeployJdbcTemplate;
import com.zaxxer.hikari.HikariDataSource;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.ext.ClassLoaderForLiquibase;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.dao.annotation.PersistenceExceptionTranslationPostProcessor;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import scala.Function0;
import scala.None$;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Configuration
@EnableTransactionManagement
@EnableConfigurationProperties
@Import(value={MainDatabase.class, ReportingDatabase.class})
@ScalaSignature(bytes="\u0006\u0005\t-d\u0001\u0002\u000f\u001e\u0001!BQa\u000e\u0001\u0005\u0002aB\u0011b\u000f\u0001A\u0002\u0003\u0007I\u0011\u0001\u001f\t\u0013\r\u0003\u0001\u0019!a\u0001\n\u0003!\u0005\"\u0003&\u0001\u0001\u0004\u0005\t\u0015)\u0003>\u0011%a\u0006\u00011AA\u0002\u0013\u0005Q\fC\u0005b\u0001\u0001\u0007\t\u0019!C\u0001E\"IA\r\u0001a\u0001\u0002\u0003\u0006KA\u0018\u0005\u0006M\u0002!\ta\u001a\u0005\u0006\u007f\u0002!\ta\u001a\u0005\b\u0003\u0007\u0001A\u0011BA\u0003\u0011\u001d\ty\u0002\u0001C\u0001\u0003CAq!a\f\u0001\t\u0003\t\t\u0003C\u0004\u00024\u0001!\t!!\u000e\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H!9\u00111\f\u0001\u0005\u0002\u0005u\u0003bBAJ\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003O\u0003A\u0011AAU\u0011\u001d\tY\f\u0001C\u0001\u0003SCq!a0\u0001\t\u0003\t\t\rC\u0004\u0002P\u0002!\t!!1\t\u000f\u0005M\u0007\u0001\"\u0003\u0002V\u001e9!qD\u000f\t\u0002\t\u0005bA\u0002\u000f\u001e\u0011\u0003\u0011\u0019\u0003\u0003\u00048/\u0011\u0005!Q\u0005\u0005\b\u0005O9B\u0011\u0001B\u0015\u0011\u001d\u00119e\u0006C\u0005\u0005\u0013BqAa\u0016\u0018\t\u0003\u0011IF\u0001\tTc2\u001cuN\u001c4jOV\u0014\u0018\r^5p]*\u0011adH\u0001\u0007G>tg-[4\u000b\u0005\u0001\n\u0013\u0001B2pe\u0016T!AI\u0012\u0002\u0011\u0011,\u0007\u000f\\8zSRT!\u0001J\u0013\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u0014\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Is\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0004B]f\u0014VM\u001a\t\u0003aUj\u0011!\r\u0006\u0003eM\nQa\u001d7gi)T\u0011\u0001N\u0001\tOJL'P\u001f7fI&\u0011a'\r\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0011\b\u0005\u0002;\u00015\tQ$\u0001\u0007nC&tG)\u0019;bE\u0006\u001cX-F\u0001>!\tq\u0014)D\u0001@\u0015\t\u0001U$\u0001\u0002eE&\u0011!i\u0010\u0002\r\u001b\u0006Lg\u000eR1uC\n\f7/Z\u0001\u0011[\u0006Lg\u000eR1uC\n\f7/Z0%KF$\"!\u0012%\u0011\u0005)2\u0015BA$,\u0005\u0011)f.\u001b;\t\u000f%\u001b\u0011\u0011!a\u0001{\u0005\u0019\u0001\u0010J\u0019\u0002\u001b5\f\u0017N\u001c#bi\u0006\u0014\u0017m]3!Q\u0011!AJW.\u0011\u00055CV\"\u0001(\u000b\u0005=\u0003\u0016AC1o]>$\u0018\r^5p]*\u0011\u0011KU\u0001\bM\u0006\u001cGo\u001c:z\u0015\t\u0019F+A\u0003cK\u0006t7O\u0003\u0002V-\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001X\u0003\ry'oZ\u0005\u00033:\u0013\u0011\"Q;u_^L'/\u001a3\u0002\u0011I,\u0017/^5sK\u0012L\u0012!A\u0001\u0012e\u0016\u0004xN\u001d;j]\u001e$\u0015\r^1cCN,W#\u00010\u0011\u0005yz\u0016B\u00011@\u0005E\u0011V\r]8si&tw\rR1uC\n\f7/Z\u0001\u0016e\u0016\u0004xN\u001d;j]\u001e$\u0015\r^1cCN,w\fJ3r)\t)5\rC\u0004J\r\u0005\u0005\t\u0019\u00010\u0002%I,\u0007o\u001c:uS:<G)\u0019;bE\u0006\u001cX\r\t\u0015\u0005\u000f1S6,\u0001\bnC&tG)\u0019;b'>,(oY3\u0016\u0003!\u0004\"!\u001b8\u000e\u0003)T!a\u001b7\u0002\u0007M\fHNC\u0001n\u0003\u0015Q\u0017M^1y\u0013\ty'N\u0001\u0006ECR\f7k\\;sG\u0016DC\u0001C9ysB\u0011!O^\u0007\u0002g*\u0011q\n\u001e\u0006\u0003kR\u000bqaY8oi\u0016DH/\u0003\u0002xg\n!!)Z1o\u00035!Wm\u001d;s_flU\r\u001e5pI\u0006\n!0A\u0003dY>\u001cX\r\u000b\u0002\tyB\u0011!/`\u0005\u0003}N\u0014q\u0001\u0015:j[\u0006\u0014\u00180A\nsKB|'\u000f^5oO\u0012\u000bG/Y*pkJ\u001cW\r\u000b\u0003\ncbL\u0018AF5ogR\u0014X/\\3oi\u0016$G)\u0019;b'>,(oY3\u0015\t\u0005\u001d\u00111\u0004\t\u0005\u0003\u0013\t9\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003\u0011QGMY2\u000b\t\u0005E\u00111C\u0001\b[\u0016$(/[2t\u0015\r\t)\"J\u0001\u0006iF$WM^\u0005\u0005\u00033\tYA\u0001\fJ]N$(/^7f]R,G\rR1uCN{WO]2f\u0011\u0019\tiB\u0003a\u0001Q\u0006QA-\u0019;b'>,(oY3\u0002\u00155\f\u0017N\\*dQ\u0016l\u0017-\u0006\u0002\u0002$A!\u0011QEA\u0015\u001b\t\t9C\u0003\u0002l?%!\u00111FA\u0014\u0005)\u00196\r[3nC&sgm\u001c\u0015\u0003\u0017E\fqB]3q_J$\u0018N\\4TG\",W.\u0019\u0015\u0003\u0019E\f\u0001#\\1j]*#'m\u0019+f[Bd\u0017\r^3\u0016\u0005\u0005]\u0002\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0001\niDC\u0002\u0002\u000eQKA!!\u0011\u0002<\ta!\n\u001a2d)\u0016l\u0007\u000f\\1uK\"\u0012Q\"]\u0001\u0015K:$\u0018\u000e^=NC:\fw-\u001a:GC\u000e$xN]=\u0015\u0005\u0005%\u0003\u0003BA&\u0003+j!!!\u0014\u000b\t\u0005=\u0013\u0011K\u0001\u0004UB\f'bAA*)\u0006\u0019qN]7\n\t\u0005]\u0013Q\n\u0002!\u0003\n\u001cHO]1di\u0016sG/\u001b;z\u001b\u0006t\u0017mZ3s\r\u0006\u001cGo\u001c:z\u0005\u0016\fg\u000e\u000b\u0002\u000fc\u0006\u0001r-\u001a;Ka\u0006\u0004&o\u001c9feRLWm\u001d\u000b\u0007\u0003?\n))!#\u0011\u000f\u0005\u0005\u00141NA8S5\u0011\u00111\r\u0006\u0005\u0003K\n9'\u0001\u0003vi&d'BAA5\u0003\u0011Q\u0017M^1\n\t\u00055\u00141\r\u0002\u0004\u001b\u0006\u0004\b\u0003BA9\u0003\u007frA!a\u001d\u0002|A\u0019\u0011QO\u0016\u000e\u0005\u0005]$bAA=O\u00051AH]8pizJ1!! ,\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011QAB\u0005\u0019\u0019FO]5oO*\u0019\u0011QP\u0016\t\u000f\u0005\u001du\u00021\u0001\u0002p\u0005yAM]5wKJ\u001cE.Y:t\u001d\u0006lW\rC\u0004\u0002\f>\u0001\r!!$\u0002\u0005\u0015l\u0007\u0003BA&\u0003\u001fKA!!%\u0002N\t1Cj\\2bY\u000e{g\u000e^1j]\u0016\u0014XI\u001c;jifl\u0015M\\1hKJ4\u0015m\u0019;pef\u0014U-\u00198\u0002)\u0015D8-\u001a9uS>tGK]1og2\fG/[8o+\t\t9\n\u0005\u0003\u0002\u001a\u0006\u0005VBAAN\u0015\ry\u0015Q\u0014\u0006\u0004\u0003?#\u0016a\u00013b_&!\u00111UAN\u00051\u0002VM]:jgR,gnY3Fq\u000e,\u0007\u000f^5p]R\u0013\u0018M\\:mCRLwN\u001c)pgR\u0004&o\\2fgN|'\u000f\u000b\u0002\u0011c\u00061R.Y5o)J\fgn]1di&|g.T1oC\u001e,'/\u0006\u0002\u0002,B!\u0011QVAZ\u001b\t\tyKC\u0002\u00022R\u000b1\u0002\u001e:b]N\f7\r^5p]&!\u0011QWAX\u0005i\u0001F.\u0019;g_JlGK]1og\u0006\u001cG/[8o\u001b\u0006t\u0017mZ3sQ\t\t\u0012\u000f\u000b\u0002\u0012y\u0006Y\"/\u001a9peRLgn\u001a+sC:\u001c\u0018m\u0019;j_:l\u0015M\\1hKJD#AE9\u0002-%t\u0017\u000e^5bY&TX-T1j]\u0012\u000bG/\u00192bg\u0016$\u0012!\u0012\u0015\u0004'\u0005\u0015\u0007\u0003BAd\u0003\u0017l!!!3\u000b\u0005=c\u0017\u0002BAg\u0003\u0013\u0014Q\u0002U8ti\u000e{gn\u001d;sk\u000e$\u0018aG5oSRL\u0017\r\\5{KJ+\u0007o\u001c:uS:<G)\u0019;bE\u0006\u001cX\rK\u0002\u0015\u0003\u000b\fq\"\u001e9eCR,G*[9vS\n\f7/\u001a\u000b\b\u000b\u0006]\u00171\\Ao\u0011\u001d\tI.\u0006a\u0001\u0003_\naa]2iK6\f\u0007BBA\u000f+\u0001\u0007\u0001\u000eC\u0004\u0002`V\u0001\r!!9\u0002\u000f\u0011L\u0017\r\\3diB!\u0011QEAr\u0013\u0011\t)/a\n\u0003\u0015M\u000bH\u000eR5bY\u0016\u001cG\u000fK\u0004\u0001\u0003S\fy/!=\u0011\u0007I\fY/C\u0002\u0002nN\u0014a!S7q_J$\u0018!\u0002<bYV,G\u0006BAz\u0003k\u001c\u0013!P\u0012\u0002=\"\u001a\u0001!!?\u0011\t\u0005m(qA\u0007\u0003\u0003{TA!a@\u0003\u0002\u0005Q\u0001O]8qKJ$\u0018.Z:\u000b\u0007U\u0014\u0019AC\u0002\u0003\u0006Q\u000bAAY8pi&!!\u0011BA\u007f\u0005u)e.\u00192mK\u000e{gNZ5hkJ\fG/[8o!J|\u0007/\u001a:uS\u0016\u001c\bf\u0001\u0001\u0003\u000eA!!q\u0002B\n\u001b\t\u0011\tBC\u0002P\u0003_KAA!\u0006\u0003\u0012\tYRI\\1cY\u0016$&/\u00198tC\u000e$\u0018n\u001c8NC:\fw-Z7f]RD3\u0001\u0001B\r!\r\u0011(1D\u0005\u0004\u0005;\u0019(!D\"p]\u001aLw-\u001e:bi&|g.\u0001\tTc2\u001cuN\u001c4jOV\u0014\u0018\r^5p]B\u0011!hF\n\u0003/%\"\"A!\t\u0002!!L7.\u0019:j\t\u0006$\u0018mU8ve\u000e,GC\u0002B\u0016\u0005w\u0011\u0019\u0005\u0005\u0003\u0003.\t]RB\u0001B\u0018\u0015\u0011\u0011\tDa\r\u0002\r!L7.\u0019:j\u0015\r\u0011)$J\u0001\u0007u\u0006D\b0\u001a:\n\t\te\"q\u0006\u0002\u0011\u0011&\\\u0017M]5ECR\f7k\\;sG\u0016DaAH\rA\u0002\tu\u0002c\u0001 \u0003@%\u0019!\u0011I \u0003\u001d\u0011\u000bG/\u00192bg\u0016\u001cuN\u001c4jO\"9!QI\rA\u0002\u0005=\u0014\u0001\u00028b[\u0016\fA\u0002[5lCJL7i\u001c8gS\u001e$bAa\u0013\u0003R\tM\u0003\u0003\u0002B\u0017\u0005\u001bJAAa\u0014\u00030\ta\u0001*[6be&\u001cuN\u001c4jO\"1aD\u0007a\u0001\u0005{AqA!\u0016\u001b\u0001\u0004\ty'\u0001\u0005q_>dg*Y7f\u0003Aa\u0017.];jE\u0006\u001cXmQ8oi\u0016DH\u000f\u0006\u0004\u0002p\tm#Q\f\u0005\b\u0003?\\\u0002\u0019AAq\u0011\u001d\u0011yf\u0007a\u0001\u0005C\n1aY8o!\u0011\u0011\u0019Ga\u001a\u000e\u0005\t\u0015$bA6\u0002h%!!\u0011\u000eB3\u0005)\u0019uN\u001c8fGRLwN\u001c")
public class SqlConfiguration
implements Logging {
    @Autowired(required=true)
    private MainDatabase mainDatabase;
    @Autowired(required=true)
    private ReportingDatabase reportingDatabase;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String liquibaseContext(SqlDialect sqlDialect, Connection connection) {
        return SqlConfiguration$.MODULE$.liquibaseContext(sqlDialect, connection);
    }

    public static HikariDataSource hikariDataSource(DatabaseConfig databaseConfig, String string) {
        return SqlConfiguration$.MODULE$.hikariDataSource(databaseConfig, string);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlConfiguration sqlConfiguration = this;
        synchronized (sqlConfiguration) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public MainDatabase mainDatabase() {
        return this.mainDatabase;
    }

    public void mainDatabase_$eq(MainDatabase x$1) {
        this.mainDatabase = x$1;
    }

    public ReportingDatabase reportingDatabase() {
        return this.reportingDatabase;
    }

    public void reportingDatabase_$eq(ReportingDatabase x$1) {
        this.reportingDatabase = x$1;
    }

    @Primary
    @Bean(destroyMethod="close")
    public DataSource mainDataSource() {
        DatabaseDriverConfiguration$.MODULE$.mainDatabaseDriverClassName_$eq(this.mainDatabase().database().dbDriverClassname());
        return this.instrumentedDataSource((DataSource)SqlConfiguration$.MODULE$.hikariDataSource(this.mainDatabase().database(), "MainPool"));
    }

    @Bean(destroyMethod="close")
    public DataSource reportingDataSource() {
        DatabaseConfig database = this.reportingDatabase().database().hasConfigured() ? this.reportingDatabase().database() : this.mainDatabase().database();
        DatabaseDriverConfiguration$.MODULE$.reportingDatabaseDriverClassName_$eq(database.dbDriverClassname());
        return this.instrumentedDataSource((DataSource)SqlConfiguration$.MODULE$.hikariDataSource(database, "ReportingPool"));
    }

    private InstrumentedDataSource instrumentedDataSource(DataSource dataSource) {
        return new InstrumentedDataSource(dataSource, MetricRegistry.getInstance());
    }

    @Bean
    public SchemaInfo mainSchema() {
        SqlDialect dialect = SqlDialect$.MODULE$.initializeDialect(this.mainDataSource());
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(32).append("Detected SQL dialect for main: ").append(dialect).append(".").toString());
        return new SchemaInfo(dialect, Option$.MODULE$.apply((Object)this.mainDatabase().database().dbSchemaName()).orElse((Function0 & Serializable)() -> None$.MODULE$));
    }

    @Bean
    public SchemaInfo reportingSchema() {
        SqlDialect dialect = SqlDialect$.MODULE$.initializeDialect(this.reportingDataSource());
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(37).append("Detected SQL dialect for reporting: ").append(dialect).append(".").toString());
        return new SchemaInfo(dialect, Option$.MODULE$.apply((Object)this.reportingDatabase().database().dbSchemaName()).orElse((Function0 & Serializable)() -> None$.MODULE$));
    }

    @Bean
    public JdbcTemplate mainJdbcTemplate() {
        return new DeployJdbcTemplate(this.mainDataSource(), true);
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public AbstractEntityManagerFactoryBean entityManagerFactory() {
        void var1_1;
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setDataSource(this.mainDataSource());
        em.setJpaPropertyMap(this.getJpaProperties(this.mainDatabase().database().dbDriverClassname(), em));
        em.setPackagesToScan(new String[]{"com.xebialabs.deployit"});
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        em.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> getJpaProperties(String driverClassName, LocalContainerEntityManagerFactoryBean em) {
        void var3_3;
        Map properties = em.getJpaPropertyMap();
        String string = driverClassName.contains(JpaUtils$.MODULE$.DERBY_JDBC_DRIVER_CLASS_PATTERN()) ? properties.put(JpaUtils$.MODULE$.HIBERNATE_DIALECT_KEY(), JpaUtils$.MODULE$.DERBY_DIALECT_CLASS()) : (driverClassName.contains(JpaUtils$.MODULE$.DB2_JDBC_DRIVER_CLASS_PATTER()) ? properties.put(JpaUtils$.MODULE$.HIBERNATE_DIALECT_KEY(), JpaUtils$.MODULE$.DB2_DIALECT_CLASS()) : BoxedUnit.UNIT);
        return var3_3;
    }

    @Bean
    public PersistenceExceptionTranslationPostProcessor exceptionTranslation() {
        return new PersistenceExceptionTranslationPostProcessor();
    }

    @Primary
    @Bean
    public PlatformTransactionManager mainTransactionManager() {
        return new JpaTransactionManager(this.entityManagerFactory().getObject());
    }

    @Bean
    public PlatformTransactionManager reportingTransactionManager() {
        return new DataSourceTransactionManager(this.reportingDataSource());
    }

    @PostConstruct
    public void initializeMainDatabase() {
        this.updateLiquibase("db/changelog/db.changelog-master.yaml", this.mainDataSource(), this.mainSchema().sqlDialect());
    }

    @PostConstruct
    public void initializeReportingDatabase() {
        this.updateLiquibase("db/changelog/db.changelog-reporting.yaml", this.reportingDataSource(), this.reportingSchema().sqlDialect());
    }

    private void updateLiquibase(String schema, DataSource dataSource, SqlDialect dialect) {
        try (Connection connection = dataSource.getConnection();){
            String context = SqlConfiguration$.MODULE$.liquibaseContext(dialect, connection);
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(28).append("Detected liquibase context: ").append(context).toString());
            new Liquibase(schema, (ResourceAccessor)new ClassLoaderForLiquibase(), (DatabaseConnection)new JdbcConnection(connection)).update(context);
        }
    }

    public SqlConfiguration() {
        Logging.$init$((Logging)this);
    }
}

