/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.config;

import com.tqdev.metrics.core.MetricRegistry;
import com.tqdev.metrics.jdbc.InstrumentedDataSource;
import com.xebialabs.deployit.core.config.JpaUtils$;
import com.xebialabs.deployit.core.config.SqlConfiguration$;
import com.xebialabs.deployit.core.config.db.DatabaseConfig;
import com.xebialabs.deployit.core.config.db.MainDatabase;
import com.xebialabs.deployit.core.config.db.ReportingDatabase;
import com.xebialabs.deployit.core.metrics.XldDbMetricsTrackerFactory;
import com.xebialabs.deployit.core.sql.SchemaInfo;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.SqlDialect$;
import com.xebialabs.deployit.core.sql.config.DatabaseDriverConfiguration$;
import com.xebialabs.deployit.core.sql.spring.DeployJdbcTemplate;
import com.zaxxer.hikari.HikariDataSource;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.ext.ClassLoaderForLiquibase;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.dao.annotation.PersistenceExceptionTranslationPostProcessor;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import scala.Function0;
import scala.None$;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Configuration
@EnableTransactionManagement
@EnableConfigurationProperties
@Import(value={MainDatabase.class, ReportingDatabase.class, XldDbMetricsTrackerFactory.class})
@ScalaSignature(bytes="\u0006\u0005\t=e\u0001B\u0010!\u0001-BQA\u000f\u0001\u0005\u0002mB\u0011B\u0010\u0001A\u0002\u0003\u0007I\u0011A \t\u0013\u0019\u0003\u0001\u0019!a\u0001\n\u00039\u0005\"C'\u0001\u0001\u0004\u0005\t\u0015)\u0003A\u0011%y\u0006\u00011AA\u0002\u0013\u0005\u0001\rC\u0005e\u0001\u0001\u0007\t\u0019!C\u0001K\"Iq\r\u0001a\u0001\u0002\u0003\u0006K!\u0019\u0005\nS\u0002\u0001\r\u00111A\u0005\u0002)D\u0011\"\u001d\u0001A\u0002\u0003\u0007I\u0011\u0001:\t\u0013Q\u0004\u0001\u0019!A!B\u0013Y\u0007\"\u0002<\u0001\t\u00039\bBBA\u0010\u0001\u0011\u0005q\u000fC\u0004\u0002$\u0001!I!!\n\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@!9\u0011Q\n\u0001\u0005\u0002\u0005}\u0002bBA)\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003G\u0002A\u0011AA3\u0011\u001d\tI\b\u0001C\u0001\u0003wBq!!-\u0001\t\u0003\t\u0019\fC\u0004\u0002F\u0002!\t!a2\t\u000f\u0005e\u0007\u0001\"\u0001\u0002H\"9\u0011Q\u001c\u0001\u0005\u0002\u0005}\u0007bBAw\u0001\u0011\u0005\u0011q\u001c\u0005\b\u0003c\u0004A\u0011BAz\u000f\u001d\u0011y\u0004\tE\u0001\u0005\u00032aa\b\u0011\t\u0002\t\r\u0003B\u0002\u001e\u001b\t\u0003\u0011)\u0005C\u0004\u0003Hi!\tA!\u0013\t\u000f\t%$\u0004\"\u0003\u0003l!9!1\u0010\u000e\u0005\u0002\tu$\u0001E*rY\u000e{gNZ5hkJ\fG/[8o\u0015\t\t#%\u0001\u0004d_:4\u0017n\u001a\u0006\u0003G\u0011\nAaY8sK*\u0011QEJ\u0001\tI\u0016\u0004Hn\\=ji*\u0011q\u0005K\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!K\u0001\u0004G>l7\u0001A\n\u0004\u00011\u0012\u0004CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#AB!osJ+g\r\u0005\u00024q5\tAG\u0003\u00026m\u0005)1\u000f\u001c45U*\tq'\u0001\u0005he&T(\u0010\\3e\u0013\tIDGA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005a\u0004CA\u001f\u0001\u001b\u0005\u0001\u0013\u0001D7bS:$\u0015\r^1cCN,W#\u0001!\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r\u0003\u0013A\u00013c\u0013\t)%I\u0001\u0007NC&tG)\u0019;bE\u0006\u001cX-\u0001\tnC&tG)\u0019;bE\u0006\u001cXm\u0018\u0013fcR\u0011\u0001j\u0013\t\u0003[%K!A\u0013\u0018\u0003\tUs\u0017\u000e\u001e\u0005\b\u0019\u000e\t\t\u00111\u0001A\u0003\rAH%M\u0001\u000e[\u0006Lg\u000eR1uC\n\f7/\u001a\u0011)\t\u0011yUL\u0018\t\u0003!nk\u0011!\u0015\u0006\u0003%N\u000b!\"\u00198o_R\fG/[8o\u0015\t!V+A\u0004gC\u000e$xN]=\u000b\u0005Y;\u0016!\u00022fC:\u001c(B\u0001-Z\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001.\u0002\u0007=\u0014x-\u0003\u0002]#\nI\u0011)\u001e;po&\u0014X\rZ\u0001\te\u0016\fX/\u001b:fIf\t\u0011!A\tsKB|'\u000f^5oO\u0012\u000bG/\u00192bg\u0016,\u0012!\u0019\t\u0003\u0003\nL!a\u0019\"\u0003#I+\u0007o\u001c:uS:<G)\u0019;bE\u0006\u001cX-A\u000bsKB|'\u000f^5oO\u0012\u000bG/\u00192bg\u0016|F%Z9\u0015\u0005!3\u0007b\u0002'\u0007\u0003\u0003\u0005\r!Y\u0001\u0013e\u0016\u0004xN\u001d;j]\u001e$\u0015\r^1cCN,\u0007\u0005\u000b\u0003\b\u001fvs\u0016A\u0007=mI\u0012\u0013W*\u001a;sS\u000e\u001cHK]1dW\u0016\u0014h)Y2u_JLX#A6\u0011\u00051|W\"A7\u000b\u00059\u0014\u0013aB7fiJL7m]\u0005\u0003a6\u0014!\u0004\u00177e\t\nlU\r\u001e:jGN$&/Y2lKJ4\u0015m\u0019;pef\fa\u0004\u001f7e\t\nlU\r\u001e:jGN$&/Y2lKJ4\u0015m\u0019;pef|F%Z9\u0015\u0005!\u001b\bb\u0002'\n\u0003\u0003\u0005\ra[\u0001\u001cq2$GIY'fiJL7m\u001d+sC\u000e\\WM\u001d$bGR|'/\u001f\u0011)\u0005)y\u0015AD7bS:$\u0015\r^1T_V\u00148-Z\u000b\u0002qB\u0011\u0011P`\u0007\u0002u*\u00111\u0010`\u0001\u0004gFd'\"A?\u0002\u000b)\fg/\u0019=\n\u0005}T(A\u0003#bi\u0006\u001cv.\u001e:dK\":1\"a\u0001\u0002\u0012\u0005M\u0001\u0003BA\u0003\u0003\u001bi!!a\u0002\u000b\u0007I\u000bIAC\u0002\u0002\f]\u000bqaY8oi\u0016DH/\u0003\u0003\u0002\u0010\u0005\u001d!\u0001\u0002\"fC:\fQ\u0002Z3tiJ|\u00170T3uQ>$\u0017EAA\u000b\u0003\u0015\u0019Gn\\:fQ\rY\u0011\u0011\u0004\t\u0005\u0003\u000b\tY\"\u0003\u0003\u0002\u001e\u0005\u001d!a\u0002)sS6\f'/_\u0001\u0014e\u0016\u0004xN\u001d;j]\u001e$\u0015\r^1T_V\u00148-\u001a\u0015\b\u0019\u0005\r\u0011\u0011CA\n\u0003YIgn\u001d;sk6,g\u000e^3e\t\u0006$\u0018mU8ve\u000e,G\u0003BA\u0014\u0003s\u0001B!!\u000b\u000265\u0011\u00111\u0006\u0006\u0005\u0003[\ty#\u0001\u0003kI\n\u001c'b\u00018\u00022)\u0019\u00111\u0007\u0015\u0002\u000bQ\fH-\u001a<\n\t\u0005]\u00121\u0006\u0002\u0017\u0013:\u001cHO];nK:$X\r\u001a#bi\u0006\u001cv.\u001e:dK\"1\u00111H\u0007A\u0002a\f!\u0002Z1uCN{WO]2f\u0003)i\u0017-\u001b8TG\",W.Y\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002H5\u0011\u0011Q\t\u0006\u0003w\nJA!!\u0013\u0002F\tQ1k\u00195f[\u0006LeNZ8)\u00079\t\u0019!A\bsKB|'\u000f^5oON\u001b\u0007.Z7bQ\ry\u00111A\u0001\u0011[\u0006LgN\u00133cGR+W\u000e\u001d7bi\u0016,\"!!\u0016\u0011\t\u0005]\u0013QL\u0007\u0003\u00033R1aIA.\u0015\r\ticV\u0005\u0005\u0003?\nIF\u0001\u0007KI\n\u001cG+Z7qY\u0006$X\rK\u0002\u0011\u0003\u0007\tA#\u001a8uSRLX*\u00198bO\u0016\u0014h)Y2u_JLHCAA4!\u0011\tI'a\u001d\u000e\u0005\u0005-$\u0002BA7\u0003_\n1A\u001b9b\u0015\r\t\thV\u0001\u0004_Jl\u0017\u0002BA;\u0003W\u0012\u0001%\u00112tiJ\f7\r^#oi&$\u00180T1oC\u001e,'OR1di>\u0014\u0018PQ3b]\"\u001a\u0011#a\u0001\u0002!\u001d,GO\u00139b!J|\u0007/\u001a:uS\u0016\u001cHCBA?\u0003G\u000b9\u000bE\u0004\u0002\u0000\u0005%\u0015Q\u0012\u0017\u000e\u0005\u0005\u0005%\u0002BAB\u0003\u000b\u000bA!\u001e;jY*\u0011\u0011qQ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\f\u0006\u0005%aA'baB!\u0011qRAO\u001d\u0011\t\t*!'\u0011\u0007\u0005Me&\u0004\u0002\u0002\u0016*\u0019\u0011q\u0013\u0016\u0002\rq\u0012xn\u001c;?\u0013\r\tYJL\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0015\u0011\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005me\u0006C\u0004\u0002&J\u0001\r!!$\u0002\u001f\u0011\u0014\u0018N^3s\u00072\f7o\u001d(b[\u0016Dq!!+\u0013\u0001\u0004\tY+\u0001\u0002f[B!\u0011\u0011NAW\u0013\u0011\ty+a\u001b\u0003M1{7-\u00197D_:$\u0018-\u001b8fe\u0016sG/\u001b;z\u001b\u0006t\u0017mZ3s\r\u0006\u001cGo\u001c:z\u0005\u0016\fg.\u0001\u000bfq\u000e,\u0007\u000f^5p]R\u0013\u0018M\\:mCRLwN\\\u000b\u0003\u0003k\u0003B!a.\u0002@6\u0011\u0011\u0011\u0018\u0006\u0004%\u0006m&bAA_/\u0006\u0019A-Y8\n\t\u0005\u0005\u0017\u0011\u0018\u0002-!\u0016\u00148/[:uK:\u001cW-\u0012=dKB$\u0018n\u001c8Ue\u0006t7\u000f\\1uS>t\u0007k\\:u!J|7-Z:t_JD3aEA\u0002\u0003Yi\u0017-\u001b8Ue\u0006t7/Y2uS>tW*\u00198bO\u0016\u0014XCAAe!\u0011\tY-!5\u000e\u0005\u00055'bAAh/\u0006YAO]1og\u0006\u001cG/[8o\u0013\u0011\t\u0019.!4\u00035Ac\u0017\r\u001e4pe6$&/\u00198tC\u000e$\u0018n\u001c8NC:\fw-\u001a:)\u0007Q\t\u0019\u0001K\u0002\u0015\u00033\t1D]3q_J$\u0018N\\4Ue\u0006t7/Y2uS>tW*\u00198bO\u0016\u0014\bfA\u000b\u0002\u0004\u00051\u0012N\\5uS\u0006d\u0017N_3NC&tG)\u0019;bE\u0006\u001cX\rF\u0001IQ\r1\u00121\u001d\t\u0005\u0003K\fI/\u0004\u0002\u0002h*\u0011!\u000b`\u0005\u0005\u0003W\f9OA\u0007Q_N$8i\u001c8tiJ,8\r^\u0001\u001cS:LG/[1mSj,'+\u001a9peRLgn\u001a#bi\u0006\u0014\u0017m]3)\u0007]\t\u0019/A\bva\u0012\fG/\u001a'jcVL'-Y:f)\u001dA\u0015Q_A}\u0003wDq!a>\u0019\u0001\u0004\ti)\u0001\u0004tG\",W.\u0019\u0005\u0007\u0003wA\u0002\u0019\u0001=\t\u000f\u0005u\b\u00041\u0001\u0002\u0000\u00069A-[1mK\u000e$\b\u0003BA\"\u0005\u0003IAAa\u0001\u0002F\tQ1+\u001d7ES\u0006dWm\u0019;)\u000f\u0001\u00119A!\u0004\u0003\u0010A!\u0011Q\u0001B\u0005\u0013\u0011\u0011Y!a\u0002\u0003\r%k\u0007o\u001c:u\u0003\u00151\u0018\r\\;fY\u0019\u0011\tBa\u0005\u0003\u0016\r\n\u0001iI\u0001bG\u0005Y\u0007f\u0001\u0001\u0003\u001aA!!1\u0004B\u0014\u001b\t\u0011iB\u0003\u0003\u0003 \t\u0005\u0012A\u00039s_B,'\u000f^5fg*!\u00111\u0002B\u0012\u0015\r\u0011)cV\u0001\u0005E>|G/\u0003\u0003\u0003*\tu!!H#oC\ndWmQ8oM&<WO]1uS>t\u0007K]8qKJ$\u0018.Z:)\u0007\u0001\u0011i\u0003\u0005\u0003\u00030\tMRB\u0001B\u0019\u0015\r\u0011\u0016QZ\u0005\u0005\u0005k\u0011\tDA\u000eF]\u0006\u0014G.\u001a+sC:\u001c\u0018m\u0019;j_:l\u0015M\\1hK6,g\u000e\u001e\u0015\u0004\u0001\te\u0002\u0003BA\u0003\u0005wIAA!\u0010\u0002\b\ti1i\u001c8gS\u001e,(/\u0019;j_:\f\u0001cU9m\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005uR2C\u0001\u000e-)\t\u0011\t%\u0001\tiS.\f'/\u001b#bi\u0006\u001cv.\u001e:dKRA!1\nB.\u0005G\u00129\u0007\u0005\u0003\u0003N\t]SB\u0001B(\u0015\u0011\u0011\tFa\u0015\u0002\r!L7.\u0019:j\u0015\r\u0011)\u0006K\u0001\u0007u\u0006D\b0\u001a:\n\t\te#q\n\u0002\u0011\u0011&\\\u0017M]5ECR\f7k\\;sG\u0016Da!\t\u000fA\u0002\tu\u0003cA!\u0003`%\u0019!\u0011\r\"\u0003\u001d\u0011\u000bG/\u00192bg\u0016\u001cuN\u001c4jO\"9!Q\r\u000fA\u0002\u00055\u0015\u0001\u00028b[\u0016DQ!\u001b\u000fA\u0002-\fA\u0002[5lCJL7i\u001c8gS\u001e$\u0002B!\u001c\u0003t\tU$\u0011\u0010\t\u0005\u0005\u001b\u0012y'\u0003\u0003\u0003r\t=#\u0001\u0004%jW\u0006\u0014\u0018nQ8oM&<\u0007BB\u0011\u001e\u0001\u0004\u0011i\u0006C\u0004\u0003xu\u0001\r!!$\u0002\u0011A|w\u000e\u001c(b[\u0016DQ![\u000fA\u0002-\f\u0001\u0003\\5rk&\u0014\u0017m]3D_:$X\r\u001f;\u0015\r\u00055%q\u0010BA\u0011\u001d\tiP\ba\u0001\u0003\u007fDqAa!\u001f\u0001\u0004\u0011))A\u0002d_:\u0004BAa\"\u0003\f6\u0011!\u0011\u0012\u0006\u0004w\u0006\u0015\u0015\u0002\u0002BG\u0005\u0013\u0013!bQ8o]\u0016\u001cG/[8o\u0001")
public class SqlConfiguration
implements Logging {
    @Autowired(required=true)
    private MainDatabase mainDatabase;
    @Autowired(required=true)
    private ReportingDatabase reportingDatabase;
    @Autowired
    private XldDbMetricsTrackerFactory xldDbMetricsTrackerFactory;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static String liquibaseContext(SqlDialect sqlDialect, Connection connection) {
        return SqlConfiguration$.MODULE$.liquibaseContext(sqlDialect, connection);
    }

    public static HikariDataSource hikariDataSource(DatabaseConfig databaseConfig, String string, XldDbMetricsTrackerFactory xldDbMetricsTrackerFactory) {
        return SqlConfiguration$.MODULE$.hikariDataSource(databaseConfig, string, xldDbMetricsTrackerFactory);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlConfiguration sqlConfiguration = this;
        synchronized (sqlConfiguration) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public MainDatabase mainDatabase() {
        return this.mainDatabase;
    }

    public void mainDatabase_$eq(MainDatabase x$1) {
        this.mainDatabase = x$1;
    }

    public ReportingDatabase reportingDatabase() {
        return this.reportingDatabase;
    }

    public void reportingDatabase_$eq(ReportingDatabase x$1) {
        this.reportingDatabase = x$1;
    }

    public XldDbMetricsTrackerFactory xldDbMetricsTrackerFactory() {
        return this.xldDbMetricsTrackerFactory;
    }

    public void xldDbMetricsTrackerFactory_$eq(XldDbMetricsTrackerFactory x$1) {
        this.xldDbMetricsTrackerFactory = x$1;
    }

    @Primary
    @Bean(destroyMethod="close")
    public DataSource mainDataSource() {
        DatabaseDriverConfiguration$.MODULE$.mainDatabaseDriverClassName_$eq(this.mainDatabase().database().dbDriverClassname());
        return this.instrumentedDataSource((DataSource)SqlConfiguration$.MODULE$.hikariDataSource(this.mainDatabase().database(), "MainPool", this.xldDbMetricsTrackerFactory()));
    }

    @Bean(destroyMethod="close")
    public DataSource reportingDataSource() {
        DatabaseConfig database = this.reportingDatabase().database().hasConfigured() ? this.reportingDatabase().database() : this.mainDatabase().database();
        DatabaseDriverConfiguration$.MODULE$.reportingDatabaseDriverClassName_$eq(database.dbDriverClassname());
        return this.instrumentedDataSource((DataSource)SqlConfiguration$.MODULE$.hikariDataSource(database, "ReportingPool", this.xldDbMetricsTrackerFactory()));
    }

    private InstrumentedDataSource instrumentedDataSource(DataSource dataSource) {
        return new InstrumentedDataSource(dataSource, MetricRegistry.getInstance());
    }

    @Bean
    public SchemaInfo mainSchema() {
        SqlDialect dialect = SqlDialect$.MODULE$.initializeDialect(this.mainDataSource());
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(32).append("Detected SQL dialect for main: ").append(dialect).append(".").toString());
        return new SchemaInfo(dialect, Option$.MODULE$.apply((Object)this.mainDatabase().database().dbSchemaName()).orElse((Function0 & Serializable)() -> None$.MODULE$));
    }

    @Bean
    public SchemaInfo reportingSchema() {
        SqlDialect dialect = SqlDialect$.MODULE$.initializeDialect(this.reportingDataSource());
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(37).append("Detected SQL dialect for reporting: ").append(dialect).append(".").toString());
        return new SchemaInfo(dialect, Option$.MODULE$.apply((Object)this.reportingDatabase().database().dbSchemaName()).orElse((Function0 & Serializable)() -> None$.MODULE$));
    }

    @Bean
    public JdbcTemplate mainJdbcTemplate() {
        return new DeployJdbcTemplate(this.mainDataSource(), true);
    }

    /*
     * WARNING - void declaration
     */
    @Bean
    public AbstractEntityManagerFactoryBean entityManagerFactory() {
        void var1_1;
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setDataSource(this.mainDataSource());
        em.setJpaPropertyMap(this.getJpaProperties(this.mainDatabase().database().dbDriverClassname(), em));
        em.setPackagesToScan(new String[]{"com.xebialabs.deployit"});
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        em.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> getJpaProperties(String driverClassName, LocalContainerEntityManagerFactoryBean em) {
        void var3_3;
        Map properties = em.getJpaPropertyMap();
        String string = driverClassName.contains(JpaUtils$.MODULE$.DERBY_JDBC_DRIVER_CLASS_PATTERN()) ? properties.put(JpaUtils$.MODULE$.HIBERNATE_DIALECT_KEY(), JpaUtils$.MODULE$.DERBY_DIALECT_CLASS()) : (driverClassName.contains(JpaUtils$.MODULE$.DB2_JDBC_DRIVER_CLASS_PATTER()) ? properties.put(JpaUtils$.MODULE$.HIBERNATE_DIALECT_KEY(), JpaUtils$.MODULE$.DB2_DIALECT_CLASS()) : BoxedUnit.UNIT);
        return var3_3;
    }

    @Bean
    public PersistenceExceptionTranslationPostProcessor exceptionTranslation() {
        return new PersistenceExceptionTranslationPostProcessor();
    }

    @Primary
    @Bean
    public PlatformTransactionManager mainTransactionManager() {
        return new JpaTransactionManager(this.entityManagerFactory().getObject());
    }

    @Bean
    public PlatformTransactionManager reportingTransactionManager() {
        return new DataSourceTransactionManager(this.reportingDataSource());
    }

    @PostConstruct
    public void initializeMainDatabase() {
        this.updateLiquibase("db/changelog/db.changelog-master.yaml", this.mainDataSource(), this.mainSchema().sqlDialect());
    }

    @PostConstruct
    public void initializeReportingDatabase() {
        this.updateLiquibase("db/changelog/db.changelog-reporting.yaml", this.reportingDataSource(), this.reportingSchema().sqlDialect());
    }

    private void updateLiquibase(String schema, DataSource dataSource, SqlDialect dialect) {
        try (Connection connection = dataSource.getConnection();){
            String context = SqlConfiguration$.MODULE$.liquibaseContext(dialect, connection);
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(28).append("Detected liquibase context: ").append(context).toString());
            new Liquibase(schema, (ResourceAccessor)new ClassLoaderForLiquibase(), (DatabaseConnection)new JdbcConnection(connection)).update(context);
        }
    }

    public SqlConfiguration() {
        Logging.$init$((Logging)this);
    }
}

