/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.database.anonymizer;

import ai.digital.configuration.central.deploy.db.DatabaseProperties;
import ai.digital.configuration.central.deploy.db.MainDatabase;
import ai.digital.configuration.central.deploy.db.ReportingProperties;
import ai.digital.deploy.core.common.XldServerPaths$;
import com.xebialabs.database.anonymizer.DatabaseName$;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.util.Properties;
import javax.crypto.SecretKey;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.ForwardOnlyResultSetTableFactory;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.dbunit.ext.db2.Db2DataTypeFactory;
import org.dbunit.ext.mssql.InsertIdentityOperation;
import org.dbunit.ext.mssql.MsSqlDataTypeFactory;
import org.dbunit.ext.mysql.MySqlDataTypeFactory;
import org.dbunit.ext.oracle.OracleDataTypeFactory;
import org.dbunit.ext.postgresql.PostgresqlDataTypeFactory;
import org.dbunit.operation.DatabaseOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import scala.Enumeration;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Repository
@ScalaSignature(bytes="\u0006\u0005\u0005Ud\u0001\u0002\n\u0014\u0001qAQa\t\u0001\u0005\u0002\u0011B\u0011b\n\u0001A\u0002\u0003\u0007I\u0011\u0001\u0015\t\u0013e\u0002\u0001\u0019!a\u0001\n\u0003Q\u0004\"\u0003!\u0001\u0001\u0004\u0005\t\u0015)\u0003*\u0011%\u0011\u0006\u00011AA\u0002\u0013\u00051\u000bC\u0005X\u0001\u0001\u0007\t\u0019!C\u00011\"I!\f\u0001a\u0001\u0002\u0003\u0006K\u0001\u0016\u0005\u00069\u0002!I!\u0018\u0005\u0006W\u0002!I\u0001\u001c\u0005\u0006c\u0002!IA\u001d\u0005\u0006u\u0002!Ia\u001f\u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000fAq!a\t\u0001\t\u0013\t)\u0003C\u0004\u0002<\u0001!\t!!\u0010\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002D!9\u0011q\u000b\u0001\u0005\u0002\u0005e#A\u0005#bi\u0006\u0014\u0017m]3SKB|7/\u001b;pefT!\u0001F\u000b\u0002\u0015\u0005twN\\=nSj,'O\u0003\u0002\u0017/\u0005AA-\u0019;bE\u0006\u001cXM\u0003\u0002\u00193\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00025\u0005\u00191m\\7\u0004\u0001M\u0011\u0001!\b\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005)\u0003C\u0001\u0014\u0001\u001b\u0005\u0019\u0012\u0001D7bS:$\u0015\r^1cCN,W#A\u0015\u0011\u0005):T\"A\u0016\u000b\u00051j\u0013A\u00013c\u0015\tqs&\u0001\u0004eKBdw.\u001f\u0006\u0003aE\nqaY3oiJ\fGN\u0003\u00023g\u0005i1m\u001c8gS\u001e,(/\u0019;j_:T!\u0001N\u001b\u0002\u000f\u0011Lw-\u001b;bY*\ta'\u0001\u0002bS&\u0011\u0001h\u000b\u0002\r\u001b\u0006Lg\u000eR1uC\n\f7/Z\u0001\u0011[\u0006Lg\u000eR1uC\n\f7/Z0%KF$\"a\u000f \u0011\u0005ya\u0014BA\u001f \u0005\u0011)f.\u001b;\t\u000f}\u001a\u0011\u0011!a\u0001S\u0005\u0019\u0001\u0010J\u0019\u0002\u001b5\f\u0017N\u001c#bi\u0006\u0014\u0017m]3!Q\u0011!!\tU)\u0011\u0005\rsU\"\u0001#\u000b\u0005\u00153\u0015AC1o]>$\u0018\r^5p]*\u0011q\tS\u0001\bM\u0006\u001cGo\u001c:z\u0015\tI%*A\u0003cK\u0006t7O\u0003\u0002L\u0019\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001N\u0003\ry'oZ\u0005\u0003\u001f\u0012\u0013\u0011\"Q;u_^L'/\u001a3\u0002\u0011I,\u0017/^5sK\u0012L\u0012!A\u0001\u0014e\u0016\u0004xN\u001d;j]\u001e\u0004&o\u001c9feRLWm]\u000b\u0002)B\u0011!&V\u0005\u0003-.\u00121CU3q_J$\u0018N\\4Qe>\u0004XM\u001d;jKN\fqC]3q_J$\u0018N\\4Qe>\u0004XM\u001d;jKN|F%Z9\u0015\u0005mJ\u0006bB \u0007\u0003\u0003\u0005\r\u0001V\u0001\u0015e\u0016\u0004xN\u001d;j]\u001e\u0004&o\u001c9feRLWm\u001d\u0011)\t\u001d\u0011\u0005+U\u0001\u0014O\u0016$HI]5wKJ\u001cuN\u001c8fGRLwN\u001c\u000b\u0003=\u001a\u0004\"a\u00183\u000e\u0003\u0001T!!\u00192\u0002\u0007M\fHNC\u0001d\u0003\u0011Q\u0017M^1\n\u0005\u0015\u0004'AC\"p]:,7\r^5p]\")q\r\u0003a\u0001Q\u0006i\u0011n\u001d*fa>\u0014H/\u001b8h\t\n\u0004\"AH5\n\u0005)|\"a\u0002\"p_2,\u0017M\\\u0001\tI\n$%/\u001b<feR\u0011Q\u000e\u001d\t\u0003?:L!a\u001c1\u0003\r\u0011\u0013\u0018N^3s\u0011\u00159\u0017\u00021\u0001i\u00035!'m\u0011:fI\u0016tG/[1mgR\u00111/\u001f\t\u0003i^l\u0011!\u001e\u0006\u0003m\n\fA!\u001e;jY&\u0011\u00010\u001e\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\"B4\u000b\u0001\u0004A\u0017A\u00053bi\u0006\u0014\u0017m]3Qe>\u0004XM\u001d;jKN$\"\u0001`@\u0011\u0005)j\u0018B\u0001@,\u0005I!\u0015\r^1cCN,\u0007K]8qKJ$\u0018.Z:\t\u000b\u001d\\\u0001\u0019\u00015\u0002#%t\u0017\u000e^#oGJL\b\u000f^5p].+\u0017\u0010F\u0001<\u0003=9W\r\u001e#bi\u0006\u0014\u0017m]3OC6,G\u0003BA\u0005\u0003?\u0001B!a\u0003\u0002\u001a9!\u0011QBA\u000b!\r\tyaH\u0007\u0003\u0003#Q1!a\u0005\u001c\u0003\u0019a$o\\8u}%\u0019\u0011qC\u0010\u0002\rA\u0013X\rZ3g\u0013\u0011\tY\"!\b\u0003\rM#(/\u001b8h\u0015\r\t9b\b\u0005\u0007\u0003Ci\u0001\u0019\u00010\u0002\u0015\r|gN\\3di&|g.\u0001\u000bva\u0012\fG/\u001a#bi\u0006\u0014\u0017m]3D_:4\u0017n\u001a\u000b\u0006w\u0005\u001d\u0012q\u0007\u0005\b\u0003Cq\u0001\u0019AA\u0015!\u0011\tY#a\r\u000e\u0005\u00055\"b\u0001\f\u00020)\u0019\u0011\u0011\u0007'\u0002\r\u0011\u0014WO\\5u\u0013\u0011\t)$!\f\u0003%\u0011\u000bG/\u00192bg\u0016\u001cuN\u001c8fGRLwN\u001c\u0005\b\u0003sq\u0001\u0019AA\u0005\u00031!\u0017\r^1cCN,g*Y7f\u0003U9W\r\u001e#bi\u0006\u0014\u0017m]3D_:tWm\u0019;j_:$B!!\u000b\u0002@!)qm\u0004a\u0001Q\u0006!r-\u001a;ECR\f'-Y:f\u001fB,'/\u0019;j_:$b!!\u0012\u0002R\u0005M\u0003\u0003BA$\u0003\u001bj!!!\u0013\u000b\t\u0005-\u0013qF\u0001\n_B,'/\u0019;j_:LA!a\u0014\u0002J\t\tB)\u0019;bE\u0006\u001cXm\u00149fe\u0006$\u0018n\u001c8\t\u000f\u0005e\u0002\u00031\u0001\u0002\n!1\u0011Q\u000b\tA\u0002!\f1\"[:EEJ+gM]3tQ\u0006)RM\\1cY\u0016\u0014\u0015\r^2i!J|7-Z:tS:<G#B\u001e\u0002\\\u0005u\u0003bBA\u0011#\u0001\u0007\u0011\u0011\u0006\u0005\b\u0003?\n\u0002\u0019AA1\u0003%\u0011\u0017\r^2i'&TX\rE\u0002\u001f\u0003GJ1!!\u001a \u0005\rIe\u000e\u001e\u0015\u0004\u0001\u0005%\u0004\u0003BA6\u0003cj!!!\u001c\u000b\u0007\u0005=$*\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!a\u001d\u0002n\tQ!+\u001a9pg&$xN]=")
public class DatabaseRepository {
    @Autowired(required=true)
    private MainDatabase mainDatabase;
    @Autowired(required=true)
    private ReportingProperties reportingProperties;

    public MainDatabase mainDatabase() {
        return this.mainDatabase;
    }

    public void mainDatabase_$eq(MainDatabase x$1) {
        this.mainDatabase = x$1;
    }

    public ReportingProperties reportingProperties() {
        return this.reportingProperties;
    }

    public void reportingProperties_$eq(ReportingProperties x$1) {
        this.reportingProperties = x$1;
    }

    private Connection getDriverConnection(boolean isReportingDb) {
        this.initEncryptionKey();
        Driver driver = this.dbDriver(isReportingDb);
        String dbUrl = this.databaseProperties(isReportingDb).dbUrl();
        Connection driverConnection = driver.connect(dbUrl, this.dbCredentials(isReportingDb));
        driverConnection.setAutoCommit(true);
        return driverConnection;
    }

    private Driver dbDriver(boolean isReportingDb) {
        return (Driver)Class.forName(this.databaseProperties(isReportingDb).dbDriverClassname()).newInstance();
    }

    /*
     * WARNING - void declaration
     */
    private Properties dbCredentials(boolean isReportingDb) {
        void var2_2;
        Properties properties = new Properties();
        properties.put("user", this.databaseProperties(isReportingDb).dbUsername());
        properties.put("password", this.databaseProperties(isReportingDb).dbPassword());
        return var2_2;
    }

    private DatabaseProperties databaseProperties(boolean isReportingDb) {
        return isReportingDb && this.reportingProperties().database().hasConfigured() ? this.reportingProperties().database() : this.mainDatabase().database();
    }

    private void initEncryptionKey() {
        ServerConfigFile serverConfigFile = new ServerConfigFile(XldServerPaths$.MODULE$.DEFAULT_CONFIGURATION_FILE());
        ServerConfiguration serverConfiguration = serverConfigFile.loadConfig(false, false, true);
        String repositoryKeyStorePassword = serverConfiguration.getRepositoryKeyStorePassword();
        SecretKey passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)repositoryKeyStorePassword);
        PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
    }

    public String getDatabaseName(Connection connection) {
        DatabaseMetaData metaData = connection.getMetaData();
        return metaData.getDatabaseProductName().toLowerCase();
    }

    private void updateDatabaseConfig(DatabaseConnection connection, String databaseName) {
        DatabaseConfig config = connection.getConfig();
        config.setProperty("http://www.dbunit.org/features/caseSensitiveTableNames", (Object)BoxesRunTime.boxToBoolean((boolean)true));
        config.setProperty("http://www.dbunit.org/features/qualifiedTableNames", (Object)BoxesRunTime.boxToBoolean((boolean)true));
        config.setProperty("http://www.dbunit.org/features/allowEmptyFields", (Object)BoxesRunTime.boxToBoolean((boolean)true));
        config.setProperty("http://www.dbunit.org/properties/resultSetTableFactory", (Object)new ForwardOnlyResultSetTableFactory());
        Enumeration.Value value = DatabaseName$.MODULE$.toValue(databaseName);
        Enumeration.Value value2 = DatabaseName$.MODULE$.Oracle();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new OracleDataTypeFactory());
            config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Enumeration.Value value4 = DatabaseName$.MODULE$.MSSQL();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new MsSqlDataTypeFactory());
                config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Enumeration.Value value6 = DatabaseName$.MODULE$.POSTGRES();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new PostgresqlDataTypeFactory());
                    config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Enumeration.Value value8 = DatabaseName$.MODULE$.MYSQL();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new MySqlDataTypeFactory());
                        config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"`?`");
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Enumeration.Value value10 = DatabaseName$.MODULE$.DB2();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new Db2DataTypeFactory());
                            config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            Enumeration.Value value12 = DatabaseName$.MODULE$.DEFAULT();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new DefaultDataTypeFactory());
                                config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                throw new MatchError((Object)value);
                            }
                        }
                    }
                }
            }
        }
    }

    public DatabaseConnection getDatabaseConnection(boolean isReportingDb) {
        Connection driverConnection = this.getDriverConnection(isReportingDb);
        DatabaseConnection connection = null;
        String databaseName = this.getDatabaseName(driverConnection);
        Enumeration.Value value = DatabaseName$.MODULE$.toValue(databaseName);
        Enumeration.Value value2 = DatabaseName$.MODULE$.Oracle();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            connection = new DatabaseConnection(driverConnection, driverConnection.getMetaData().getUserName());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Enumeration.Value value4 = DatabaseName$.MODULE$.MSSQL();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                connection = new DatabaseConnection(driverConnection, "dbo");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                connection = new DatabaseConnection(driverConnection);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        this.updateDatabaseConfig(connection, databaseName);
        return connection;
    }

    public DatabaseOperation getDatabaseOperation(String databaseName, boolean isDbRefresh) {
        Enumeration.Value value = DatabaseName$.MODULE$.toValue(databaseName);
        Enumeration.Value value2 = DatabaseName$.MODULE$.MSSQL();
        Enumeration.Value value3 = value;
        DatabaseOperation databaseOperation = !(value2 != null ? !value2.equals(value3) : value3 != null) ? (isDbRefresh ? InsertIdentityOperation.REFRESH : InsertIdentityOperation.INSERT) : (isDbRefresh ? DatabaseOperation.REFRESH : DatabaseOperation.INSERT);
        return databaseOperation;
    }

    public void enableBatchProcessing(DatabaseConnection connection, int batchSize) {
        connection.getConfig().setProperty("http://www.dbunit.org/properties/batchSize", (Object)BoxesRunTime.boxToInteger((int)batchSize));
        connection.getConfig().setProperty("http://www.dbunit.org/features/batchedStatements", (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }
}

