package com.xebialabs.database.anonymizer

import org.dbunit.database.{DatabaseSequenceFilter, IDatabaseConnection}
import org.dbunit.dataset.IDataSet
import scala.jdk.CollectionConverters._

class AnonymizerDatabaseSequenceFilter(val configuration: AnonymizerConfiguration, val connection: IDatabaseConnection)
  extends DatabaseSequenceFilter(connection) {

  private def tableNameIs(tableNameWithSchema: String, excludedTables: JList[String]): Boolean = {
    val lowerCasedName: String = tableNameWithSchema.toLowerCase
    val insensitiveTableNames = excludedTables.asScala.map(_.toLowerCase).toList
    if (lowerCasedName.contains(".")) {
      val tokens: Array[String] = lowerCasedName.split("\\.")
      val tableName: String = tokens(tokens.length - 1).toLowerCase
      return insensitiveTableNames.contains(tableName)
    }
    insensitiveTableNames.contains(lowerCasedName)
  }

  override def getTableNames(dataSet: IDataSet): Array[String] = {
    val tableNames: Array[String] = super.getTableNames(dataSet)

    tableNames.toList.filter((tableName: String) =>
      !tableNameIs(tableName, configuration.getTablesToNotExport())).toArray
  }
}
