package com.xebialabs.database.anonymizer

import org.dbunit.dataset.{ITable, ReplacementTable}
import org.slf4j.{Logger, LoggerFactory}

object XldReplacementTable {
  private val logger: Logger = LoggerFactory.getLogger(classOf[XldReplacementTable])
}

class XldReplacementTable(val table: ITable,
                          val objectMap: JMap[_, _],
                          val substringMap: JMap[_, _],
                          val startDelimiter: String,
                          val endDelimiter: String,
                          val tablesToAnonymize: List[TableColumnValue],
                          val fieldsToIgnore: List[EncryptedFieldToIgnore])
  extends ReplacementTable(table, objectMap, substringMap, startDelimiter, endDelimiter) {

  override def getValue(row: Int, column: String): Any = {
    XldReplacementTable.logger.debug("getValue(row={}, columnName={}) - start", row, column)
    val tableName: String = this.table.getTableMetaData.getTableName
    val tableWithSchema: Array[String] = tableName.split("\\.")

    for (replacement <- tablesToAnonymize) {
      if (tableWithSchema(tableWithSchema.length - 1) == replacement.getTable() && column == replacement.getColumn())
        return replacement.getValue()
    }
    val value: Any = super.getValue(row, column)
    for (replace <- fieldsToIgnore) {
      if (tableWithSchema(tableWithSchema.length - 1) == replace.getTable() && column == replace.getColumn())
        if (value != null && value.toString.matches(replace.getPasswordRegex())) return replace.getValue()
    }
    value
  }
}
