/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.jms.factory;

import com.xebialabs.deployit.core.config.ExternalConfig;
import com.xebialabs.deployit.core.config.TaskQueueBrokerConfig;
import com.xebialabs.deployit.core.config.XldConfig;
import com.xebialabs.xldeploy.jms.adapter.UnsupportedJmsConfigurationException;
import com.xebialabs.xldeploy.jms.config.ArtemisConfig;
import com.xebialabs.xldeploy.jms.factory.BaseJmsConnectionFactory;
import java.net.URI;
import javax.jms.ConnectionFactory;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u000113A!\u0002\u0004\u0001#!Aa\u0003\u0001B\u0001B\u0003%q\u0003\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0011\u00151\u0004\u0001\"\u00018\u0011\u00159\u0001\u0001\"\u0015>\u0005m\t%\u000f^3nSNTUn]\"p]:,7\r^5p]\u001a\u000b7\r^8ss*\u0011q\u0001C\u0001\bM\u0006\u001cGo\u001c:z\u0015\tI!\"A\u0002k[NT!a\u0003\u0007\u0002\u0011adG-\u001a9m_fT!!\u0004\b\u0002\u0013a,'-[1mC\n\u001c(\"A\b\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0015\u001b\u00051\u0011BA\u000b\u0007\u0005a\u0011\u0015m]3K[N\u001cuN\u001c8fGRLwN\u001c$bGR|'/_\u0001\nq2$7i\u001c8gS\u001e\u0004\"\u0001G\u0010\u000e\u0003eQ!AG\u000e\u0002\r\r|gNZ5h\u0015\taR$\u0001\u0003d_J,'B\u0001\u0010\r\u0003!!W\r\u001d7ps&$\u0018B\u0001\u0011\u001a\u0005%AF\u000eZ\"p]\u001aLw\r\u000b\u0002\u0002EA\u00111%L\u0007\u0002I)\u0011QEJ\u0001\u000bC:tw\u000e^1uS>t'BA\u0004(\u0015\tA\u0013&A\u0003cK\u0006t7O\u0003\u0002+W\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001-\u0003\ry'oZ\u0005\u0003]\u0011\u0012\u0011\"Q;u_^L'/\u001a3\u0002\u001b\u0005\u0014H/Z7jg\u000e{gNZ5h!\t\t4'D\u00013\u0015\tQ\u0002\"\u0003\u00025e\ti\u0011I\u001d;f[&\u001c8i\u001c8gS\u001eD#A\u0001\u0012\u0002\rqJg.\u001b;?)\rA\u0014h\u000f\t\u0003'\u0001AQAF\u0002A\u0002]A#!\u000f\u0012\t\u000b=\u001a\u0001\u0019\u0001\u0019)\u0005m\u0012C#\u0001 \u0011\u0005}\u001aU\"\u0001!\u000b\u0005%\t%\"\u0001\"\u0002\u000b)\fg/\u0019=\n\u0005\u0011\u0003%!E\"p]:,7\r^5p]\u001a\u000b7\r^8ss\"\u0012\u0001A\u0012\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013&\n!b\u001d;fe\u0016|G/\u001f9f\u0013\tY\u0005JA\u0005D_6\u0004xN\\3oi\u0002")
public class ArtemisJmsConnectionFactory
extends BaseJmsConnectionFactory {
    @Autowired
    private final XldConfig xldConfig;
    @Autowired
    private final ArtemisConfig artemisConfig;

    public ConnectionFactory factory() {
        ExternalConfig externalConfig;
        block3: {
            block2: {
                TaskQueueBrokerConfig taskQueueBrokerConfig = this.getTaskQueueConfig();
                if (!(taskQueueBrokerConfig instanceof ExternalConfig)) break block2;
                externalConfig = (ExternalConfig)taskQueueBrokerConfig;
                if (!this.xldConfig.inProcessTaskEngine()) break block3;
            }
            throw new UnsupportedJmsConfigurationException("Unsupported configuration: xl.task.in-process-worker should be set to 'false' to use external broker.");
        }
        URI uri = new URI(externalConfig.url());
        UDPBroadcastEndpointFactory udpConfig = new UDPBroadcastEndpointFactory();
        udpConfig.setGroupAddress(uri.getHost()).setGroupPort(uri.getPort());
        this.artemisConfig.localBindAddress().foreach((Function1 & java.io.Serializable & Serializable)x$1 -> udpConfig.setLocalBindAddress(x$1));
        this.artemisConfig.localBindPort().foreach((Function1 & java.io.Serializable & Serializable)x$1 -> udpConfig.setLocalBindPort(BoxesRunTime.unboxToInt((Object)x$1)));
        DiscoveryGroupConfiguration discoveryGroupConfig = new DiscoveryGroupConfiguration();
        discoveryGroupConfig.setBroadcastEndpointFactory((BroadcastEndpointFactory)udpConfig);
        ActiveMQConnectionFactory factory = ActiveMQJMSClient.createConnectionFactoryWithHA((DiscoveryGroupConfiguration)discoveryGroupConfig, (JMSFactoryType)JMSFactoryType.QUEUE_CF);
        factory.setUser(externalConfig.username());
        factory.setPassword(externalConfig.password());
        ActiveMQConnectionFactory activeMQConnectionFactory = factory;
        return activeMQConnectionFactory;
    }

    public ArtemisJmsConnectionFactory(@Autowired XldConfig xldConfig, @Autowired ArtemisConfig artemisConfig) {
        this.xldConfig = xldConfig;
        this.artemisConfig = artemisConfig;
        super(xldConfig);
    }
}

