/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.commands;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.spring.package;
import com.xebialabs.deployit.engine.spi.event.CiRenamedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactDataRepository;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.repository.sql.commands.ChangeSetContext;
import com.xebialabs.deployit.repository.sql.commands.UpdatePathCommand;
import com.xebialabs.deployit.sql.base.schema.CIS$;
import com.xebialabs.deployit.util.Tuple;
import java.io.Serializable;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001\u0002\b\u0010\u0001qA\u0001\"\t\u0001\u0003\u0006\u0004%\tE\t\u0005\t_\u0001\u0011\t\u0011)A\u0005G!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007\u0003\u00058\u0001\t\u0015\r\u0011\"\u00019\u0011!)\u0006A!A!\u0002\u0013I\u0004\u0002\u0003,\u0001\u0005\u000b\u0007I1A,\t\u0011y\u0003!\u0011!Q\u0001\naCQa\u0018\u0001\u0005\u0002\u0001DQa\u001a\u0001\u0005B!DQA\u001d\u0001\u0005BMDQ!\u001e\u0001\u0005\nYDq!!\u0005\u0001\t\u0013\t\u0019\u0002C\u0004\u0002\u001e\u0001!I!a\b\u0003\u001bI+g.Y7f\u0007>lW.\u00198e\u0015\t\u0001\u0012#\u0001\u0005d_6l\u0017M\u001c3t\u0015\t\u00112#A\u0002tc2T!\u0001F\u000b\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u0017/\u0005AA-\u001a9m_fLGO\u0003\u0002\u00193\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00025\u0005\u00191m\\7\u0004\u0001M\u0011\u0001!\b\t\u0003=}i\u0011aD\u0005\u0003A=\u0011\u0011#\u00169eCR,\u0007+\u0019;i\u0007>lW.\u00198e\u00031QGMY2UK6\u0004H.\u0019;f+\u0005\u0019\u0003C\u0001\u0013.\u001b\u0005)#B\u0001\u0014(\u0003\u0011\u0019wN]3\u000b\u0005!J\u0013\u0001\u00026eE\u000eT!AK\u0016\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001L\u0001\u0004_J<\u0017B\u0001\u0018&\u00051QEMY2UK6\u0004H.\u0019;f\u00035QGMY2UK6\u0004H.\u0019;fA\u0005\u0011\u0012M\u001d;jM\u0006\u001cGOU3q_NLGo\u001c:z!\t\u0011T'D\u00014\u0015\t!\u0014#A\u0005beRLg-Y2ug&\u0011ag\r\u0002\u0017\u0003J$\u0018NZ1di\u0012\u000bG/\u0019*fa>\u001c\u0018\u000e^8ss\u0006I!/\u001a8b[\u0016\u001c\u0015n]\u000b\u0002sA\u0019!\bR$\u000f\u0005m\neB\u0001\u001f@\u001b\u0005i$B\u0001 \u001c\u0003\u0019a$o\\8u}%\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u0007\u00069\u0001/Y2lC\u001e,'\"\u0001!\n\u0005\u00153%\u0001C%uKJ\f'\r\\3\u000b\u0005\t\u001b\u0005\u0003\u0002%L\u001b6k\u0011!\u0013\u0006\u0003\u0015V\tA!\u001e;jY&\u0011A*\u0013\u0002\u0006)V\u0004H.\u001a\t\u0003\u001dJs!a\u0014)\u0011\u0005q\u001a\u0015BA)D\u0003\u0019\u0001&/\u001a3fM&\u00111\u000b\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005E\u001b\u0015A\u0003:f]\u0006lWmQ5tA\u0005Q1/\u001d7ES\u0006dWm\u0019;\u0016\u0003a\u0003\"!\u0017/\u000e\u0003iS!AE.\u000b\u0005\u0019*\u0012BA/[\u0005)\u0019\u0016\u000f\u001c#jC2,7\r^\u0001\fgFdG)[1mK\u000e$\b%\u0001\u0004=S:LGO\u0010\u000b\u0005C\u0012,g\r\u0006\u0002cGB\u0011a\u0004\u0001\u0005\u0006-\"\u0001\u001d\u0001\u0017\u0005\u0006C!\u0001\ra\t\u0005\u0006a!\u0001\r!\r\u0005\u0006o!\u0001\r!O\u0001\bKb,7-\u001e;f)\tIW\u000e\u0005\u0002kW6\t1)\u0003\u0002m\u0007\n!QK\\5u\u0011\u0015q\u0017\u00021\u0001p\u0003\u001d\u0019wN\u001c;fqR\u0004\"A\b9\n\u0005E|!\u0001E\"iC:<WmU3u\u0007>tG/\u001a=u\u0003!1\u0018\r\\5eCR,GCA5u\u0011\u0015q'\u00021\u0001p\u0003\u0019\u0011XM\\1nKR\u0019\u0011n^=\t\u000ba\\\u0001\u0019A'\u0002\u000b=dG-\u00133\t\u000bi\\\u0001\u0019A'\u0002\u000f9,wOT1nK\"21\u0002`A\u0005\u0003\u0017\u00012!`A\u0003\u001b\u0005q(bA@\u0002\u0002\u0005!A.\u00198h\u0015\t\t\u0019!\u0001\u0003kCZ\f\u0017bAA\u0004}\n\u00012+\u001e9qe\u0016\u001c8oV1s]&twm]\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003\u001b\t#!a\u0004\u0002\u0007\u0005dG.\u0001\bwC2LG-\u0019;f%\u0016t\u0017-\\3\u0015\u000b%\f)\"a\u0006\t\u000bad\u0001\u0019A'\t\u000bid\u0001\u0019A')\r1a\u0018\u0011BA\u000eY\t\ti!A\nrk\u0016\u0014\u00180\u00118e!J,g+\u00197jI\u0006$X\r\u0006\u0004\u0002\"\u0005]\u0012\u0011\b\t\u0007U\u0006\rR*a\n\n\u0007\u0005\u00152I\u0001\u0004UkBdWM\r\t\b\u0003S\ti#TA\u0019\u001b\t\tYCC\u0002K\u0003\u0003IA!a\f\u0002,\t\u0019Q*\u00199\u0011\u0007u\f\u0019$C\u0002\u00026y\u0014aa\u00142kK\u000e$\b\"\u0002=\u000e\u0001\u0004i\u0005\"\u0002>\u000e\u0001\u0004i\u0005")
public class RenameCommand
extends UpdatePathCommand {
    private final JdbcTemplate jdbcTemplate;
    private final Iterable<Tuple<String, String>> renameCis;
    private final SqlDialect sqlDialect;

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public Iterable<Tuple<String, String>> renameCis() {
        return this.renameCis;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public void execute(ChangeSetContext context) {
        this.renameCis().foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.rename((String)t.a, (String)t.b);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void validate(ChangeSetContext context) {
        this.renameCis().foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.validateRename((String)t.a, (String)t.b);
            return BoxedUnit.UNIT;
        });
    }

    private void rename(String oldId, String newName) {
        String string;
        Map map;
        block3: {
            Tuple2<String, Map<String, Object>> tuple2;
            block2: {
                tuple2 = this.queryAndPreValidate(oldId, newName);
                if (tuple2 == null) break block2;
                String oldPath = (String)tuple2._1();
                map = (Map)tuple2._2();
                if (oldPath == null) break block2;
                string = oldPath;
                if (map != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        Map map2 = map;
        Tuple2 tuple2 = new Tuple2((Object)string, (Object)map2);
        Tuple2 tuple22 = tuple2;
        String oldPath = (String)tuple22._1();
        Map map3 = (Map)tuple22._2();
        this.updateNameAndPath(oldPath, new StringBuilder(1).append((String)package$.MODULE$.parentPath(oldId).get()).append("/").append(newName).toString());
        EventBusHolder.publish((Object)new CiRenamedEvent(package$.MODULE$.readBaseCiFromMap(map3), newName));
    }

    private void validateRename(String oldId, String newName) {
        this.queryAndPreValidate(oldId, newName);
        String newPath = new StringBuilder(1).append((String)package$.MODULE$.parentPath(oldId).get()).append("/").append(newName).toString();
        if (this.exists(newPath)) {
            throw new ItemAlreadyExistsException("The destination id [%s] exists.", new Object[]{package$.MODULE$.pathToId(newPath)});
        }
    }

    private Tuple2<String, Map<String, Object>> queryAndPreValidate(String oldId, String newName) {
        Type ciType;
        Checks.checkArgument((!new StringOps(Predef$.MODULE$.augmentString(newName)).contains((Object)BoxesRunTime.boxToCharacter((char)'/')) ? 1 : 0) != 0, (String)"New name [%s] should not contain a /", (Object[])new Object[]{newName});
        String oldPath = package$.MODULE$.idToPath(oldId);
        Map map = (Map)this.jdbcTemplate().queryForObject(this.SELECT_CI_BY_PATH(), (RowMapper)package.MapRowMapper$.MODULE$, new Object[]{oldPath});
        Type type = ciType = Type.valueOf((String)((String)map.get(CIS$.MODULE$.ci_type().name())));
        Type type2 = Type.valueOf(Root.class);
        if (!(type != null ? !type.equals(type2) : type2 != null)) {
            throw new DeployitException("Cannot rename a core.Root configuration item");
        }
        return new Tuple2((Object)oldPath, (Object)map);
    }

    public RenameCommand(JdbcTemplate jdbcTemplate, ArtifactDataRepository artifactRepository, Iterable<Tuple<String, String>> renameCis, SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.renameCis = renameCis;
        this.sqlDialect = sqlDialect;
        super(jdbcTemplate, artifactRepository);
    }
}

