/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.commands;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.package;
import com.xebialabs.deployit.engine.spi.event.CiMovedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactDataRepository;
import com.xebialabs.deployit.repository.sql.base.CIS$;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.repository.sql.commands.ChangeSetContext;
import com.xebialabs.deployit.repository.sql.commands.CiPathValidation;
import com.xebialabs.deployit.repository.sql.commands.UpdatePathCommand;
import com.xebialabs.deployit.repository.validation.CommandValidator;
import com.xebialabs.deployit.util.Tuple;
import java.io.Serializable;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\u0001\u0003\u0001=\u00111\"T8wK\u000e{W.\\1oI*\u00111\u0001B\u0001\tG>lW.\u00198eg*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003\u0013)\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003\u00171\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u00035\t1aY8n\u0007\u0001\u00192\u0001\u0001\t\u0015!\t\t\"#D\u0001\u0003\u0013\t\u0019\"AA\tVa\u0012\fG/\u001a)bi\"\u001cu.\\7b]\u0012\u0004\"!E\u000b\n\u0005Y\u0011!\u0001E\"j!\u0006$\bNV1mS\u0012\fG/[8o\u0011!A\u0002A!b\u0001\n\u0003J\u0012\u0001\u00046eE\u000e$V-\u001c9mCR,W#\u0001\u000e\u0011\u0005m!S\"\u0001\u000f\u000b\u0005uq\u0012\u0001B2pe\u0016T!a\b\u0011\u0002\t)$'m\u0019\u0006\u0003C\t\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002G\u0005\u0019qN]4\n\u0005\u0015b\"\u0001\u0004&eE\u000e$V-\u001c9mCR,\u0007\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u001b)$'m\u0019+f[Bd\u0017\r^3!\u0011!I\u0003A!A!\u0002\u0013Q\u0013AF1si&4\u0017m\u0019;ECR\f'+\u001a9pg&$xN]=\u0011\u0005-rS\"\u0001\u0017\u000b\u00055\"\u0011!C1si&4\u0017m\u0019;t\u0013\tyCF\u0001\fBeRLg-Y2u\t\u0006$\u0018MU3q_NLGo\u001c:z\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0014\u0001E2p[6\fg\u000e\u001a,bY&$\u0017\r^8s!\t\u0019d'D\u00015\u0015\t)d!\u0001\u0006wC2LG-\u0019;j_:L!a\u000e\u001b\u0003!\r{W.\\1oIZ\u000bG.\u001b3bi>\u0014\b\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\u0002\u000f5|g/Z\"jgB\u00191(\u0012%\u000f\u0005q\u0012eBA\u001fA\u001b\u0005q$BA \u000f\u0003\u0019a$o\\8u}%\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\t\u00069\u0001/Y2lC\u001e,'\"A!\n\u0005\u0019;%\u0001C%uKJ\f'\r\\3\u000b\u0005\r#\u0005\u0003B%M\u001d:k\u0011A\u0013\u0006\u0003\u0017\"\tA!\u001e;jY&\u0011QJ\u0013\u0002\u0006)V\u0004H.\u001a\t\u0003\u001fNs!\u0001U)\u0011\u0005u\"\u0015B\u0001*E\u0003\u0019\u0001&/\u001a3fM&\u0011A+\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I#\u0005\u0002C,\u0001\u0005\u000b\u0007I1\u0001-\u0002\u0015M\fH\u000eR5bY\u0016\u001cG/F\u0001Z!\tQV,D\u0001\\\u0015\t)AL\u0003\u0002\u001e\u0011%\u0011al\u0017\u0002\u000b'FdG)[1mK\u000e$\b\u0002\u00031\u0001\u0005\u0003\u0005\u000b\u0011B-\u0002\u0017M\fH\u000eR5bY\u0016\u001cG\u000f\t\u0005\u0006E\u0002!\taY\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0011<\u0007.\u001b6\u0015\u0005\u00154\u0007CA\t\u0001\u0011\u00159\u0016\rq\u0001Z\u0011\u0015A\u0012\r1\u0001\u001b\u0011\u0015I\u0013\r1\u0001+\u0011\u0015\t\u0014\r1\u00013\u0011\u0015I\u0014\r1\u0001;\u0011\u0015a\u0007\u0001\"\u0011n\u0003\u001d)\u00070Z2vi\u0016$\"A\u001c:\u0011\u0005=\u0004X\"\u0001#\n\u0005E$%\u0001B+oSRDQa]6A\u0002Q\fqaY8oi\u0016DH\u000f\u0005\u0002\u0012k&\u0011aO\u0001\u0002\u0011\u0007\"\fgnZ3TKR\u001cuN\u001c;fqRDQ\u0001\u001f\u0001\u0005Be\f\u0001B^1mS\u0012\fG/\u001a\u000b\u0003]jDQa]<A\u0002QDQ\u0001 \u0001\u0005\nu\fA!\\8wKR1aN`A\u0001\u0003\u000bAQa`>A\u00029\u000bQa\u001c7e\u0013\u0012Da!a\u0001|\u0001\u0004q\u0015!\u00028fo&#\u0007\"B:|\u0001\u0004!\bbBA\u0005\u0001\u0011%\u00111B\u0001\u0014cV,'/_!oIB\u0013XMV1mS\u0012\fG/\u001a\u000b\t\u0003\u001b\ti#a\f\u00022A1q.a\u0004O\u0003'I1!!\u0005E\u0005\u0019!V\u000f\u001d7feA9\u0011QCA\u000f\u001d\u0006\u0005RBAA\f\u0015\rY\u0015\u0011\u0004\u0006\u0003\u00037\tAA[1wC&!\u0011qDA\f\u0005\ri\u0015\r\u001d\t\u0005\u0003G\tI#\u0004\u0002\u0002&)!\u0011qEA\r\u0003\u0011a\u0017M\\4\n\t\u0005-\u0012Q\u0005\u0002\u0007\u001f\nTWm\u0019;\t\r}\f9\u00011\u0001O\u0011\u001d\t\u0019!a\u0002A\u00029Caa]A\u0004\u0001\u0004!\bbBA\u001b\u0001\u0011%\u0011qG\u0001\rm\u0006d\u0017\u000eZ1uK6{g/\u001a\u000b\b]\u0006e\u00121HA\u001f\u0011\u0019y\u00181\u0007a\u0001\u001d\"9\u00111AA\u001a\u0001\u0004q\u0005BB:\u00024\u0001\u0007A\u000f")
public class MoveCommand
extends UpdatePathCommand
implements CiPathValidation {
    private final JdbcTemplate jdbcTemplate;
    private final CommandValidator commandValidator;
    private final Iterable<Tuple<String, String>> moveCis;
    private final SqlDialect sqlDialect;

    @Override
    public void validateCiStoredInCorrectPath(String id, Type ciType, ChangeSetContext context) {
        CiPathValidation.validateCiStoredInCorrectPath$(this, id, ciType, context);
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public void execute(ChangeSetContext context) {
        this.moveCis.foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.move((String)t.a, (String)t.b, context);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void validate(ChangeSetContext context) {
        this.moveCis.foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.validateMove((String)t.a, (String)t.b, context);
            return BoxedUnit.UNIT;
        });
    }

    private void move(String oldId, String newId, ChangeSetContext context) {
        String string;
        Map map;
        block3: {
            Tuple2<String, Map<String, Object>> tuple2;
            block2: {
                tuple2 = this.queryAndPreValidate(oldId, newId, context);
                if (tuple2 == null) break block2;
                String oldPath = (String)tuple2._1();
                map = (Map)tuple2._2();
                if (oldPath == null) break block2;
                string = oldPath;
                if (map != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        Map map2 = map;
        Tuple2 tuple2 = new Tuple2((Object)string, (Object)map2);
        Tuple2 tuple22 = tuple2;
        String oldPath = (String)tuple22._1();
        Map map3 = (Map)tuple22._2();
        this.updateNameAndPath(oldPath, package$.MODULE$.idToPath(newId));
        EventBusHolder.publish((Object)new CiMovedEvent(package$.MODULE$.readBaseCiFromMap(map3), newId));
    }

    private Tuple2<String, Map<String, Object>> queryAndPreValidate(String oldId, String newId, ChangeSetContext context) {
        String string = oldId;
        String string2 = newId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot move ci [%s] to same location", (Object[])new Object[]{newId});
        String oldPath = package$.MODULE$.idToPath(oldId);
        Map map = (Map)this.jdbcTemplate().queryForObject(this.SELECT_CI_BY_PATH(), (RowMapper)new package.MapRowMapper(), new Object[]{oldPath});
        Type ciType = Type.valueOf((String)((String)map.get(CIS$.MODULE$.ci_type().name())));
        this.commandValidator.checkMoveAllowed(ciType);
        this.validateCiStoredInCorrectPath(newId, ciType, context);
        return new Tuple2((Object)oldPath, (Object)map);
    }

    private void validateMove(String oldId, String newId, ChangeSetContext context) {
        String string;
        Map map;
        block5: {
            Tuple2<String, Map<String, Object>> tuple2;
            block4: {
                tuple2 = this.queryAndPreValidate(oldId, newId, context);
                if (tuple2 == null) break block4;
                String oldPath = (String)tuple2._1();
                map = (Map)tuple2._2();
                if (oldPath == null) break block4;
                string = oldPath;
                if (map != null) break block5;
            }
            throw new MatchError(tuple2);
        }
        Map map2 = map;
        Tuple2 tuple2 = new Tuple2((Object)string, (Object)map2);
        Tuple2 tuple22 = tuple2;
        String oldPath = (String)tuple22._1();
        Map map3 = (Map)tuple22._2();
        if (this.exists(newId)) {
            throw new ItemAlreadyExistsException("The destination id [%s] exists.", new Object[]{newId});
        }
    }

    public MoveCommand(JdbcTemplate jdbcTemplate, ArtifactDataRepository artifactDataRepository, CommandValidator commandValidator, Iterable<Tuple<String, String>> moveCis, SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.commandValidator = commandValidator;
        this.moveCis = moveCis;
        this.sqlDialect = sqlDialect;
        super(jdbcTemplate, artifactDataRepository);
        CiPathValidation.$init$(this);
    }
}

