/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.sql.ConditionOnColumn;
import com.xebialabs.deployit.core.sql.SelectBuilder;
import com.xebialabs.deployit.core.sql.Selectable;
import com.xebialabs.deployit.core.sql.SqlCondition;
import com.xebialabs.deployit.core.sql.SqlCondition$;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.SqlFunction$;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.sql.StringMatchCondition;
import com.xebialabs.deployit.repository.sql.base.CIS$;
import com.xebialabs.deployit.repository.sql.base.CI_PROPERTIES$;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.security.sql.SqlPermissionConditions$;
import java.io.Serializable;
import java.util.Map;
import org.joda.time.DateTime;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

public final class CiConditions$ {
    public static CiConditions$ MODULE$;

    static {
        new CiConditions$();
    }

    public SelectBuilder idToPK(String id, SqlDialect sqlDialect) {
        return (SelectBuilder)new SelectBuilder(CIS$.MODULE$.tableName(), sqlDialect).select((Selectable)CIS$.MODULE$.ID()).where((SqlCondition)SqlCondition$.MODULE$.equals((Selectable)CIS$.MODULE$.path(), package$.MODULE$.idToPath(id)));
    }

    public SqlCondition ofType(Type ciType) {
        Type type = ciType;
        return SqlCondition$.MODULE$.in((Selectable)CIS$.MODULE$.ci_type(), (Iterable)ImplicitConversions$.MODULE$.collection$u0020AsScalaIterable(DescriptorRegistry.getSubtypes((Type)ciType)).toList().$colon$colon((Object)type).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString(), List$.MODULE$.canBuildFrom()));
    }

    public SqlCondition childOf(String parent, SqlDialect sqlDialect) {
        return parent.equals("/") ? SqlCondition$.MODULE$.equalsNull((Selectable)CIS$.MODULE$.parent_id()) : SqlCondition$.MODULE$.subselect((Selectable)CIS$.MODULE$.parent_id(), (SelectBuilder)new SelectBuilder(CIS$.MODULE$.tableName(), sqlDialect).select((Selectable)CIS$.MODULE$.ID()).where((SqlCondition)SqlCondition$.MODULE$.equals((Selectable)CIS$.MODULE$.path(), package$.MODULE$.idToPath(parent))));
    }

    public SqlCondition descendantOf(String ancestor) {
        return SqlCondition$.MODULE$.like((Selectable)CIS$.MODULE$.path(), package$.MODULE$.idToPath(ancestor) + "/%");
    }

    public SqlCondition nameMatch(String value, boolean exact) {
        return new StringMatchCondition(CIS$.MODULE$.name(), value, exact);
    }

    public SqlCondition idMatch(String value, boolean exact) {
        return new StringMatchCondition(CIS$.MODULE$.path(), value, exact);
    }

    public SqlCondition modifiedBefore(DateTime time) {
        return SqlCondition$.MODULE$.before((Selectable)CIS$.MODULE$.modified_at(), time);
    }

    public SqlCondition modifiedAfter(DateTime time) {
        return SqlCondition$.MODULE$.after((Selectable)CIS$.MODULE$.modified_at(), time);
    }

    public SqlCondition hasProperties(Map<String, String> properties, SqlDialect sqlDialect) {
        return SqlCondition$.MODULE$.subselect((Selectable)CIS$.MODULE$.ID(), (SelectBuilder)ImplicitConversions$.MODULE$.map$u0020AsScala(properties).foldLeft((Object)new SelectBuilder(CI_PROPERTIES$.MODULE$.tableName(), sqlDialect).select((Selectable)CI_PROPERTIES$.MODULE$.ci_id()), (Function2 & Serializable & scala.Serializable)(selectBuilder, entry) -> {
            MODULE$.validateEscapeSearchString((String)entry._2());
            return (SelectBuilder)selectBuilder.where((SqlCondition)SqlCondition$.MODULE$.and((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConditionOnColumn[]{SqlCondition$.MODULE$.equals((Selectable)CI_PROPERTIES$.MODULE$.name(), (String)entry._1()), (ConditionOnColumn)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> SqlCondition$.MODULE$.equals((Selectable)CI_PROPERTIES$.MODULE$.boolean_value(), new StringOps(Predef$.MODULE$.augmentString((String)entry._2())).toBoolean())).getOrElse((Function0 & Serializable & scala.Serializable)() -> SqlCondition$.MODULE$.like((Selectable)SqlFunction$.MODULE$.lower().apply((Object)CI_PROPERTIES$.MODULE$.string_value()), ((String)entry._2()).toLowerCase()))}))));
        }));
    }

    public SqlCondition permissionCondition(Seq<String> roles, Seq<String> permissions, SqlDialect sqlDialect) {
        return SqlCondition$.MODULE$.subselect((Selectable)CIS$.MODULE$.secured_ci(), SqlPermissionConditions$.MODULE$.permittedCis((Selectable)CIS$.MODULE$.secured_ci(), roles, permissions, sqlDialect));
    }

    public void validateEscapeSearchString(String str) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), str.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Checks.checkArgument((!CiConditions$.isBackslash$1(i, str) || CiConditions$.nextIsEscape$1(i, str) ? 1 : 0) != 0, (String)"Invalid search string '%s'. Escape character '\\' must be followed by another escape character, '_', or '%%'. It cannot be followed by any other character or be at the end of the pattern.", (Object[])new Object[]{str}));
    }

    private static final boolean isBackslash$1(int idx, String str$1) {
        return StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str$1), idx) == '\\';
    }

    private static final boolean nextIsEscape$1(int idx, String str$1) {
        return idx < str$1.length() - 1 && (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str$1), idx + 1) == '_' || StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str$1), idx + 1) == '%');
    }

    private CiConditions$() {
        MODULE$ = this;
    }
}

