/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.commands;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.spring.package;
import com.xebialabs.deployit.engine.spi.event.CiCopiedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.deployit.repository.sql.CiHistoryRepository;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactDataRepository;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactRepository;
import com.xebialabs.deployit.repository.sql.base.CIS$;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.repository.sql.commands.ChangeSetContext;
import com.xebialabs.deployit.repository.sql.commands.InsertCommand;
import com.xebialabs.deployit.repository.sql.placeholders.SqlPlaceholderRepository;
import com.xebialabs.deployit.repository.sql.reader.CiReader;
import com.xebialabs.deployit.repository.sql.specific.TypeSpecificInserter;
import com.xebialabs.deployit.repository.validation.CommandValidator;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.deployit.util.Tuple;
import com.xebialabs.license.LicenseCiCounter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t\u0005a\u0001B\u0001\u0003\u0001=\u00111bQ8qs\u000e{W.\\1oI*\u00111\u0001B\u0001\tG>lW.\u00198eg*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003\u0013)\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003\u00171\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u00035\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!!D%og\u0016\u0014HoQ8n[\u0006tG\r\u0003\u0005\u0016\u0001\t\u0015\r\u0011\"\u0011\u0017\u00031QGMY2UK6\u0004H.\u0019;f+\u00059\u0002C\u0001\r\"\u001b\u0005I\"B\u0001\u000e\u001c\u0003\u0011\u0019wN]3\u000b\u0005qi\u0012\u0001\u00026eE\u000eT!AH\u0010\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001I\u0001\u0004_J<\u0017B\u0001\u0012\u001a\u00051QEMY2UK6\u0004H.\u0019;f\u0011%!\u0003A!A!\u0002\u00139R%A\u0007kI\n\u001cG+Z7qY\u0006$X\rI\u0005\u0003+IA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0013CJ$\u0018NZ1diJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002*Y5\t!F\u0003\u0002,\t\u0005I\u0011M\u001d;jM\u0006\u001cGo]\u0005\u0003[)\u0012!#\u0011:uS\u001a\f7\r\u001e*fa>\u001c\u0018\u000e^8ss\"Aq\u0006\u0001B\u0001B\u0003%\u0001'\u0001\fbeRLg-Y2u\t\u0006$\u0018MU3q_NLGo\u001c:z!\tI\u0013'\u0003\u00023U\t1\u0012I\u001d;jM\u0006\u001cG\u000fR1uCJ+\u0007o\\:ji>\u0014\u0018\u0010\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0003M\u0019\u0017\u000eS5ti>\u0014\u0018PU3q_NLGo\u001c:z!\t1t'D\u0001\u0005\u0013\tADAA\nDS\"K7\u000f^8ssJ+\u0007o\\:ji>\u0014\u0018\u0010\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0003U\u0001H.Y2fQ>dG-\u001a:SKB|7/\u001b;pef\u0004\"\u0001P \u000e\u0003uR!A\u0010\u0003\u0002\u0019Ad\u0017mY3i_2$WM]:\n\u0005\u0001k$\u0001G*rYBc\u0017mY3i_2$WM\u001d*fa>\u001c\u0018\u000e^8ss\"A!\t\u0001B\u0001B\u0003%1)A\tqCN\u001cxo\u001c:e\u000b:\u001c'/\u001f9uKJ\u0004\"\u0001R$\u000e\u0003\u0015S!A\u0012\u0005\u0002\tU$\u0018\u000e\\\u0005\u0003\u0011\u0016\u0013\u0011\u0003U1tg^|'\u000fZ#oGJL\b\u000f^3s\u0011!Q\u0005A!A!\u0002\u0013Y\u0015\u0001\u00057jG\u0016t7/Z\"j\u0007>,h\u000e^3s!\tau*D\u0001N\u0015\tq%\"A\u0004mS\u000e,gn]3\n\u0005Ak%\u0001\u0005'jG\u0016t7/Z\"j\u0007>,h\u000e^3s\u0011!\u0011\u0006A!A!\u0002\u0013\u0019\u0016\u0001C2j%\u0016\fG-\u001a:\u0011\u0005Q;V\"A+\u000b\u0005Y#\u0011A\u0002:fC\u0012,'/\u0003\u0002Y+\nA1)\u001b*fC\u0012,'\u000f\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003\\\u0003m\u0019'/Z1uKRK\b/Z*qK\u000eLg-[2J]N,'\u000f^3sgB1AlX1l\u0003\u000fi\u0011!\u0018\u0006\u0002=\u0006)1oY1mC&\u0011\u0001-\u0018\u0002\n\rVt7\r^5p]J\u0002\"AY5\u000e\u0003\rT!\u0001Z3\u0002\u000fI,g\r\\3di*\u0011amZ\u0001\u0004CBL'B\u00015\t\u0003\u0019\u0001H.^4j]&\u0011!n\u0019\u0002\u0005)f\u0004X\rE\u0002m\u0003\u0003q!!\\?\u000f\u00059\\hBA8{\u001d\t\u0001\u0018P\u0004\u0002rq:\u0011!o\u001e\b\u0003gZl\u0011\u0001\u001e\u0006\u0003k:\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u0011A\u0010B\u0001\u0005E\u0006\u001cX-\u0003\u0002\u007f\u007f\u00069\u0001/Y2lC\u001e,'B\u0001?\u0005\u0013\u0011\t\u0019!!\u0002\u0003\u0011\rK\u0007k\u0013+za\u0016T!A`@\u0011\r\u0005%\u0011\u0011CA\f\u001d\u0011\tY!a\u0004\u000f\u0007M\fi!C\u0001_\u0013\tqX,\u0003\u0003\u0002\u0014\u0005U!\u0001\u0002'jgRT!A`/\u0011\t\u0005e\u0011qD\u0007\u0003\u00037Q1!!\b\u0005\u0003!\u0019\b/Z2jM&\u001c\u0017\u0002BA\u0011\u00037\u0011A\u0003V=qKN\u0003XmY5gS\u000eLen]3si\u0016\u0014\bBCA\u0013\u0001\t\u0005\t\u0015!\u0003\u0002(\u0005\u00012m\\7nC:$g+\u00197jI\u0006$xN\u001d\t\u0005\u0003S\ty#\u0004\u0002\u0002,)\u0019\u0011Q\u0006\u0004\u0002\u0015Y\fG.\u001b3bi&|g.\u0003\u0003\u00022\u0005-\"\u0001E\"p[6\fg\u000e\u001a,bY&$\u0017\r^8s\u0011)\t)\u0004\u0001BC\u0002\u0013\u0005\u0011qG\u0001\bG>\u0004\u0018pQ5t+\t\tI\u0004\u0005\u0004\u0002\n\u0005m\u0012qH\u0005\u0005\u0003{\t)B\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\u001d!\u0015\u0011IA#\u0003\u000bJ1!a\u0011F\u0005\u0015!V\u000f\u001d7f!\u0011\t9%a\u0014\u000f\t\u0005%\u00131\n\t\u0003gvK1!!\u0014^\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011KA*\u0005\u0019\u0019FO]5oO*\u0019\u0011QJ/\t\u0015\u0005]\u0003A!A!\u0002\u0013\tI$\u0001\u0005d_BL8)[:!\u0011)\tY\u0006\u0001BC\u0002\u0013\r\u0011QL\u0001\u000bgFdG)[1mK\u000e$XCAA0!\u0011\t\t'a\u001a\u000e\u0005\u0005\r$bA\u0003\u0002f)\u0011!\u0004C\u0005\u0005\u0003S\n\u0019G\u0001\u0006Tc2$\u0015.\u00197fGRD!\"!\u001c\u0001\u0005\u0003\u0005\u000b\u0011BA0\u0003-\u0019\u0018\u000f\u001c#jC2,7\r\u001e\u0011\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t\u00051A(\u001b8jiz\"\u0002$!\u001e\u0002|\u0005u\u0014qPAA\u0003\u0007\u000b))a\"\u0002\n\u0006-\u0015QRAH)\u0011\t9(!\u001f\u0011\u0005E\u0001\u0001\u0002CA.\u0003_\u0002\u001d!a\u0018\t\rU\ty\u00071\u0001\u0018\u0011\u00199\u0013q\u000ea\u0001Q!1q&a\u001cA\u0002ABa\u0001NA8\u0001\u0004)\u0004B\u0002\u001e\u0002p\u0001\u00071\b\u0003\u0004C\u0003_\u0002\ra\u0011\u0005\u0007\u0015\u0006=\u0004\u0019A&\t\rI\u000by\u00071\u0001T\u0011\u0019Q\u0016q\u000ea\u00017\"A\u0011QEA8\u0001\u0004\t9\u0003\u0003\u0005\u00026\u0005=\u0004\u0019AA\u001d\u0011\u001d\t\u0019\n\u0001C!\u0003+\u000bq!\u001a=fGV$X\r\u0006\u0003\u0002\u0018\u0006u\u0005c\u0001/\u0002\u001a&\u0019\u00111T/\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003?\u000b\t\n1\u0001\u0002\"\u000691m\u001c8uKb$\bcA\t\u0002$&\u0019\u0011Q\u0015\u0002\u0003!\rC\u0017M\\4f'\u0016$8i\u001c8uKb$\bbBAU\u0001\u0011\u0005\u00131V\u0001\tm\u0006d\u0017\u000eZ1uKR!\u0011qSAW\u0011!\ty*a*A\u0002\u0005\u0005\u0006bBAY\u0001\u0011%\u00111W\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u0002\u0018\u0006U\u0016\u0011XA_\u0011!\t9,a,A\u0002\u0005\u0015\u0013A\u00024s_6LE\r\u0003\u0005\u0002<\u0006=\u0006\u0019AA#\u0003\u0011!x.\u00133\t\u0011\u0005}\u0015q\u0016a\u0001\u0003CCq!!1\u0001\t\u0013\t\u0019-A\tsKBd\u0017mY3SK\u001a,'/\u001a8dKN$B!a&\u0002F\"A\u0011qYA`\u0001\u0004\tI-\u0001\u0006sK\u001a,'/\u001a8dKN\u0004\u0002\"a\u0012\u0002L\u0006\u0015\u0013qZ\u0005\u0005\u0003\u001b\f\u0019FA\u0002NCB\u0004B!!5\u0002X6\u0011\u00111\u001b\u0006\u0004\u0003+,\u0017aA;e[&!\u0011\u0011\\Aj\u0005E\u0019uN\u001c4jOV\u0014\u0018\r^5p]&#X-\u001c\u0005\b\u0003;\u0004A\u0011BAp\u000311\u0018\r\\5eCR,7i\u001c9z)!\t9*!9\u0002d\u0006\u0015\b\u0002CA\\\u00037\u0004\r!!\u0012\t\u0011\u0005m\u00161\u001ca\u0001\u0003\u000bB\u0001\"a(\u0002\\\u0002\u0007\u0011\u0011\u0015\u0005\b\u0003S\u0004A\u0011BAv\u0003!\u0011XM\\1nK\u000eKG\u0003CAL\u0003[\f\t0a=\t\u0011\u0005=\u0018q\u001da\u0001\u0003\u001f\f!aY5\t\u0011\u0005]\u0016q\u001da\u0001\u0003\u000bB\u0001\"a/\u0002h\u0002\u0007\u0011Q\t\u0005\b\u0003o\u0004A\u0011BA}\u0003)1\u0018\r\\5eCR,7)\u001b\u000b\t\u0003/\u000bY0!@\u0002\u0000\"A\u0011qWA{\u0001\u0004\t)\u0005\u0003\u0005\u0002<\u0006U\b\u0019AA#\u0011!\ty/!>A\u0002\u0005=\u0007")
public class CopyCommand
extends InsertCommand {
    private final ArtifactRepository artifactRepository;
    private final ArtifactDataRepository artifactDataRepository;
    private final CiReader ciReader;
    private final CommandValidator commandValidator;
    private final Iterable<Tuple<String, String>> copyCis;
    private final SqlDialect sqlDialect;

    @Override
    public JdbcTemplate jdbcTemplate() {
        return super.jdbcTemplate();
    }

    public Iterable<Tuple<String, String>> copyCis() {
        return this.copyCis;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public void execute(ChangeSetContext context) {
        this.copyCis().foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.copy((String)t.a, (String)t.b, context);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void validate(ChangeSetContext context) {
        this.copyCis().foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.validateCopy((String)t.a, (String)t.b, context);
            return BoxedUnit.UNIT;
        });
    }

    private void copy(String fromId, String toId, ChangeSetContext context) {
        String string = fromId;
        String string2 = toId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot copy ci [%s] to same location", (Object[])new Object[]{toId});
        String path = package$.MODULE$.idToPath(fromId);
        ConfigurationItem ci = this.ciReader.readByPath(path, 0);
        this.validateCi(fromId, toId, ci);
        Buffer tuples = (Buffer)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.jdbcTemplate().query(this.SELECT_CI_TREE_BY_PATH(), (RowMapper)new package.MapRowMapper(), new Object[]{path, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/%"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}))})).map((Function1 & Serializable & scala.Serializable)map -> {
            ConfigurationItem ci = $this.ciReader.readUsingCache((Integer)package$.MODULE$.asCiPKType().apply(map.get(CIS$.MODULE$.ID().name())), 1, (Function0<Map<String, Object>>)(Function0 & Serializable & scala.Serializable)() -> map);
            String copiedId = ci.getId();
            this.renameCi(ci, fromId, toId);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)copiedId), (Object)ci);
        }, Buffer$.MODULE$.canBuildFrom());
        this.replaceReferences((scala.collection.immutable.Map<String, ConfigurationItem>)tuples.toMap(Predef$.MODULE$.$conforms()));
        this.insertCis((Iterable<ConfigurationItem>)((Iterable)tuples.map((Function1 & Serializable & scala.Serializable)x$1 -> (ConfigurationItem)x$1._2(), Buffer$.MODULE$.canBuildFrom())), context, (Function2<Integer, ConfigurationItem, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(ciPk, copiedCi) -> {
            CopyCommand.$anonfun$copy$4(this, fromId, toId, ciPk, copiedCi);
            return BoxedUnit.UNIT;
        });
        EventBusHolder.publish((Object)new CiCopiedEvent(ci, toId));
    }

    private void replaceReferences(scala.collection.immutable.Map<String, ConfigurationItem> references) {
        references.values().foreach((Function1 & Serializable & scala.Serializable)newCi -> {
            CopyCommand.$anonfun$replaceReferences$1(references, newCi);
            return BoxedUnit.UNIT;
        });
    }

    private void validateCopy(String fromId, String toId, ChangeSetContext context) {
        String string = fromId;
        String string2 = toId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot copy ci [%s] to same location", (Object[])new Object[]{toId});
        String path = package$.MODULE$.idToPath(fromId);
        ConfigurationItem ci = this.ciReader.readByPath(path, 0);
        this.validateCi(fromId, toId, ci);
        this.insertCisValidation((Iterable<ConfigurationItem>)((Iterable)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.jdbcTemplate().query(this.SELECT_CI_TREE_BY_PATH(), (RowMapper)new package.MapRowMapper(), new Object[]{path, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/%"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}))})).map((Function1 & Serializable & scala.Serializable)map -> {
            ConfigurationItem ci = $this.ciReader.readUsingCache((Integer)package$.MODULE$.asCiPKType().apply(map.get(CIS$.MODULE$.ID().name())), 1, (Function0<Map<String, Object>>)(Function0 & Serializable & scala.Serializable)() -> map);
            this.renameCi(ci, fromId, toId);
            return ci;
        }, Buffer$.MODULE$.canBuildFrom())), context);
    }

    private void renameCi(ConfigurationItem ci, String fromId, String toId) {
        String newId = toId + ci.getId().substring(fromId.length());
        ci.setId(newId);
    }

    private void validateCi(String fromId, String toId, ConfigurationItem ci) {
        Type type = ci.getType();
        Type type2 = Type.valueOf(Root.class);
        Checks.checkArgument(((type == null ? type2 != null : !type.equals(type2)) ? 1 : 0) != 0, (String)"Cannot copy root node [%s].", (Object[])new Object[]{toId});
        this.commandValidator.checkCopyAllowed(this.ciReader.readByPath((String)package$.MODULE$.parentPath(fromId).get(), 0).getType(), this.ciReader.readByPath((String)package$.MODULE$.parentPath(toId).get(), 0).getType());
        if (this.exists(toId)) {
            throw new ItemAlreadyExistsException("The destination id [%s] exists.", new Object[]{toId});
        }
    }

    public static final /* synthetic */ void $anonfun$copy$4(CopyCommand $this, String fromId$1, String toId$1, Integer ciPk, ConfigurationItem copiedCi) {
        ConfigurationItem configurationItem = copiedCi;
        if (configurationItem instanceof SourceArtifact) {
            SourceArtifact sourceArtifact = (SourceArtifact)configurationItem;
            String fromCiId = fromId$1 + sourceArtifact.getId().substring(toId$1.length());
            $this.artifactDataRepository.copy(fromCiId, ciPk);
            $this.artifactRepository.updateFilename(ciPk, $this.artifactRepository.getFilename(fromCiId));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final void replaceCiReference$1(scala.collection.immutable.Map references$1, ConfigurationItem newCi$1, PropertyDescriptor pd$1) {
        Object object = pd$1.get(newCi$1);
        if (object instanceof ConfigurationItem) {
            ConfigurationItem configurationItem = (ConfigurationItem)object;
            pd$1.set(newCi$1, references$1.getOrElse((Object)configurationItem.getId(), (Function0 & Serializable & scala.Serializable)() -> configurationItem));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final void replaceListReferences$1(scala.collection.immutable.Map references$1, ConfigurationItem newCi$1, PropertyDescriptor pd$1) {
        ListIterator itr = ((java.util.List)pd$1.get(newCi$1)).listIterator();
        while (itr.hasNext()) {
            String oldId = ((ConfigurationItem)itr.next()).getId();
            references$1.get((Object)oldId).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                itr.set(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$replaceReferences$5(HashSet toAdd$1, Iterator itr$2, ConfigurationItem ci) {
        toAdd$1.add(ci);
        itr$2.remove();
    }

    private static final void replaceSetReferences$1(scala.collection.immutable.Map references$1, ConfigurationItem newCi$1, PropertyDescriptor pd$1) {
        HashSet toAdd = new HashSet();
        Set set = (Set)pd$1.get(newCi$1);
        Iterator itr = set.iterator();
        while (itr.hasNext()) {
            String oldId = ((ConfigurationItem)itr.next()).getId();
            references$1.get((Object)oldId).foreach((Function1 & Serializable & scala.Serializable)ci -> {
                CopyCommand.$anonfun$replaceReferences$5(toAdd, itr, ci);
                return BoxedUnit.UNIT;
            });
        }
        set.addAll(toAdd);
    }

    public static final /* synthetic */ void $anonfun$replaceReferences$2(scala.collection.immutable.Map references$1, ConfigurationItem newCi$1, PropertyDescriptor pd) {
        PropertyKind propertyKind = pd.getKind();
        if (PropertyKind.CI.equals(propertyKind)) {
            CopyCommand.replaceCiReference$1(references$1, newCi$1, pd);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (PropertyKind.LIST_OF_CI.equals(propertyKind)) {
            CopyCommand.replaceListReferences$1(references$1, newCi$1, pd);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (PropertyKind.SET_OF_CI.equals(propertyKind)) {
            CopyCommand.replaceSetReferences$1(references$1, newCi$1, pd);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$replaceReferences$1(scala.collection.immutable.Map references$1, ConfigurationItem newCi) {
        ImplicitConversions$.MODULE$.collection$u0020AsScalaIterable(newCi.getType().getDescriptor().getPropertyDescriptors()).foreach((Function1 & Serializable & scala.Serializable)pd -> {
            CopyCommand.$anonfun$replaceReferences$2(references$1, newCi, pd);
            return BoxedUnit.UNIT;
        });
    }

    public CopyCommand(JdbcTemplate jdbcTemplate, ArtifactRepository artifactRepository, ArtifactDataRepository artifactDataRepository, CiHistoryRepository ciHistoryRepository, SqlPlaceholderRepository placeholderRepository, PasswordEncrypter passwordEncrypter, LicenseCiCounter licenseCiCounter, CiReader ciReader, Function2<Type, Integer, List<TypeSpecificInserter>> createTypeSpecificInserters, CommandValidator commandValidator, Iterable<Tuple<String, String>> copyCis, SqlDialect sqlDialect) {
        this.artifactRepository = artifactRepository;
        this.artifactDataRepository = artifactDataRepository;
        this.ciReader = ciReader;
        this.commandValidator = commandValidator;
        this.copyCis = copyCis;
        this.sqlDialect = sqlDialect;
        super(jdbcTemplate, artifactRepository, artifactDataRepository, ciHistoryRepository, placeholderRepository, passwordEncrypter, licenseCiCounter, createTypeSpecificInserters);
    }
}

