/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.commands;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.spring.package;
import com.xebialabs.deployit.engine.spi.event.CiMovedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactDataRepository;
import com.xebialabs.deployit.repository.sql.base.CIS$;
import com.xebialabs.deployit.repository.sql.base.SecuredCi;
import com.xebialabs.deployit.repository.sql.base.SecuredCiQueries;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.repository.sql.commands.ChangeSetContext;
import com.xebialabs.deployit.repository.sql.commands.CiPathValidation;
import com.xebialabs.deployit.repository.sql.commands.UpdatePathCommand;
import com.xebialabs.deployit.repository.sql.placeholders.SqlPlaceholderRepository;
import com.xebialabs.deployit.repository.validation.CommandValidator;
import com.xebialabs.deployit.util.Tuple;
import java.io.Serializable;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001B\u0001\u0003\u0001=\u00111\"T8wK\u000e{W.\\1oI*\u00111\u0001B\u0001\tG>lW.\u00198eg*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003\u0013)\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003\u00171\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u00035\t1aY8n\u0007\u0001\u0019B\u0001\u0001\t\u0015/A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0012+B$\u0017\r^3QCRD7i\\7nC:$\u0007CA\t\u0016\u0013\t1\"A\u0001\tDSB\u000bG\u000f\u001b,bY&$\u0017\r^5p]B\u0011\u0001dG\u0007\u00023)\u0011!\u0004B\u0001\u0005E\u0006\u001cX-\u0003\u0002\u001d3\tI1+Z2ve\u0016$7)\u001b\u0005\t=\u0001\u0011)\u0019!C!?\u0005a!\u000e\u001a2d)\u0016l\u0007\u000f\\1uKV\t\u0001\u0005\u0005\u0002\"U5\t!E\u0003\u0002$I\u0005!1m\u001c:f\u0015\t)c%\u0001\u0003kI\n\u001c'BA\u0014)\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A\u0015\u0002\u0007=\u0014x-\u0003\u0002,E\ta!\n\u001a2d)\u0016l\u0007\u000f\\1uK\"AQ\u0006\u0001B\u0001B\u0003%\u0001%A\u0007kI\n\u001cG+Z7qY\u0006$X\r\t\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u00051\u0012M\u001d;jM\u0006\u001cG\u000fR1uCJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00022i5\t!G\u0003\u00024\t\u0005I\u0011M\u001d;jM\u0006\u001cGo]\u0005\u0003kI\u0012a#\u0011:uS\u001a\f7\r\u001e#bi\u0006\u0014V\r]8tSR|'/\u001f\u0005\to\u0001\u0011\t\u0011)A\u0005q\u0005)\u0002\u000f\\1dK\"|G\u000eZ3s%\u0016\u0004xn]5u_JL\bCA\u001d=\u001b\u0005Q$BA\u001e\u0005\u00031\u0001H.Y2fQ>dG-\u001a:t\u0013\ti$H\u0001\rTc2\u0004F.Y2fQ>dG-\u001a:SKB|7/\u001b;pefD\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001Q\u0001\u0011G>lW.\u00198e-\u0006d\u0017\u000eZ1u_J\u0004\"!\u0011#\u000e\u0003\tS!a\u0011\u0004\u0002\u0015Y\fG.\u001b3bi&|g.\u0003\u0002F\u0005\n\u00012i\\7nC:$g+\u00197jI\u0006$xN\u001d\u0005\t\u000f\u0002\u0011)\u0019!C\u0001\u0011\u00069Qn\u001c<f\u0007&\u001cX#A%\u0011\u0007)#vK\u0004\u0002L#:\u0011AjT\u0007\u0002\u001b*\u0011aJD\u0001\u0007yI|w\u000e\u001e \n\u0003A\u000bQa]2bY\u0006L!AU*\u0002\u000fA\f7m[1hK*\t\u0001+\u0003\u0002V-\nA\u0011\n^3sC\ndWM\u0003\u0002S'B!\u0001lW/^\u001b\u0005I&B\u0001.\t\u0003\u0011)H/\u001b7\n\u0005qK&!\u0002+va2,\u0007C\u00010c\u001d\ty\u0006\r\u0005\u0002M'&\u0011\u0011mU\u0001\u0007!J,G-\u001a4\n\u0005\r$'AB*ue&twM\u0003\u0002b'\"Aa\r\u0001B\u0001B\u0003%\u0011*\u0001\u0005n_Z,7)[:!\u0011!A\u0007A!b\u0001\n\u0007I\u0017AC:rY\u0012K\u0017\r\\3diV\t!\u000e\u0005\u0002l]6\tAN\u0003\u0002\u0006[*\u00111\u0005C\u0005\u0003_2\u0014!bU9m\t&\fG.Z2u\u0011!\t\bA!A!\u0002\u0013Q\u0017aC:rY\u0012K\u0017\r\\3di\u0002BQa\u001d\u0001\u0005\u0002Q\fa\u0001P5oSRtDCB;ysj\\H\u0010\u0006\u0002woB\u0011\u0011\u0003\u0001\u0005\u0006QJ\u0004\u001dA\u001b\u0005\u0006=I\u0004\r\u0001\t\u0005\u0006_I\u0004\r\u0001\r\u0005\u0006oI\u0004\r\u0001\u000f\u0005\u0006\u007fI\u0004\r\u0001\u0011\u0005\u0006\u000fJ\u0004\r!\u0013\u0005\u0006}\u0002!\te`\u0001\bKb,7-\u001e;f)\u0011\t\t!!\u0003\u0011\t\u0005\r\u0011QA\u0007\u0002'&\u0019\u0011qA*\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0017i\b\u0019AA\u0007\u0003\u001d\u0019wN\u001c;fqR\u00042!EA\b\u0013\r\t\tB\u0001\u0002\u0011\u0007\"\fgnZ3TKR\u001cuN\u001c;fqRDq!!\u0006\u0001\t\u0003\n9\"\u0001\u0005wC2LG-\u0019;f)\u0011\t\t!!\u0007\t\u0011\u0005-\u00111\u0003a\u0001\u0003\u001bAq!!\b\u0001\t\u0013\ty\"\u0001\u0003n_Z,G\u0003CA\u0001\u0003C\t)#!\u000b\t\u000f\u0005\r\u00121\u0004a\u0001;\u0006)q\u000e\u001c3JI\"9\u0011qEA\u000e\u0001\u0004i\u0016!\u00028fo&#\u0007\u0002CA\u0006\u00037\u0001\r!!\u0004\t\u000f\u00055\u0002\u0001\"\u0003\u00020\u0005\u0019\u0012/^3ss\u0006sG\r\u0015:f-\u0006d\u0017\u000eZ1uKRA\u0011\u0011GA)\u0003'\n)\u0006E\u0004\u0002\u0004\u0005MR,a\u000e\n\u0007\u0005U2K\u0001\u0004UkBdWM\r\t\b\u0003s\t\t%XA#\u001b\t\tYDC\u0002[\u0003{Q!!a\u0010\u0002\t)\fg/Y\u0005\u0005\u0003\u0007\nYDA\u0002NCB\u0004B!a\u0012\u0002N5\u0011\u0011\u0011\n\u0006\u0005\u0003\u0017\ni$\u0001\u0003mC:<\u0017\u0002BA(\u0003\u0013\u0012aa\u00142kK\u000e$\bbBA\u0012\u0003W\u0001\r!\u0018\u0005\b\u0003O\tY\u00031\u0001^\u0011!\tY!a\u000bA\u0002\u00055\u0001bBA-\u0001\u0011%\u00111L\u0001\u000fkB$\u0017\r^3TK\u000e,(/\u001b;z)!\t\t!!\u0018\u0002\u0006\u0006%\u0005\u0002CA0\u0003/\u0002\r!!\u0019\u0002\u0005A\\\u0007\u0003BA2\u0003\u007frA!!\u001a\u0002~9!\u0011qMA>\u001d\u0011\tI'!\u001f\u000f\t\u0005-\u0014q\u000f\b\u0005\u0003[\n)H\u0004\u0003\u0002p\u0005Mdb\u0001'\u0002r%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005i!\u0011B\u0001*\u001a\u0013\u0011\t\t)a!\u0003\u0011\rK\u0007k\u0013+za\u0016T!AU\r\t\u0011\u0005\u001d\u0015q\u000ba\u0001\u0003C\n\u0001\u0002]1sK:$\bk\u001b\u0005\b\u0003\u0017\u000b9\u00061\u0001^\u0003\u001dqWm\u001e)bi\"Dq!a$\u0001\t\u0013\t\t*\u0001\u0007wC2LG-\u0019;f\u001b>4X\r\u0006\u0005\u0002\u0002\u0005M\u0015QSAL\u0011\u001d\t\u0019#!$A\u0002uCq!a\n\u0002\u000e\u0002\u0007Q\f\u0003\u0005\u0002\f\u00055\u0005\u0019AA\u0007\u0001")
public class MoveCommand
extends UpdatePathCommand
implements CiPathValidation,
SecuredCi {
    private final JdbcTemplate jdbcTemplate;
    private final CommandValidator commandValidator;
    private final Iterable<Tuple<String, String>> moveCis;
    private final SqlDialect sqlDialect;
    private String SELECT_SECURED_CI;
    private String UPDATE_SECURED_CI;
    private volatile byte bitmap$0;

    @Override
    public Option<Integer> getSecuredCi(Integer pk) {
        return SecuredCi.getSecuredCi$(this, pk);
    }

    @Override
    public void setSecuredCi(Integer pk, Integer securedCi) {
        SecuredCi.setSecuredCi$(this, pk, securedCi);
    }

    @Override
    public void validateCiStoredInCorrectPath(String id, Type ciType, ChangeSetContext context) {
        CiPathValidation.validateCiStoredInCorrectPath$(this, id, ciType, context);
    }

    private String SELECT_SECURED_CI$lzycompute() {
        MoveCommand moveCommand = this;
        synchronized (moveCommand) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.SELECT_SECURED_CI = SecuredCiQueries.SELECT_SECURED_CI$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.SELECT_SECURED_CI;
    }

    @Override
    public String SELECT_SECURED_CI() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.SELECT_SECURED_CI$lzycompute() : this.SELECT_SECURED_CI;
    }

    private String UPDATE_SECURED_CI$lzycompute() {
        MoveCommand moveCommand = this;
        synchronized (moveCommand) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.UPDATE_SECURED_CI = SecuredCiQueries.UPDATE_SECURED_CI$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.UPDATE_SECURED_CI;
    }

    @Override
    public String UPDATE_SECURED_CI() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.UPDATE_SECURED_CI$lzycompute() : this.UPDATE_SECURED_CI;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public Iterable<Tuple<String, String>> moveCis() {
        return this.moveCis;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public void execute(ChangeSetContext context) {
        this.moveCis().foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.move((String)t.a, (String)t.b, context);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void validate(ChangeSetContext context) {
        this.moveCis().foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.validateMove((String)t.a, (String)t.b, context);
            return BoxedUnit.UNIT;
        });
    }

    private void move(String oldId, String newId, ChangeSetContext context) {
        String string;
        Map map;
        block3: {
            Tuple2<String, Map<String, Object>> tuple2;
            block2: {
                tuple2 = this.queryAndPreValidate(oldId, newId, context);
                if (tuple2 == null) break block2;
                String oldPath = (String)tuple2._1();
                map = (Map)tuple2._2();
                if (oldPath == null) break block2;
                string = oldPath;
                if (map != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        Map map2 = map;
        Tuple2 tuple2 = new Tuple2((Object)string, (Object)map2);
        Tuple2 tuple22 = tuple2;
        String oldPath = (String)tuple22._1();
        Map map3 = (Map)tuple22._2();
        String newPath = package$.MODULE$.idToPath(newId);
        Integer parentPk = this.updateNameAndPath(oldPath, newPath);
        this.updateSecurity((Integer)package$.MODULE$.asCiPKType().apply(map3.get(CIS$.MODULE$.ID().name())), parentPk, newPath);
        EventBusHolder.publish((Object)new CiMovedEvent(package$.MODULE$.readBaseCiFromMap(map3), newId));
    }

    private Tuple2<String, Map<String, Object>> queryAndPreValidate(String oldId, String newId, ChangeSetContext context) {
        String string = oldId;
        String string2 = newId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot move ci [%s] to same location", (Object[])new Object[]{newId});
        String oldPath = package$.MODULE$.idToPath(oldId);
        Map map = (Map)this.jdbcTemplate().queryForObject(this.SELECT_CI_BY_PATH(), (RowMapper)new package.MapRowMapper(), new Object[]{oldPath});
        Type ciType = Type.valueOf((String)((String)map.get(CIS$.MODULE$.ci_type().name())));
        this.commandValidator.checkMoveAllowed(ciType);
        this.validateCiStoredInCorrectPath(newId, ciType, context);
        return new Tuple2((Object)oldPath, (Object)map);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateSecurity(Integer pk, Integer parentPk, String newPath) {
        boolean bl = false;
        Some some = null;
        Option<Integer> option = this.getSecuredCi(pk);
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Integer n = (Integer)some.value();
            Integer n2 = pk;
            Integer n3 = n;
            if (!(n2 != null ? !((Object)n2).equals(n3) : n3 != null)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (!bl) {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        Integer securedPk = (Integer)some.value();
        Option<Integer> option2 = this.getSecuredCi(parentPk);
        if (option2 instanceof Some) {
            Some some2 = (Some)option2;
            Integer newSecuredPk = (Integer)some2.value();
            this.jdbcTemplate().update(this.UPDATE_SECURED_ID(), new Object[]{newSecuredPk, newPath, newPath + "/%", securedPk});
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
            this.jdbcTemplate().update(this.UPDATE_SECURED_ID(), new Object[]{null, newPath, newPath + "/%", securedPk});
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void validateMove(String oldId, String newId, ChangeSetContext context) {
        this.queryAndPreValidate(oldId, newId, context);
        if (this.exists(newId)) {
            throw new ItemAlreadyExistsException("The destination id [%s] exists.", new Object[]{newId});
        }
    }

    public MoveCommand(JdbcTemplate jdbcTemplate, ArtifactDataRepository artifactDataRepository, SqlPlaceholderRepository placeholderRepository, CommandValidator commandValidator, Iterable<Tuple<String, String>> moveCis, SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.commandValidator = commandValidator;
        this.moveCis = moveCis;
        this.sqlDialect = sqlDialect;
        super(jdbcTemplate, artifactDataRepository, placeholderRepository);
        CiPathValidation.$init$(this);
        SecuredCiQueries.$init$(this);
        SecuredCi.$init$(this);
    }
}

