/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.artifacts;

import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactDataRepository;
import com.xebialabs.deployit.repository.sql.artifacts.DbArtifactQueries;
import com.xebialabs.deployit.repository.sql.artifacts.DbArtifactUsageQueries;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.util.JavaCryptoUtils;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.UUID;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.stereotype.Component;
import scala.StringContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001\u0002\t\u0012\u0001yA\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001\r\u0005\t{\u0001\u0011\t\u0011)A\u0005c!Aa\b\u0001BC\u0002\u0013\rq\b\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003A\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u0015\u0011\b\u0001\"\u0011t\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gAq!!\u0011\u0001\t\u0003\t\u0019\u0005C\u0004\u00022\u0001!\t%!\u0014\t\u000f\u0005U\u0003\u0001\"\u0011\u0002X!9\u0011\u0011\r\u0001\u0005B\u0005\r\u0004bBA4\u0001\u0011\u0005\u0013\u0011\u000e\u0005\b\u0003[\u0002A\u0011AA8\u0011\u001d\t)\b\u0001C!\u0003o\u0012\u0001\u0004\u00122BeRLg-Y2u\t\u0006$\u0018MU3q_NLGo\u001c:z\u0015\t\u00112#A\u0005beRLg-Y2ug*\u0011A#F\u0001\u0004gFd'B\u0001\f\u0018\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u00031e\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u00035m\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003q\t1aY8n\u0007\u0001\u0019R\u0001A\u0010&S1\u0002\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0007C\u0001\u0014(\u001b\u0005\t\u0012B\u0001\u0015\u0012\u0005Y\t%\u000f^5gC\u000e$H)\u0019;b%\u0016\u0004xn]5u_JL\bC\u0001\u0014+\u0013\tY\u0013CA\tEE\u0006\u0013H/\u001b4bGR\fV/\u001a:jKN\u0004\"AJ\u0017\n\u00059\n\"A\u0006#c\u0003J$\u0018NZ1diV\u001b\u0018mZ3Rk\u0016\u0014\u0018.Z:\u0002\u0019)$'m\u0019+f[Bd\u0017\r^3\u0016\u0003E\u0002\"AM\u001e\u000e\u0003MR!\u0001N\u001b\u0002\t\r|'/\u001a\u0006\u0003m]\nAA\u001b3cG*\u0011\u0001(O\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t!(A\u0002pe\u001eL!\u0001P\u001a\u0003\u0019)#'m\u0019+f[Bd\u0017\r^3\u0002\u001b)$'m\u0019+f[Bd\u0017\r^3!\u0003)\u0019\u0018\u000f\u001c#jC2,7\r^\u000b\u0002\u0001B\u0011\u0011\tR\u0007\u0002\u0005*\u0011Ac\u0011\u0006\u0003i]I!!\u0012\"\u0003\u0015M\u000bH\u000eR5bY\u0016\u001cG/A\u0006tc2$\u0015.\u00197fGR\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002J=R\u0011!j\u0013\t\u0003M\u0001AQAP\u0003A\u0004\u0001CCaS'X1B\u0011a*V\u0007\u0002\u001f*\u0011\u0001+U\u0001\u000bC:tw\u000e^1uS>t'B\u0001*T\u0003\u001d1\u0017m\u0019;pefT!\u0001V\u001c\u0002\u000b\t,\u0017M\\:\n\u0005Y{%!C)vC2Lg-[3s\u0003\u00151\u0018\r\\;fC\u0005I\u0016AD7bS:\u001c\u0016\u000f\u001c#jC2,7\r\u001e\u0015\u0003\u0017n\u0003\"A\u0014/\n\u0005u{%!C!vi><\u0018N]3e\u0011\u0015yS\u00011\u00012Q\u0011qVj\u00161\"\u0003\u0005\f\u0001#\\1j]*#'m\u0019+f[Bd\u0017\r^3)\u0005y[\u0016a\u0004:fM\u001a\u0013x.\\\"iK\u000e\\7/^7\u0015\u0005\u0015\u0004\bC\u00014n\u001d\t97\u000e\u0005\u0002iC5\t\u0011N\u0003\u0002k;\u00051AH]8pizJ!\u0001\\\u0011\u0002\rA\u0013X\rZ3g\u0013\tqwN\u0001\u0004TiJLgn\u001a\u0006\u0003Y\u0006BQ!\u001d\u0004A\u0002\u0015\f\u0001b\u00195fG.\u001cX/\\\u0001\u0006gR|'/\u001a\u000b\u0005i^\fi\u0002\u0005\u0002!k&\u0011a/\t\u0002\u0005+:LG\u000fC\u0003y\u000f\u0001\u0007\u00110\u0001\u0002qWB\u0019!0a\u0006\u000f\u0007m\f\tBD\u0002}\u0003\u001bq1!`A\u0006\u001d\rq\u0018\u0011\u0002\b\u0004\u007f\u0006\u001da\u0002BA\u0001\u0003\u000bq1\u0001[A\u0002\u0013\u0005a\u0012B\u0001\u000e\u001c\u0013\tA\u0012$\u0003\u0002\u0017/%\u0011A#F\u0005\u0004\u0003\u001f\u0019\u0012\u0001\u00022bg\u0016LA!a\u0005\u0002\u0016\u00059\u0001/Y2lC\u001e,'bAA\b'%!\u0011\u0011DA\u000e\u0005!\u0019\u0015\u000eU&UsB,'\u0002BA\n\u0003+Aq!a\b\b\u0001\u0004\t\t#A\u0006j]B,Ho\u0015;sK\u0006l\u0007\u0003BA\u0012\u0003[i!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\u0003S>T!!a\u000b\u0002\t)\fg/Y\u0005\u0005\u0003_\t)CA\u0006J]B,Ho\u0015;sK\u0006l\u0017AB5og\u0016\u0014H\u000f\u0006\u0004\u00026\u0005m\u0012q\b\t\u0004A\u0005]\u0012bAA\u001dC\t\u0019\u0011J\u001c;\t\r\u0005u\u0002\u00021\u0001f\u0003\tIG\rC\u0004\u0002 !\u0001\r!!\t\u0002\r\u0015D\u0018n\u001d;t)\u0011\t)%a\u0013\u0011\u0007\u0001\n9%C\u0002\u0002J\u0005\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002>%\u0001\r!\u001a\u000b\u0006i\u0006=\u0013\u0011\u000b\u0005\u0006q*\u0001\r!\u001f\u0005\u0007\u0003'R\u0001\u0019A3\u0002\u0013I,g-\u001a:f]\u000e,\u0017\u0001B2paf$R\u0001^A-\u0003;Ba!a\u0017\f\u0001\u0004)\u0017A\u00024s_6LE\r\u0003\u0004\u0002`-\u0001\r!_\u0001\u0005i>\u00046.\u0001\u0005sKR\u0014\u0018.\u001a<f)\u0011\t\t#!\u001a\t\r\u0005uB\u00021\u0001f\u0003\u0019!W\r\\3uKR\u0019A/a\u001b\t\u000bal\u0001\u0019A=\u0002\rI,Wn\u001c<f)\r!\u0018\u0011\u000f\u0005\u0007\u0003gr\u0001\u0019A3\u0002\u0015\u0005\u0014H/\u001b4bGRLE-\u0001\bd_VtG/\u0011:uS\u001a\f7\r^:\u0016\u0005\u0005U\u0002f\u0001\u0001\u0002|A!\u0011QPAB\u001b\t\tyHC\u0002\u0002\u0002^\n!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t))a \u0003\u0013\r{W\u000e]8oK:$\b")
public class DbArtifactDataRepository
implements ArtifactDataRepository,
DbArtifactQueries,
DbArtifactUsageQueries {
    private final JdbcTemplate jdbcTemplate;
    private final SqlDialect sqlDialect;
    private final String INSERT_USAGE;
    private final String COPY_USAGE;
    private final String SELECT_ARTIFACT_BY_USAGE;
    private final String COUNT_USAGE;
    private final String DELETE_USAGE;
    private final String COUNT_ALL_ARTIFACTS;
    private final String INSERT_ARTIFACT;
    private final String UPDATE_ARTIFACT_ID;
    private final String COUNT_ARTIFACT_BY_ID;
    private final String SELECT_ARTIFACT_BY_PATH;
    private final String DELETE_ARTIFACT;

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    @Override
    public String INSERT_USAGE() {
        return this.INSERT_USAGE;
    }

    @Override
    public String COPY_USAGE() {
        return this.COPY_USAGE;
    }

    @Override
    public String SELECT_ARTIFACT_BY_USAGE() {
        return this.SELECT_ARTIFACT_BY_USAGE;
    }

    @Override
    public String COUNT_USAGE() {
        return this.COUNT_USAGE;
    }

    @Override
    public String DELETE_USAGE() {
        return this.DELETE_USAGE;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactUsageQueries$_setter_$INSERT_USAGE_$eq(String x$1) {
        this.INSERT_USAGE = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactUsageQueries$_setter_$COPY_USAGE_$eq(String x$1) {
        this.COPY_USAGE = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactUsageQueries$_setter_$SELECT_ARTIFACT_BY_USAGE_$eq(String x$1) {
        this.SELECT_ARTIFACT_BY_USAGE = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactUsageQueries$_setter_$COUNT_USAGE_$eq(String x$1) {
        this.COUNT_USAGE = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactUsageQueries$_setter_$DELETE_USAGE_$eq(String x$1) {
        this.DELETE_USAGE = x$1;
    }

    @Override
    public String COUNT_ALL_ARTIFACTS() {
        return this.COUNT_ALL_ARTIFACTS;
    }

    @Override
    public String INSERT_ARTIFACT() {
        return this.INSERT_ARTIFACT;
    }

    @Override
    public String UPDATE_ARTIFACT_ID() {
        return this.UPDATE_ARTIFACT_ID;
    }

    @Override
    public String COUNT_ARTIFACT_BY_ID() {
        return this.COUNT_ARTIFACT_BY_ID;
    }

    @Override
    public String SELECT_ARTIFACT_BY_PATH() {
        return this.SELECT_ARTIFACT_BY_PATH;
    }

    @Override
    public String DELETE_ARTIFACT() {
        return this.DELETE_ARTIFACT;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactQueries$_setter_$COUNT_ALL_ARTIFACTS_$eq(String x$1) {
        this.COUNT_ALL_ARTIFACTS = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactQueries$_setter_$INSERT_ARTIFACT_$eq(String x$1) {
        this.INSERT_ARTIFACT = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactQueries$_setter_$UPDATE_ARTIFACT_ID_$eq(String x$1) {
        this.UPDATE_ARTIFACT_ID = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactQueries$_setter_$COUNT_ARTIFACT_BY_ID_$eq(String x$1) {
        this.COUNT_ARTIFACT_BY_ID = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactQueries$_setter_$SELECT_ARTIFACT_BY_PATH_$eq(String x$1) {
        this.SELECT_ARTIFACT_BY_PATH = x$1;
    }

    @Override
    public void com$xebialabs$deployit$repository$sql$artifacts$DbArtifactQueries$_setter_$DELETE_ARTIFACT_$eq(String x$1) {
        this.DELETE_ARTIFACT = x$1;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    @Override
    public String refFromChecksum(String checksum) {
        return checksum;
    }

    @Override
    public void store(Integer pk, InputStream inputStream) {
        Object object;
        MessageDigest sha1 = JavaCryptoUtils.getSha1();
        DigestInputStream digestInputStream = new DigestInputStream(inputStream, sha1);
        String tempArtifactId = UUID.randomUUID().toString();
        this.insert(tempArtifactId, digestInputStream);
        String checksum = JavaCryptoUtils.digest((MessageDigest)sha1);
        if (this.exists(checksum)) {
            this.remove(tempArtifactId);
            object = BoxedUnit.UNIT;
        } else {
            object = BoxesRunTime.boxToInteger((int)this.jdbcTemplate().update(this.UPDATE_ARTIFACT_ID(), new Object[]{checksum, tempArtifactId}));
        }
        this.insert(pk, checksum);
    }

    public int insert(String id, InputStream inputStream) {
        return this.jdbcTemplate().update(this.INSERT_ARTIFACT(), ps -> {
            ps.setString(1, id);
            ps.setBinaryStream(2, inputStream);
        });
    }

    public boolean exists(String id) {
        return ((Number)this.jdbcTemplate().queryForObject(this.COUNT_ARTIFACT_BY_ID(), Number.class, new Object[]{id})).intValue() > 0;
    }

    @Override
    public void insert(Integer pk, String reference) {
        this.jdbcTemplate().update(this.INSERT_USAGE(), new Object[]{pk, reference});
    }

    @Override
    public void copy(String fromId, Integer toPk) {
        this.jdbcTemplate().update(this.COPY_USAGE(), new Object[]{toPk, fromId});
    }

    @Override
    public InputStream retrieve(String id) {
        return new InputStream(this, id){
            private final Connection con;
            private final PreparedStatement ps;
            private final ResultSet rs;
            private final InputStream delegate;
            private final /* synthetic */ DbArtifactDataRepository $outer;

            private Connection con() {
                return this.con;
            }

            private PreparedStatement ps() {
                return this.ps;
            }

            private ResultSet rs() {
                return this.rs;
            }

            private InputStream delegate() {
                return this.delegate;
            }

            public int read() {
                return this.delegate().read();
            }

            public int read(byte[] b, int off, int len) {
                return this.delegate().read(b, off, len);
            }

            public void close() {
                JdbcUtils.closeResultSet((ResultSet)this.rs());
                JdbcUtils.closeStatement((Statement)this.ps());
                DataSourceUtils.releaseConnection((Connection)this.con(), (DataSource)this.$outer.jdbcTemplate().getDataSource());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.con = DataSourceUtils.getConnection((DataSource)$outer.jdbcTemplate().getDataSource());
                this.ps = this.con().prepareStatement($outer.SELECT_ARTIFACT_BY_PATH());
                this.ps().setString(1, package$.MODULE$.idToPath(id$2));
                this.rs = this.ps().executeQuery();
                if (!this.rs().next()) {
                    throw new NotFoundException(new StringBuilder(29).append("Artifact data not found for: ").append(id$2).toString(), new Object[0]);
                }
                this.delegate = this.rs().getBinaryStream(1);
            }
        };
    }

    @Override
    public void delete(Integer pk) {
        this.jdbcTemplate().queryForList(this.SELECT_ARTIFACT_BY_USAGE(), String.class, new Object[]{pk}).forEach(artifactId -> {
            block0: {
                int count = ((Number)this.jdbcTemplate().queryForObject(this.COUNT_USAGE(), Number.class, new Object[]{artifactId})).intValue();
                Object object = count > 0 ? BoxesRunTime.boxToInteger((int)this.jdbcTemplate().update(this.DELETE_USAGE(), new Object[]{pk})) : BoxedUnit.UNIT;
                if (count != 1) break block0;
                this.remove((String)artifactId);
            }
        });
    }

    public void remove(String artifactId) {
        this.jdbcTemplate().update(this.DELETE_ARTIFACT(), new Object[]{artifactId});
    }

    @Override
    public int countArtifacts() {
        return ((Number)this.jdbcTemplate().queryForObject(this.COUNT_ALL_ARTIFACTS(), Number.class)).intValue();
    }

    public DbArtifactDataRepository(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="mainSqlDialect") SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlDialect = sqlDialect;
        Queries.$init$((Queries)this);
        DbArtifactQueries.$init$(this);
        DbArtifactUsageQueries.$init$(this);
    }
}

