/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker.repository.sql;

import akka.actor.ExtendedActorSystem;
import com.xebialabs.deployit.core.TypeConversions$;
import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.Selectable;
import com.xebialabs.deployit.core.sql.SimpleSelectBuilder;
import com.xebialabs.deployit.core.sql.SqlCondition;
import com.xebialabs.deployit.core.sql.SqlCondition$;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.engine.tasker.TaskNotFoundException;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.repository.PendingTask;
import com.xebialabs.deployit.engine.tasker.repository.PendingTaskRepository;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTaskMetadataQueries;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTaskMetadataSchema$;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTaskSchema$;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTasksQueries;
import com.xebialabs.deployit.engine.tasker.repository.sql.package$;
import com.xebialabs.deployit.engine.tasker.satellite.KryoAkkaSerializer;
import com.xebialabs.deployit.engine.tasker.satellite.KryoBasedSerializer;
import com.xebialabs.deployit.tasksystem.TaskActorSystem$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.HashMap;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Transactional(value="mainTransactionManager")
@ScalaSignature(bytes="\u0006\u0001\tme\u0001B\u000f\u001f\u00015B\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u0013\u0005\t+\u0002\u0011\t\u0011)A\u0005\u0013\"Aa\u000b\u0001BC\u0002\u0013\rq\u000b\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003Y\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u0015Y\b\u0001\"\u0011}\u0011\u001d\tI\u0004\u0001C!\u0003wAq!!\u0010\u0001\t\u0003\ny\u0004C\u0005\u0002|\u0001\t\n\u0011\"\u0001\u0002~!9\u0011\u0011\u0013\u0001\u0005\n\u0005M\u0005bBAL\u0001\u0011%\u0011\u0011\u0014\u0005\b\u0003;\u0003A\u0011BAP\u0011\u001d\ty\u000b\u0001C\u0005\u0003cC\u0011\"a=\u0001#\u0003%I!! \t\u000f\u0005U\b\u0001\"\u0001\u0002x\"9!q\u0001\u0001\u0005B\t%\u0001b\u0002B\u000b\u0001\u0011%!q\u0003\u0005\b\u00057\u0001A\u0011\u0002B\u000f\u0011\u001d\u0011Y\u0003\u0001C!\u0005[AqA!\u000e\u0001\t\u0003\u00129\u0004C\u0004\u0003<\u0001!\tE!\u0010\t\u000f\t\u0015\u0003\u0001\"\u0011\u0003H!9!1\n\u0001\u0005B\t5\u0003b\u0002B.\u0001\u0011%!Q\f\u0005\b\u0005C\u0002A\u0011\u0002B2\u0011\u001d\u00119\u0007\u0001C\u0005\u0005SBqA!\u001c\u0001\t\u0013\u0011y\u0007C\u0004\u0003t\u0001!IA!\u001e\u00031M\u000bH\u000eU3oI&tw\rV1tWJ+\u0007o\\:ji>\u0014\u0018P\u0003\u0002 A\u0005\u00191/\u001d7\u000b\u0005\u0005\u0012\u0013A\u0003:fa>\u001c\u0018\u000e^8ss*\u00111\u0005J\u0001\u0007i\u0006\u001c8.\u001a:\u000b\u0005\u00152\u0013AB3oO&tWM\u0003\u0002(Q\u0005AA-\u001a9m_fLGO\u0003\u0002*U\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002W\u0005\u00191m\\7\u0004\u0001M1\u0001A\f\u001b9y}\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0007CA\u001b7\u001b\u0005\u0001\u0013BA\u001c!\u0005U\u0001VM\u001c3j]\u001e$\u0016m]6SKB|7/\u001b;pef\u0004\"!\u000f\u001e\u000e\u0003yI!a\u000f\u0010\u0003'A+g\u000eZ5oOR\u000b7o[:Rk\u0016\u0014\u0018.Z:\u0011\u0005ej\u0014B\u0001 \u001f\u0005i\u0001VM\u001c3j]\u001e$\u0016m]6NKR\fG-\u0019;b#V,'/[3t!\t\u0001U)D\u0001B\u0015\t\u00115)A\u0003tY\u001a$$NC\u0001E\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001$B\u0005\u001daunZ4j]\u001e\fAB\u001b3cGR+W\u000e\u001d7bi\u0016,\u0012!\u0013\t\u0003\u0015Nk\u0011a\u0013\u0006\u0003\u00196\u000bAaY8sK*\u0011ajT\u0001\u0005U\u0012\u00147M\u0003\u0002Q#\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001S\u0003\ry'oZ\u0005\u0003).\u0013AB\u00133cGR+W\u000e\u001d7bi\u0016\fQB\u001b3cGR+W\u000e\u001d7bi\u0016\u0004\u0013AC:rY\u0012K\u0017\r\\3diV\t\u0001\f\u0005\u0002Z96\t!L\u0003\u0002 7*\u0011AJJ\u0005\u0003;j\u0013!bU9m\t&\fG.Z2u\u0003-\u0019\u0018\u000f\u001c#jC2,7\r\u001e\u0011\u0002\rqJg.\u001b;?)\t\tg\u000f\u0006\u0002cGB\u0011\u0011\b\u0001\u0005\u0006-\u0016\u0001\u001d\u0001\u0017\u0015\u0005G\u0016|\u0007\u000f\u0005\u0002g[6\tqM\u0003\u0002iS\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005)\\\u0017a\u00024bGR|'/\u001f\u0006\u0003Y>\u000bQAY3b]NL!A\\4\u0003\u0013E+\u0018\r\\5gS\u0016\u0014\u0018!\u0002<bYV,\u0017%A9\u0002\u001d5\f\u0017N\\*rY\u0012K\u0017\r\\3di\"\u00121m\u001d\t\u0003MRL!!^4\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"B$\u0006\u0001\u0004I\u0005\u0006\u0002<f_b\f\u0013!_\u0001\u0011[\u0006LgN\u00133cGR+W\u000e\u001d7bi\u0016D#A^:\u0002\u000bQ\f7o[:\u0015\u0007u\fY\u0002E\u0003\u007f\u0003\u000f\tY!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u000b\tAA[1wC&\u0019\u0011\u0011B@\u0003\t1K7\u000f\u001e\t\u0005\u0003\u001b\t9\"\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003%)\u00070Z2vi&|gNC\u0002\u0002\u0016\u0011\n1!\u00199j\u0013\u0011\tI\"a\u0004\u0003\u001bQ\u000b7o[,ji\"\u0014En\\2l\u0011\u001d\tiB\u0002a\u0001\u0003?\tA\u0002\\8bI\u001a+H\u000e\\*qK\u000e\u00042aLA\u0011\u0013\r\t\u0019\u0003\r\u0002\b\u0005>|G.Z1oQ\u00191\u0011qE8\u00024A!\u0011\u0011FA\u0018\u001b\t\tYC\u0003\u0003\u0002.\u0005\r\u0011\u0001\u00027b]\u001eLA!!\r\u0002,\t\u00012+\u001e9qe\u0016\u001c8oV1s]&twm\u001d\u0017\u0003\u0003k\t#!a\u000e\u0002\u0007\u0005dG.\u0001\btG\",G-\u001e7fIR\u000b7o[:\u0015\u0003u\fA\u0001^1tWR1\u0011\u0011IA'\u0003s\u0002RaLA\"\u0003\u000fJ1!!\u00121\u0005\u0019y\u0005\u000f^5p]B\u0019Q'!\u0013\n\u0007\u0005-\u0003EA\u0006QK:$\u0017N\\4UCN\\\u0007bBA(\u0011\u0001\u0007\u0011\u0011K\u0001\u0007i\u0006\u001c8.\u00133\u0011\t\u0005M\u00131\u000f\b\u0005\u0003+\nyG\u0004\u0003\u0002X\u00055d\u0002BA-\u0003WrA!a\u0017\u0002j9!\u0011QLA4\u001d\u0011\ty&!\u001a\u000e\u0005\u0005\u0005$bAA2Y\u00051AH]8pizJ\u0011aK\u0005\u0003S)J!a\n\u0015\n\u0005\u00152\u0013BA\u0012%\u0013\r\t\tHI\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)(a\u001e\u0003\rQ\u000b7o[%e\u0015\r\t\tH\t\u0005\n\u0003;A\u0001\u0013!a\u0001\u0003?\ta\u0002^1tW\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0000)\"\u0011qDAAW\t\t\u0019\t\u0005\u0003\u0002\u0006\u00065UBAAD\u0015\u0011\tI)a#\u0002\u0013Ut7\r[3dW\u0016$'B\u000151\u0013\u0011\ty)a\"\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0006sK\u0006$7+^7nCJLH\u0003BA!\u0003+Cq!a\u0014\u000b\u0001\u0004\t\t&\u0001\u0007sK\u0006$g)\u001e7m'B,7\r\u0006\u0003\u0002B\u0005m\u0005bBA(\u0017\u0001\u0007\u0011\u0011K\u0001\u000ei>\u0004VM\u001c3j]\u001e$\u0016m]6\u0015\t\u0005\u001d\u0013\u0011\u0015\u0005\b\u0003Gc\u0001\u0019AAS\u0003\t\u00118\u000f\u0005\u0003\u0002(\u0006-VBAAU\u0015\ry\u00121A\u0005\u0005\u0003[\u000bIKA\u0005SKN,H\u000e^*fi\u0006)\u0002/\u001a8eS:<G+Y:l\rJ|WNQ5oCJLH\u0003DA$\u0003g\u000b)-!6\u0002j\u0006=\bbBA(\u001b\u0001\u0007\u0011Q\u0017\t\u0005\u0003o\u000byL\u0004\u0003\u0002:\u0006m\u0006cAA0a%\u0019\u0011Q\u0018\u0019\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t-a1\u0003\rM#(/\u001b8h\u0015\r\ti\f\r\u0005\b\u0003\u000fl\u0001\u0019AAe\u00035!\u0018m]6Ta\u0016\u001c')\u001f;fgB)q&a3\u0002P&\u0019\u0011Q\u001a\u0019\u0003\u000b\u0005\u0013(/Y=\u0011\u0007=\n\t.C\u0002\u0002TB\u0012AAQ=uK\"9\u0011q[\u0007A\u0002\u0005e\u0017!D:dQ\u0016$W\u000f\\3e\t\u0006$X\r\u0005\u0003\u0002\\\u0006\u0015XBAAo\u0015\u0011\ty.!9\u0002\tQLW.\u001a\u0006\u0004\u0003G\f\u0016\u0001\u00026pI\u0006LA!a:\u0002^\nAA)\u0019;f)&lW\rC\u0004\u0002l6\u0001\r!!<\u0002\u001b]|'o[3s\u0003\u0012$'/Z:t!\u0015y\u00131IA[\u0011%\t\t0\u0004I\u0001\u0002\u0004\ty\"A\u0007jgN+g\u000e\u001e+p#V,W/Z\u0001 a\u0016tG-\u001b8h)\u0006\u001c8N\u0012:p[\nKg.\u0019:zI\u0011,g-Y;mi\u0012*\u0014!B:u_J,GCBA)\u0003s\u0014)\u0001C\u0004\u0002|>\u0001\r!!@\u0002\tM\u0004Xm\u0019\t\u0005\u0003\u007f\u0014\t!D\u0001#\u0013\r\u0011\u0019A\t\u0002\u0012)\u0006\u001c8n\u00159fG&4\u0017nY1uS>t\u0007\"CAv\u001fA\u0005\t\u0019AAw\u0003\u0019)\b\u000fZ1uKR1!1\u0002B\t\u0005'\u00012a\fB\u0007\u0013\r\u0011y\u0001\r\u0002\u0005+:LG\u000fC\u0004\u0002PA\u0001\r!!\u0015\t\u000f\u0005m\b\u00031\u0001\u0002~\u0006a1\u000f]3d)>\u0014\u0015N\\1ssR!\u0011\u0011\u001aB\r\u0011\u001d\tY0\u0005a\u0001\u0003{\f!b]3sS\u0006d\u0017N_3s+\t\u0011y\u0002\u0005\u0003\u0003\"\t\u001dRB\u0001B\u0012\u0015\r\u0011)CI\u0001\ng\u0006$X\r\u001c7ji\u0016LAA!\u000b\u0003$\t\u00192J]=p\u0005\u0006\u001cX\rZ*fe&\fG.\u001b>fe\u0006Y1\r[1oO\u0016|uO\\3s)\u0019\u0011YAa\f\u00032!9\u0011qJ\nA\u0002\u0005E\u0003b\u0002B\u001a'\u0001\u0007\u0011QW\u0001\t]\u0016<xj\u001e8fe\u0006\tR.\u0019:l\u0003N\u001cVM\u001c;U_F+X-^3\u0015\t\t-!\u0011\b\u0005\b\u0003\u001f\"\u0002\u0019AA[\u0003!\u00198\r[3ek2,GC\u0002B\u0006\u0005\u007f\u0011\t\u0005C\u0004\u0002PU\u0001\r!!\u0015\t\u000f\t\rS\u00031\u0001\u0002Z\u0006!A-\u0019;f\u0003\u0019!W\r\\3uKR!!1\u0002B%\u0011\u001d\tyE\u0006a\u0001\u0003#\n\u0001\u0003\u001d:fa\u0006\u0014X\rV8F]F,X-^3\u0015\t\t=#\u0011\f\t\u0007\u0005#\u0012)&a\u0003\u000e\u0005\tM#bAA\u0001a%!!q\u000bB*\u0005\r!&/\u001f\u0005\b\u0003\u001f:\u0002\u0019AA)\u00035)\u0007\u0010\u001e:bGR$\u0016m]6JIR!\u0011\u0011\u000bB0\u0011\u001d\t\u0019\u000b\u0007a\u0001\u0003K\u000bA#\u001a=ue\u0006\u001cGoV8sW\u0016\u0014\u0018\t\u001a3sKN\u001cH\u0003BAw\u0005KBq!a)\u001a\u0001\u0004\t)+\u0001\u000bfqR\u0014\u0018m\u0019;TG\",G-\u001e7fI\u0012\u000bG/\u001a\u000b\u0005\u00033\u0014Y\u0007C\u0004\u0002$j\u0001\r!!*\u00021\u0015DHO]1diR\u000b7o[*qK\u000eLg-[2bi&|g\u000e\u0006\u0003\u0002J\nE\u0004bBAR7\u0001\u0007\u0011QU\u0001\u0015Kb$(/Y2u\u0013N\u001cVM\u001c;U_F+X-^3\u0015\t\u0005}!q\u000f\u0005\b\u0003Gc\u0002\u0019AASQ\u0019\u0001!1P8\u0003\nB!!Q\u0010BC\u001b\t\u0011yHC\u0002i\u0005\u0003S1Aa!P\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\t\u001d%q\u0010\u0002\u000e)J\fgn]1di&|g.\u00197\"\u0005\t-\u0015AF7bS:$&/\u00198tC\u000e$\u0018n\u001c8NC:\fw-\u001a:)\u0007\u0001\u0011y\t\u0005\u0003\u0003\u0012\n]UB\u0001BJ\u0015\r\u0011)jT\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002BM\u0005'\u0013\u0011bQ8na>tWM\u001c;")
public class SqlPendingTaskRepository
implements PendingTaskRepository,
PendingTasksQueries,
PendingTaskMetadataQueries,
Logging {
    private final JdbcTemplate jdbcTemplate;
    private final SqlDialect sqlDialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private String INSERT_METADATA;
    private String SELECT_METADATA;
    private String DELETE_METADATA;
    private String INSERT;
    private String UPDATE;
    private String UPDATE_OWNER;
    private String SELECT;
    private String SELECT_ALL;
    private String SELECT_ALL_SPECS;
    private String SELECT_SPEC;
    private String DELETE;
    private String UPDATE_SCHEDULED_DATE;
    private String UPDATE_SENT_TO_QUEUE;
    private String SELECT_SCHEDULED;
    private volatile transient boolean bitmap$trans$0;
    private volatile int bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    public Option<String> store$default$2() {
        return PendingTaskRepository.store$default$2$((PendingTaskRepository)this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private String INSERT_METADATA$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 1) == 0) {
                this.INSERT_METADATA = PendingTaskMetadataQueries.INSERT_METADATA$(this);
                this.bitmap$0 |= 1;
            }
        }
        return this.INSERT_METADATA;
    }

    @Override
    public String INSERT_METADATA() {
        return (this.bitmap$0 & 1) == 0 ? this.INSERT_METADATA$lzycompute() : this.INSERT_METADATA;
    }

    private String SELECT_METADATA$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 2) == 0) {
                this.SELECT_METADATA = PendingTaskMetadataQueries.SELECT_METADATA$(this);
                this.bitmap$0 |= 2;
            }
        }
        return this.SELECT_METADATA;
    }

    @Override
    public String SELECT_METADATA() {
        return (this.bitmap$0 & 2) == 0 ? this.SELECT_METADATA$lzycompute() : this.SELECT_METADATA;
    }

    private String DELETE_METADATA$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 4) == 0) {
                this.DELETE_METADATA = PendingTaskMetadataQueries.DELETE_METADATA$(this);
                this.bitmap$0 |= 4;
            }
        }
        return this.DELETE_METADATA;
    }

    @Override
    public String DELETE_METADATA() {
        return (this.bitmap$0 & 4) == 0 ? this.DELETE_METADATA$lzycompute() : this.DELETE_METADATA;
    }

    private String INSERT$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 8) == 0) {
                this.INSERT = PendingTasksQueries.INSERT$(this);
                this.bitmap$0 |= 8;
            }
        }
        return this.INSERT;
    }

    @Override
    public String INSERT() {
        return (this.bitmap$0 & 8) == 0 ? this.INSERT$lzycompute() : this.INSERT;
    }

    private String UPDATE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.UPDATE = PendingTasksQueries.UPDATE$(this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.UPDATE;
    }

    @Override
    public String UPDATE() {
        return (this.bitmap$0 & 0x10) == 0 ? this.UPDATE$lzycompute() : this.UPDATE;
    }

    private String UPDATE_OWNER$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.UPDATE_OWNER = PendingTasksQueries.UPDATE_OWNER$(this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.UPDATE_OWNER;
    }

    @Override
    public String UPDATE_OWNER() {
        return (this.bitmap$0 & 0x20) == 0 ? this.UPDATE_OWNER$lzycompute() : this.UPDATE_OWNER;
    }

    private String SELECT$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.SELECT = PendingTasksQueries.SELECT$(this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.SELECT;
    }

    @Override
    public String SELECT() {
        return (this.bitmap$0 & 0x40) == 0 ? this.SELECT$lzycompute() : this.SELECT;
    }

    private String SELECT_ALL$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.SELECT_ALL = PendingTasksQueries.SELECT_ALL$(this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.SELECT_ALL;
    }

    @Override
    public String SELECT_ALL() {
        return (this.bitmap$0 & 0x80) == 0 ? this.SELECT_ALL$lzycompute() : this.SELECT_ALL;
    }

    private String SELECT_ALL_SPECS$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.SELECT_ALL_SPECS = PendingTasksQueries.SELECT_ALL_SPECS$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.SELECT_ALL_SPECS;
    }

    @Override
    public String SELECT_ALL_SPECS() {
        return (this.bitmap$0 & 0x100) == 0 ? this.SELECT_ALL_SPECS$lzycompute() : this.SELECT_ALL_SPECS;
    }

    private String SELECT_SPEC$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.SELECT_SPEC = PendingTasksQueries.SELECT_SPEC$(this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.SELECT_SPEC;
    }

    @Override
    public String SELECT_SPEC() {
        return (this.bitmap$0 & 0x200) == 0 ? this.SELECT_SPEC$lzycompute() : this.SELECT_SPEC;
    }

    private String DELETE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.DELETE = PendingTasksQueries.DELETE$(this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.DELETE;
    }

    @Override
    public String DELETE() {
        return (this.bitmap$0 & 0x400) == 0 ? this.DELETE$lzycompute() : this.DELETE;
    }

    private String UPDATE_SCHEDULED_DATE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.UPDATE_SCHEDULED_DATE = PendingTasksQueries.UPDATE_SCHEDULED_DATE$(this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.UPDATE_SCHEDULED_DATE;
    }

    @Override
    public String UPDATE_SCHEDULED_DATE() {
        return (this.bitmap$0 & 0x800) == 0 ? this.UPDATE_SCHEDULED_DATE$lzycompute() : this.UPDATE_SCHEDULED_DATE;
    }

    private String UPDATE_SENT_TO_QUEUE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.UPDATE_SENT_TO_QUEUE = PendingTasksQueries.UPDATE_SENT_TO_QUEUE$(this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.UPDATE_SENT_TO_QUEUE;
    }

    @Override
    public String UPDATE_SENT_TO_QUEUE() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.UPDATE_SENT_TO_QUEUE$lzycompute() : this.UPDATE_SENT_TO_QUEUE;
    }

    private String SELECT_SCHEDULED$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.SELECT_SCHEDULED = PendingTasksQueries.SELECT_SCHEDULED$(this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.SELECT_SCHEDULED;
    }

    @Override
    public String SELECT_SCHEDULED() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.SELECT_SCHEDULED$lzycompute() : this.SELECT_SCHEDULED;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    public java.util.List<TaskWithBlock> tasks(boolean loadFullSpec) {
        List tasks = loadFullSpec ? ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().query(this.SELECT_ALL_SPECS(), (rs, x$1) -> this.toPendingTask(rs))).asScala()).toList() : ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().queryForList(this.SELECT_ALL())).asScala()).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.get(PendingTaskSchema$.MODULE$.task_id().name())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Buffer list = (Buffer)tuple2._2();
            java.util.Map task = (java.util.Map)list.head();
            String taskId = (String)task.get(PendingTaskSchema$.MODULE$.task_id().name());
            String taskDescription = (String)task.get(PendingTaskSchema$.MODULE$.task_description().name());
            String owner = (String)task.get(PendingTaskSchema$.MODULE$.task_owner().name());
            String workerAddress = (String)task.get(PendingTaskSchema$.MODULE$.worker_address().name());
            DateTime scheduledDate = (DateTime)Option$.MODULE$.apply(task.get(PendingTaskSchema$.MODULE$.scheduled_date().name())).map((Function1 & Serializable & scala.Serializable)t -> com.xebialabs.deployit.core.sql.package$.MODULE$.toDateTime((Timestamp)t)).orNull(Predef$.MODULE$.$conforms());
            Boolean isSentToQueue = TypeConversions$.MODULE$.enforceBoolean(task.get(PendingTaskSchema$.MODULE$.is_sent_to_queue().name()));
            java.util.Map metadata = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)item -> {
                String key = (String)item.get(PendingTaskMetadataSchema$.MODULE$.metadata_key().name());
                String value = (String)item.get(PendingTaskMetadataSchema$.MODULE$.metadata_value().name());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
            PendingTask pendingTask = new PendingTask(taskId, taskDescription, owner, metadata, scheduledDate, (Option)None$.MODULE$, Option$.MODULE$.apply((Object)workerAddress), Predef$.MODULE$.Boolean2boolean(isSentToQueue));
            return pendingTask;
        }, Iterable$.MODULE$.canBuildFrom())).toList();
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)tasks).asJava();
    }

    public java.util.List<TaskWithBlock> scheduledTasks() {
        return this.jdbcTemplate().query(this.SELECT_SCHEDULED(), (rs, x$3) -> this.toPendingTask(rs));
    }

    public Option<PendingTask> task(String taskId, boolean loadFullSpec) {
        return loadFullSpec ? this.readFullSpec(taskId) : this.readSummary(taskId);
    }

    public boolean task$default$2() {
        return false;
    }

    private Option<PendingTask> readSummary(String taskId) {
        None$ none$;
        try {
            none$ = package$.MODULE$.firstOrNone(this.jdbcTemplate().query(this.SELECT(), (rs, x$4) -> {
                String description = rs.getString(PendingTaskSchema$.MODULE$.task_description().name());
                String owner = rs.getString(PendingTaskSchema$.MODULE$.task_owner().name());
                Option<String> workerAddress = this.extractWorkerAddress(rs);
                DateTime scheduledDate = this.extractScheduledDate(rs);
                boolean isSentToQueue = this.extractIsSentToQueue(rs);
                return new Tuple5((Object)description, (Object)owner, (Object)scheduledDate, workerAddress, (Object)BoxesRunTime.boxToBoolean((boolean)isSentToQueue));
            }, new Object[]{taskId})).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple5 tuple5 = x0$1;
                if (tuple5 == null) {
                    throw new MatchError((Object)tuple5);
                }
                String taskDescription = (String)tuple5._1();
                String owner = (String)tuple5._2();
                DateTime scheduledDate = (DateTime)tuple5._3();
                Option workerAddress = (Option)tuple5._4();
                boolean isSendToQueue = BoxesRunTime.unboxToBoolean((Object)tuple5._5());
                HashMap metadata = (HashMap)this.jdbcTemplate().query(this.SELECT_METADATA(), rs -> {
                    void var1_1;
                    HashMap<String, String> map = new HashMap<String, String>();
                    while (rs.next()) {
                        map.put(rs.getString(PendingTaskMetadataSchema$.MODULE$.metadata_key().name()), rs.getString(PendingTaskMetadataSchema$.MODULE$.metadata_value().name()));
                    }
                    return var1_1;
                }, new Object[]{taskId});
                PendingTask pendingTask = new PendingTask(taskId, taskDescription, owner, (java.util.Map)metadata, scheduledDate, (Option)None$.MODULE$, workerAddress, isSendToQueue);
                return pendingTask;
            });
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> e.getMessage(), (Function0 & Serializable & scala.Serializable)() -> e);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<PendingTask> readFullSpec(String taskId) {
        Option option;
        try {
            option = package$.MODULE$.firstOrNone(this.jdbcTemplate().query(this.SELECT_SPEC(), (rs, x$5) -> this.toPendingTask(rs), new Object[]{taskId}));
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> e.getMessage(), (Function0 & Serializable & scala.Serializable)() -> e);
            option = None$.MODULE$;
        }
        return option;
    }

    private PendingTask toPendingTask(ResultSet rs) {
        return this.pendingTaskFromBinary(this.extractTaskId(rs), this.extractTaskSpecification(rs), this.extractScheduledDate(rs), this.extractWorkerAddress(rs), this.extractIsSentToQueue(rs));
    }

    private PendingTask pendingTaskFromBinary(String taskId, byte[] taskSpecBytes, DateTime scheduledDate, Option<String> workerAddress, boolean isSentToQueue) {
        Object object = this.serializer().fromBinary(taskSpecBytes);
        if (!(object instanceof TaskSpecification)) {
            throw new RuntimeException(new StringBuilder(42).append("Could not deserialize TaskSpecification [").append(taskId).append("]").toString());
        }
        TaskSpecification taskSpecification = (TaskSpecification)object;
        PendingTask pendingTask = new PendingTask(taskId, taskSpecification.getDescription(), taskSpecification.getOwner().getName(), taskSpecification.getMetadata(), scheduledDate, (Option)new Some((Object)taskSpecification), workerAddress, isSentToQueue);
        return pendingTask;
    }

    private boolean pendingTaskFromBinary$default$5() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public String store(TaskSpecification spec, Option<String> workerAddress) {
        void var3_3;
        String taskId = spec.getId();
        byte[] bytes = this.specToBinary(spec);
        this.jdbcTemplate().update(this.INSERT(), new Object[]{taskId, spec.getDescription(), spec.getOwner().getName(), bytes, workerAddress.orNull(Predef$.MODULE$.$conforms())});
        spec.getMetadata().forEach((k, v) -> this.jdbcTemplate().update(this.INSERT_METADATA(), new Object[]{taskId, k, v}));
        return var3_3;
    }

    public void update(String taskId, TaskSpecification spec) {
        byte[] bytes = this.specToBinary(spec);
        try {
            this.jdbcTemplate().update(this.UPDATE(), new Object[]{bytes, taskId});
        }
        catch (Exception exception) {
            throw new TaskNotFoundException("pending tasks", taskId);
        }
    }

    private byte[] specToBinary(TaskSpecification spec) {
        byte[] value;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.serializer().toBinary((Object)spec));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                this.logger().error((Function0 & Serializable & scala.Serializable)() -> exception.getMessage(), (Function0 & Serializable & scala.Serializable)() -> exception);
                throw exception;
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        byte[] byArray = value = (byte[])success.value();
        return byArray;
    }

    private KryoBasedSerializer serializer() {
        return new KryoAkkaSerializer((ExtendedActorSystem)TaskActorSystem$.MODULE$.actorSystem()).serializer();
    }

    public void changeOwner(String taskId, String newOwner) {
        this.jdbcTemplate().update(this.UPDATE_OWNER(), new Object[]{newOwner, taskId});
    }

    public void markAsSentToQueue(String taskId) {
        this.jdbcTemplate().update(this.UPDATE_SENT_TO_QUEUE(), new Object[]{Boolean.TRUE, taskId});
    }

    public void schedule(String taskId, DateTime date) {
        this.jdbcTemplate().update(this.UPDATE_SCHEDULED_DATE(), new Object[]{com.xebialabs.deployit.core.sql.package$.MODULE$.toTimestamp(date), taskId});
    }

    public void delete(String taskId) {
        this.jdbcTemplate().update(this.DELETE_METADATA(), new Object[]{taskId});
        this.jdbcTemplate().update(this.DELETE(), new Object[]{taskId});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Try<TaskWithBlock> prepareToEnqueue(String taskId) {
        SimpleSelectBuilder q = this.sqlDialect().lockSelectBuilder(PendingTaskSchema$.MODULE$.tableName(), this.sqlDialect()).select((Selectable)PendingTaskSchema$.MODULE$.task_id()).select((Selectable)PendingTaskSchema$.MODULE$.scheduled_date()).select((Selectable)PendingTaskSchema$.MODULE$.task_specification()).select((Selectable)PendingTaskSchema$.MODULE$.worker_address()).select((Selectable)PendingTaskSchema$.MODULE$.is_sent_to_queue()).where((SqlCondition)SqlCondition$.MODULE$.equals((Selectable)PendingTaskSchema$.MODULE$.task_id(), taskId));
        boolean bl = false;
        Some some = null;
        Option option = package$.MODULE$.firstOrNone(this.jdbcTemplate().query(q.query(), (rs, x$6) -> {
            DateTime scheduledDate = this.extractScheduledDate(rs);
            Option<String> workerAddress = this.extractWorkerAddress(rs);
            return this.pendingTaskFromBinary(this.extractTaskId(rs), this.extractTaskSpecification(rs), scheduledDate, workerAddress, this.extractIsSentToQueue(rs));
        }, new Object[]{taskId}));
        if (None$.MODULE$.equals(option)) {
            return new Failure((Throwable)new RuntimeException(new StringBuilder(21).append("Task [").append(taskId).append("] was not found").toString()));
        }
        if (option instanceof Some) {
            PendingTask pendingTask;
            bl = true;
            some = (Some)option;
            TaskWithBlock task = (TaskWithBlock)some.value();
            if (task instanceof PendingTask && (pendingTask = (PendingTask)task).isSentToQueue()) {
                return new Failure((Throwable)new RuntimeException(new StringBuilder(32).append("Task [").append(taskId).append("] is already sent to queue").toString()));
            }
        }
        if (!bl) throw new MatchError(option);
        TaskWithBlock task = (TaskWithBlock)some.value();
        return new Success((Object)task);
    }

    private String extractTaskId(ResultSet rs) {
        return rs.getString(PendingTaskSchema$.MODULE$.task_id().name());
    }

    private Option<String> extractWorkerAddress(ResultSet rs) {
        return Option$.MODULE$.apply((Object)rs.getString(PendingTaskSchema$.MODULE$.worker_address().name()));
    }

    private DateTime extractScheduledDate(ResultSet rs) {
        return (DateTime)Option$.MODULE$.apply((Object)rs.getTimestamp(PendingTaskSchema$.MODULE$.scheduled_date().name())).map((Function1 & Serializable & scala.Serializable)t -> com.xebialabs.deployit.core.sql.package$.MODULE$.toDateTime(t)).orNull(Predef$.MODULE$.$conforms());
    }

    private byte[] extractTaskSpecification(ResultSet rs) {
        return rs.getBytes(PendingTaskSchema$.MODULE$.task_specification().name());
    }

    private boolean extractIsSentToQueue(ResultSet rs) {
        return rs.getBoolean(PendingTaskSchema$.MODULE$.is_sent_to_queue().name());
    }

    public SqlPendingTaskRepository(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="mainSqlDialect") SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlDialect = sqlDialect;
        Queries.$init$((Queries)this);
        PendingTasksQueries.$init$(this);
        PendingTaskMetadataQueries.$init$(this);
        Logging.$init$((Logging)this);
    }
}

