/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker.repository.sql;

import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import com.xebialabs.deployit.core.TypeConversions$;
import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.Selectable;
import com.xebialabs.deployit.core.sql.SimpleSelectBuilder;
import com.xebialabs.deployit.core.sql.SqlCondition;
import com.xebialabs.deployit.core.sql.SqlCondition$;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.engine.tasker.TaskNotFoundException;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.repository.PendingTask;
import com.xebialabs.deployit.engine.tasker.repository.PendingTaskRepository;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTaskMetadataQueries;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTaskMetadataSchema$;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTaskSchema$;
import com.xebialabs.deployit.engine.tasker.repository.sql.PendingTasksQueries;
import com.xebialabs.deployit.engine.tasker.repository.sql.package$;
import com.xebialabs.deployit.engine.tasker.satellite.KryoAkkaSerializer;
import com.xebialabs.deployit.tasksystem.TaskActorSystem$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.HashMap;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@Transactional(value="mainTransactionManager")
@ScalaSignature(bytes="\u0006\u0001\tme\u0001B\u000f\u001f\u00015B\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u0013\u0005\t+\u0002\u0011\t\u0011)A\u0005\u0013\"Aa\u000b\u0001BC\u0002\u0013\rq\u000b\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003Y\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u0015Y\b\u0001\"\u0011}\u0011\u001d\tI\u0004\u0001C!\u0003wAq!!\u0010\u0001\t\u0003\ny\u0004C\u0005\u0002|\u0001\t\n\u0011\"\u0001\u0002~!9\u0011\u0011\u0013\u0001\u0005\n\u0005M\u0005bBAL\u0001\u0011%\u0011\u0011\u0014\u0005\b\u0003;\u0003A\u0011BAP\u0011\u001d\ty\u000b\u0001C\u0005\u0003cC\u0011\"a=\u0001#\u0003%I!! \t\u000f\u0005U\b\u0001\"\u0001\u0002x\"9!q\u0001\u0001\u0005B\t%\u0001b\u0002B\u000b\u0001\u0011%!q\u0003\u0005\u000b\u00057\u0001\u0001R1A\u0005\n\tu\u0001b\u0002B\u0016\u0001\u0011\u0005#Q\u0006\u0005\b\u0005k\u0001A\u0011\tB\u001c\u0011\u001d\u0011Y\u0004\u0001C!\u0005{AqA!\u0012\u0001\t\u0003\u00129\u0005C\u0004\u0003L\u0001!\tE!\u0014\t\u000f\tm\u0003\u0001\"\u0003\u0003^!9!\u0011\r\u0001\u0005\n\t\r\u0004b\u0002B4\u0001\u0011%!\u0011\u000e\u0005\b\u0005[\u0002A\u0011\u0002B8\u0011\u001d\u0011\u0019\b\u0001C\u0005\u0005k\u0012\u0001dU9m!\u0016tG-\u001b8h)\u0006\u001c8NU3q_NLGo\u001c:z\u0015\ty\u0002%A\u0002tc2T!!\t\u0012\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002$I\u00051A/Y:lKJT!!\n\u0014\u0002\r\u0015tw-\u001b8f\u0015\t9\u0003&\u0001\u0005eKBdw._5u\u0015\tI#&A\u0005yK\nL\u0017\r\\1cg*\t1&A\u0002d_6\u001c\u0001a\u0005\u0004\u0001]QBDh\u0010\t\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U2T\"\u0001\u0011\n\u0005]\u0002#!\u0006)f]\u0012Lgn\u001a+bg.\u0014V\r]8tSR|'/\u001f\t\u0003sij\u0011AH\u0005\u0003wy\u00111\u0003U3oI&tw\rV1tWN\fV/\u001a:jKN\u0004\"!O\u001f\n\u0005yr\"A\u0007)f]\u0012Lgn\u001a+bg.lU\r^1eCR\f\u0017+^3sS\u0016\u001c\bC\u0001!F\u001b\u0005\t%B\u0001\"D\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005!\u0015\u0001C4sSjTH.\u001a3\n\u0005\u0019\u000b%a\u0002'pO\u001eLgnZ\u0001\rU\u0012\u00147\rV3na2\fG/Z\u000b\u0002\u0013B\u0011!jU\u0007\u0002\u0017*\u0011A*T\u0001\u0005G>\u0014XM\u0003\u0002O\u001f\u0006!!\u000e\u001a2d\u0015\t\u0001\u0016+A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005\u0011\u0016aA8sO&\u0011Ak\u0013\u0002\r\u0015\u0012\u00147\rV3na2\fG/Z\u0001\u000eU\u0012\u00147\rV3na2\fG/\u001a\u0011\u0002\u0015M\fH\u000eR5bY\u0016\u001cG/F\u0001Y!\tIF,D\u0001[\u0015\ty2L\u0003\u0002MM%\u0011QL\u0017\u0002\u000b'FdG)[1mK\u000e$\u0018aC:rY\u0012K\u0017\r\\3di\u0002\na\u0001P5oSRtDCA1w)\t\u00117\r\u0005\u0002:\u0001!)a+\u0002a\u00021\"\"1-Z8q!\t1W.D\u0001h\u0015\tA\u0017.\u0001\u0006b]:|G/\u0019;j_:T!A[6\u0002\u000f\u0019\f7\r^8ss*\u0011AnT\u0001\u0006E\u0016\fgn]\u0005\u0003]\u001e\u0014\u0011\"U;bY&4\u0017.\u001a:\u0002\u000bY\fG.^3\"\u0003E\fa\"\\1j]N\u000bH\u000eR5bY\u0016\u001cG\u000f\u000b\u0002dgB\u0011a\r^\u0005\u0003k\u001e\u0014\u0011\"Q;u_^L'/\u001a3\t\u000b\u001d+\u0001\u0019A%)\tY,w\u000e_\u0011\u0002s\u0006\u0001R.Y5o\u0015\u0012\u00147\rV3na2\fG/\u001a\u0015\u0003mN\fQ\u0001^1tWN$2!`A\u000e!\u0015q\u0018qAA\u0006\u001b\u0005y(\u0002BA\u0001\u0003\u0007\tA!\u001e;jY*\u0011\u0011QA\u0001\u0005U\u00064\u0018-C\u0002\u0002\n}\u0014A\u0001T5tiB!\u0011QBA\f\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011!C3yK\u000e,H/[8o\u0015\r\t)\u0002J\u0001\u0004CBL\u0017\u0002BA\r\u0003\u001f\u0011Q\u0002V1tW^KG\u000f\u001b\"m_\u000e\\\u0007bBA\u000f\r\u0001\u0007\u0011qD\u0001\rY>\fGMR;mYN\u0003Xm\u0019\t\u0004_\u0005\u0005\u0012bAA\u0012a\t9!i\\8mK\u0006t\u0007F\u0002\u0004\u0002(=\f\u0019\u0004\u0005\u0003\u0002*\u0005=RBAA\u0016\u0015\u0011\ti#a\u0001\u0002\t1\fgnZ\u0005\u0005\u0003c\tYC\u0001\tTkB\u0004(/Z:t/\u0006\u0014h.\u001b8hg2\u0012\u0011QG\u0011\u0003\u0003o\t1!\u00197m\u00039\u00198\r[3ek2,G\rV1tWN$\u0012!`\u0001\u0005i\u0006\u001c8\u000e\u0006\u0004\u0002B\u00055\u0013\u0011\u0010\t\u0006_\u0005\r\u0013qI\u0005\u0004\u0003\u000b\u0002$AB(qi&|g\u000eE\u00026\u0003\u0013J1!a\u0013!\u0005-\u0001VM\u001c3j]\u001e$\u0016m]6\t\u000f\u0005=\u0003\u00021\u0001\u0002R\u00051A/Y:l\u0013\u0012\u0004B!a\u0015\u0002t9!\u0011QKA8\u001d\u0011\t9&!\u001c\u000f\t\u0005e\u00131\u000e\b\u0005\u00037\nIG\u0004\u0003\u0002^\u0005\u001dd\u0002BA0\u0003Kj!!!\u0019\u000b\u0007\u0005\rD&\u0001\u0004=e>|GOP\u0005\u0002W%\u0011\u0011FK\u0005\u0003O!J!!\n\u0014\n\u0005\r\"\u0013bAA9E\u00059\u0001/Y2lC\u001e,\u0017\u0002BA;\u0003o\u0012a\u0001V1tW&#'bAA9E!I\u0011Q\u0004\u0005\u0011\u0002\u0003\u0007\u0011qD\u0001\u000fi\u0006\u001c8\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\tyH\u000b\u0003\u0002 \u0005\u00055FAAB!\u0011\t))!$\u000e\u0005\u0005\u001d%\u0002BAE\u0003\u0017\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005!\u0004\u0014\u0002BAH\u0003\u000f\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003-\u0011X-\u00193Tk6l\u0017M]=\u0015\t\u0005\u0005\u0013Q\u0013\u0005\b\u0003\u001fR\u0001\u0019AA)\u00031\u0011X-\u00193Gk2d7\u000b]3d)\u0011\t\t%a'\t\u000f\u0005=3\u00021\u0001\u0002R\u0005iAo\u001c)f]\u0012Lgn\u001a+bg.$B!a\u0012\u0002\"\"9\u00111\u0015\u0007A\u0002\u0005\u0015\u0016A\u0001:t!\u0011\t9+a+\u000e\u0005\u0005%&bA\u0010\u0002\u0004%!\u0011QVAU\u0005%\u0011Vm];miN+G/A\u000bqK:$\u0017N\\4UCN\\gI]8n\u0005&t\u0017M]=\u0015\u0019\u0005\u001d\u00131WAc\u0003+\fI/a<\t\u000f\u0005=S\u00021\u0001\u00026B!\u0011qWA`\u001d\u0011\tI,a/\u0011\u0007\u0005}\u0003'C\u0002\u0002>B\na\u0001\u0015:fI\u00164\u0017\u0002BAa\u0003\u0007\u0014aa\u0015;sS:<'bAA_a!9\u0011qY\u0007A\u0002\u0005%\u0017!\u0004;bg.\u001c\u0006/Z2CsR,7\u000fE\u00030\u0003\u0017\fy-C\u0002\u0002NB\u0012Q!\u0011:sCf\u00042aLAi\u0013\r\t\u0019\u000e\r\u0002\u0005\u0005f$X\rC\u0004\u0002X6\u0001\r!!7\u0002\u001bM\u001c\u0007.\u001a3vY\u0016$G)\u0019;f!\u0011\tY.!:\u000e\u0005\u0005u'\u0002BAp\u0003C\fA\u0001^5nK*\u0019\u00111])\u0002\t)|G-Y\u0005\u0005\u0003O\fiN\u0001\u0005ECR,G+[7f\u0011\u001d\tY/\u0004a\u0001\u0003[\fQb^8sW\u0016\u0014\u0018\t\u001a3sKN\u001c\b#B\u0018\u0002D\u0005U\u0006\"CAy\u001bA\u0005\t\u0019AA\u0010\u00035I7oU3oiR{\u0017+^3vK\u0006y\u0002/\u001a8eS:<G+Y:l\rJ|WNQ5oCJLH\u0005Z3gCVdG\u000fJ\u001b\u0002\u000bM$xN]3\u0015\r\u0005E\u0013\u0011 B\u0003\u0011\u001d\tYp\u0004a\u0001\u0003{\fAa\u001d9fGB!\u0011q B\u0001\u001b\u0005\u0011\u0013b\u0001B\u0002E\t\tB+Y:l'B,7-\u001b4jG\u0006$\u0018n\u001c8\t\u0013\u0005-x\u0002%AA\u0002\u00055\u0018AB;qI\u0006$X\r\u0006\u0004\u0003\f\tE!1\u0003\t\u0004_\t5\u0011b\u0001B\ba\t!QK\\5u\u0011\u001d\ty\u0005\u0005a\u0001\u0003#Bq!a?\u0011\u0001\u0004\ti0\u0001\u0007ta\u0016\u001cGk\u001c\"j]\u0006\u0014\u0018\u0010\u0006\u0003\u0002J\ne\u0001bBA~#\u0001\u0007\u0011Q`\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014XC\u0001B\u0010!\u0011\u0011\tCa\n\u000e\u0005\t\r\"b\u0001B\u0013E\u0005I1/\u0019;fY2LG/Z\u0005\u0005\u0005S\u0011\u0019C\u0001\nLef|\u0017i[6b'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018aC2iC:<WmT<oKJ$bAa\u0003\u00030\tE\u0002bBA('\u0001\u0007\u0011\u0011\u000b\u0005\b\u0005g\u0019\u0002\u0019AA[\u0003!qWm^(x]\u0016\u0014\u0018!E7be.\f5oU3oiR{\u0017+^3vKR!!1\u0002B\u001d\u0011\u001d\ty\u0005\u0006a\u0001\u0003k\u000b\u0001b]2iK\u0012,H.\u001a\u000b\u0007\u0005\u0017\u0011yD!\u0011\t\u000f\u0005=S\u00031\u0001\u0002R!9!1I\u000bA\u0002\u0005e\u0017\u0001\u00023bi\u0016\fa\u0001Z3mKR,G\u0003\u0002B\u0006\u0005\u0013Bq!a\u0014\u0017\u0001\u0004\t\t&\u0001\tqe\u0016\u0004\u0018M]3U_\u0016s\u0017/^3vKR!!q\nB-!\u0019\u0011\tF!\u0016\u0002\f5\u0011!1\u000b\u0006\u0004\u0003\u0003\u0001\u0014\u0002\u0002B,\u0005'\u00121\u0001\u0016:z\u0011\u001d\tye\u0006a\u0001\u0003#\nQ\"\u001a=ue\u0006\u001cG\u000fV1tW&#G\u0003BA)\u0005?Bq!a)\u0019\u0001\u0004\t)+\u0001\u000bfqR\u0014\u0018m\u0019;X_J\\WM]!eIJ,7o\u001d\u000b\u0005\u0003[\u0014)\u0007C\u0004\u0002$f\u0001\r!!*\u0002)\u0015DHO]1diN\u001b\u0007.\u001a3vY\u0016$G)\u0019;f)\u0011\tINa\u001b\t\u000f\u0005\r&\u00041\u0001\u0002&\u0006AR\r\u001f;sC\u000e$H+Y:l'B,7-\u001b4jG\u0006$\u0018n\u001c8\u0015\t\u0005%'\u0011\u000f\u0005\b\u0003G[\u0002\u0019AAS\u0003Q)\u0007\u0010\u001e:bGRL5oU3oiR{\u0017+^3vKR!\u0011q\u0004B<\u0011\u001d\t\u0019\u000b\ba\u0001\u0003KCc\u0001\u0001B>_\n%\u0005\u0003\u0002B?\u0005\u000bk!Aa \u000b\u0007!\u0014\tIC\u0002\u0003\u0004>\u000b1\u0002\u001e:b]N\f7\r^5p]&!!q\u0011B@\u00055!&/\u00198tC\u000e$\u0018n\u001c8bY\u0006\u0012!1R\u0001\u0017[\u0006Lg\u000e\u0016:b]N\f7\r^5p]6\u000bg.Y4fe\"\u001a\u0001Aa$\u0011\t\tE%qS\u0007\u0003\u0005'S1A!&P\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u00053\u0013\u0019JA\u0005D_6\u0004xN\\3oi\u0002")
public class SqlPendingTaskRepository
implements PendingTaskRepository,
PendingTasksQueries,
PendingTaskMetadataQueries,
Logging {
    private KryoAkkaSerializer serializer;
    private final JdbcTemplate jdbcTemplate;
    private final SqlDialect sqlDialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private String INSERT_METADATA;
    private String SELECT_METADATA;
    private String DELETE_METADATA;
    private String INSERT;
    private String UPDATE;
    private String UPDATE_OWNER;
    private String SELECT;
    private String SELECT_ALL;
    private String SELECT_ALL_SPECS;
    private String SELECT_SPEC;
    private String DELETE;
    private String UPDATE_SCHEDULED_DATE;
    private String UPDATE_SENT_TO_QUEUE;
    private String SELECT_SCHEDULED;
    private volatile transient boolean bitmap$trans$0;
    private volatile int bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    public Option<String> store$default$2() {
        return PendingTaskRepository.store$default$2$((PendingTaskRepository)this);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private String INSERT_METADATA$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 2) == 0) {
                this.INSERT_METADATA = PendingTaskMetadataQueries.INSERT_METADATA$(this);
                this.bitmap$0 |= 2;
            }
        }
        return this.INSERT_METADATA;
    }

    @Override
    public String INSERT_METADATA() {
        return (this.bitmap$0 & 2) == 0 ? this.INSERT_METADATA$lzycompute() : this.INSERT_METADATA;
    }

    private String SELECT_METADATA$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 4) == 0) {
                this.SELECT_METADATA = PendingTaskMetadataQueries.SELECT_METADATA$(this);
                this.bitmap$0 |= 4;
            }
        }
        return this.SELECT_METADATA;
    }

    @Override
    public String SELECT_METADATA() {
        return (this.bitmap$0 & 4) == 0 ? this.SELECT_METADATA$lzycompute() : this.SELECT_METADATA;
    }

    private String DELETE_METADATA$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 8) == 0) {
                this.DELETE_METADATA = PendingTaskMetadataQueries.DELETE_METADATA$(this);
                this.bitmap$0 |= 8;
            }
        }
        return this.DELETE_METADATA;
    }

    @Override
    public String DELETE_METADATA() {
        return (this.bitmap$0 & 8) == 0 ? this.DELETE_METADATA$lzycompute() : this.DELETE_METADATA;
    }

    private String INSERT$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.INSERT = PendingTasksQueries.INSERT$(this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.INSERT;
    }

    @Override
    public String INSERT() {
        return (this.bitmap$0 & 0x10) == 0 ? this.INSERT$lzycompute() : this.INSERT;
    }

    private String UPDATE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.UPDATE = PendingTasksQueries.UPDATE$(this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.UPDATE;
    }

    @Override
    public String UPDATE() {
        return (this.bitmap$0 & 0x20) == 0 ? this.UPDATE$lzycompute() : this.UPDATE;
    }

    private String UPDATE_OWNER$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.UPDATE_OWNER = PendingTasksQueries.UPDATE_OWNER$(this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.UPDATE_OWNER;
    }

    @Override
    public String UPDATE_OWNER() {
        return (this.bitmap$0 & 0x40) == 0 ? this.UPDATE_OWNER$lzycompute() : this.UPDATE_OWNER;
    }

    private String SELECT$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.SELECT = PendingTasksQueries.SELECT$(this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.SELECT;
    }

    @Override
    public String SELECT() {
        return (this.bitmap$0 & 0x80) == 0 ? this.SELECT$lzycompute() : this.SELECT;
    }

    private String SELECT_ALL$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.SELECT_ALL = PendingTasksQueries.SELECT_ALL$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.SELECT_ALL;
    }

    @Override
    public String SELECT_ALL() {
        return (this.bitmap$0 & 0x100) == 0 ? this.SELECT_ALL$lzycompute() : this.SELECT_ALL;
    }

    private String SELECT_ALL_SPECS$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.SELECT_ALL_SPECS = PendingTasksQueries.SELECT_ALL_SPECS$(this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.SELECT_ALL_SPECS;
    }

    @Override
    public String SELECT_ALL_SPECS() {
        return (this.bitmap$0 & 0x200) == 0 ? this.SELECT_ALL_SPECS$lzycompute() : this.SELECT_ALL_SPECS;
    }

    private String SELECT_SPEC$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.SELECT_SPEC = PendingTasksQueries.SELECT_SPEC$(this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.SELECT_SPEC;
    }

    @Override
    public String SELECT_SPEC() {
        return (this.bitmap$0 & 0x400) == 0 ? this.SELECT_SPEC$lzycompute() : this.SELECT_SPEC;
    }

    private String DELETE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.DELETE = PendingTasksQueries.DELETE$(this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.DELETE;
    }

    @Override
    public String DELETE() {
        return (this.bitmap$0 & 0x800) == 0 ? this.DELETE$lzycompute() : this.DELETE;
    }

    private String UPDATE_SCHEDULED_DATE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.UPDATE_SCHEDULED_DATE = PendingTasksQueries.UPDATE_SCHEDULED_DATE$(this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.UPDATE_SCHEDULED_DATE;
    }

    @Override
    public String UPDATE_SCHEDULED_DATE() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.UPDATE_SCHEDULED_DATE$lzycompute() : this.UPDATE_SCHEDULED_DATE;
    }

    private String UPDATE_SENT_TO_QUEUE$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.UPDATE_SENT_TO_QUEUE = PendingTasksQueries.UPDATE_SENT_TO_QUEUE$(this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.UPDATE_SENT_TO_QUEUE;
    }

    @Override
    public String UPDATE_SENT_TO_QUEUE() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.UPDATE_SENT_TO_QUEUE$lzycompute() : this.UPDATE_SENT_TO_QUEUE;
    }

    private String SELECT_SCHEDULED$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.SELECT_SCHEDULED = PendingTasksQueries.SELECT_SCHEDULED$(this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.SELECT_SCHEDULED;
    }

    @Override
    public String SELECT_SCHEDULED() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.SELECT_SCHEDULED$lzycompute() : this.SELECT_SCHEDULED;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    public java.util.List<TaskWithBlock> tasks(boolean loadFullSpec) {
        List tasks = loadFullSpec ? ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().query(this.SELECT_ALL_SPECS(), (rs, x$1) -> this.toPendingTask(rs))).asScala()).toList() : ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().queryForList(this.SELECT_ALL())).asScala()).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.get(PendingTaskSchema$.MODULE$.task_id().name())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Buffer list = (Buffer)tuple2._2();
            java.util.Map task = (java.util.Map)list.head();
            String taskId = (String)task.get(PendingTaskSchema$.MODULE$.task_id().name());
            String taskDescription = (String)task.get(PendingTaskSchema$.MODULE$.task_description().name());
            String owner = (String)task.get(PendingTaskSchema$.MODULE$.task_owner().name());
            String workerAddress = (String)task.get(PendingTaskSchema$.MODULE$.worker_address().name());
            DateTime scheduledDate = (DateTime)Option$.MODULE$.apply(task.get(PendingTaskSchema$.MODULE$.scheduled_date().name())).map((Function1 & Serializable & scala.Serializable)t -> com.xebialabs.deployit.core.sql.package$.MODULE$.toDateTime((Timestamp)t)).orNull(Predef$.MODULE$.$conforms());
            Boolean isSentToQueue = TypeConversions$.MODULE$.enforceBoolean(task.get(PendingTaskSchema$.MODULE$.is_sent_to_queue().name()));
            java.util.Map metadata = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)item -> {
                String key = (String)item.get(PendingTaskMetadataSchema$.MODULE$.metadata_key().name());
                String value = (String)item.get(PendingTaskMetadataSchema$.MODULE$.metadata_value().name());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
            PendingTask pendingTask = new PendingTask(taskId, taskDescription, owner, metadata, scheduledDate, (Option)None$.MODULE$, Option$.MODULE$.apply((Object)workerAddress), Predef$.MODULE$.Boolean2boolean(isSentToQueue));
            return pendingTask;
        }, Iterable$.MODULE$.canBuildFrom())).toList();
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)tasks).asJava();
    }

    public java.util.List<TaskWithBlock> scheduledTasks() {
        return this.jdbcTemplate().query(this.SELECT_SCHEDULED(), (rs, x$3) -> this.toPendingTask(rs));
    }

    public Option<PendingTask> task(String taskId, boolean loadFullSpec) {
        return loadFullSpec ? this.readFullSpec(taskId) : this.readSummary(taskId);
    }

    public boolean task$default$2() {
        return false;
    }

    private Option<PendingTask> readSummary(String taskId) {
        None$ none$;
        try {
            none$ = package$.MODULE$.firstOrNone(this.jdbcTemplate().query(this.SELECT(), (rs, x$4) -> {
                String description = rs.getString(PendingTaskSchema$.MODULE$.task_description().name());
                String owner = rs.getString(PendingTaskSchema$.MODULE$.task_owner().name());
                Option<String> workerAddress = this.extractWorkerAddress(rs);
                DateTime scheduledDate = this.extractScheduledDate(rs);
                boolean isSentToQueue = this.extractIsSentToQueue(rs);
                return new Tuple5((Object)description, (Object)owner, (Object)scheduledDate, workerAddress, (Object)BoxesRunTime.boxToBoolean((boolean)isSentToQueue));
            }, new Object[]{taskId})).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple5 tuple5 = x0$1;
                if (tuple5 == null) {
                    throw new MatchError((Object)tuple5);
                }
                String taskDescription = (String)tuple5._1();
                String owner = (String)tuple5._2();
                DateTime scheduledDate = (DateTime)tuple5._3();
                Option workerAddress = (Option)tuple5._4();
                boolean isSendToQueue = BoxesRunTime.unboxToBoolean((Object)tuple5._5());
                HashMap metadata = (HashMap)this.jdbcTemplate().query(this.SELECT_METADATA(), rs -> {
                    void var1_1;
                    HashMap<String, String> map = new HashMap<String, String>();
                    while (rs.next()) {
                        map.put(rs.getString(PendingTaskMetadataSchema$.MODULE$.metadata_key().name()), rs.getString(PendingTaskMetadataSchema$.MODULE$.metadata_value().name()));
                    }
                    return var1_1;
                }, new Object[]{taskId});
                PendingTask pendingTask = new PendingTask(taskId, taskDescription, owner, (java.util.Map)metadata, scheduledDate, (Option)None$.MODULE$, workerAddress, isSendToQueue);
                return pendingTask;
            });
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> e.getMessage(), (Function0 & Serializable & scala.Serializable)() -> e);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<PendingTask> readFullSpec(String taskId) {
        Option option;
        try {
            option = package$.MODULE$.firstOrNone(this.jdbcTemplate().query(this.SELECT_SPEC(), (rs, x$5) -> this.toPendingTask(rs), new Object[]{taskId}));
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> e.getMessage(), (Function0 & Serializable & scala.Serializable)() -> e);
            option = None$.MODULE$;
        }
        return option;
    }

    private PendingTask toPendingTask(ResultSet rs) {
        return this.pendingTaskFromBinary(this.extractTaskId(rs), this.extractTaskSpecification(rs), this.extractScheduledDate(rs), this.extractWorkerAddress(rs), this.extractIsSentToQueue(rs));
    }

    private PendingTask pendingTaskFromBinary(String taskId, byte[] taskSpecBytes, DateTime scheduledDate, Option<String> workerAddress, boolean isSentToQueue) {
        Object object = this.serializer().fromBinary(taskSpecBytes);
        if (!(object instanceof TaskSpecification)) {
            throw new RuntimeException(new StringBuilder(42).append("Could not deserialize TaskSpecification [").append(taskId).append("]").toString());
        }
        TaskSpecification taskSpecification = (TaskSpecification)object;
        PendingTask pendingTask = new PendingTask(taskId, taskSpecification.getDescription(), taskSpecification.getOwner().getName(), taskSpecification.getMetadata(), scheduledDate, (Option)new Some((Object)taskSpecification), workerAddress, isSentToQueue);
        return pendingTask;
    }

    private boolean pendingTaskFromBinary$default$5() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public String store(TaskSpecification spec, Option<String> workerAddress) {
        void var3_3;
        String taskId = spec.getId();
        byte[] bytes = this.specToBinary(spec);
        this.jdbcTemplate().update(this.INSERT(), new Object[]{taskId, spec.getDescription(), spec.getOwner().getName(), bytes, workerAddress.orNull(Predef$.MODULE$.$conforms())});
        spec.getMetadata().forEach((k, v) -> this.jdbcTemplate().update(this.INSERT_METADATA(), new Object[]{taskId, k, v}));
        return var3_3;
    }

    public void update(String taskId, TaskSpecification spec) {
        byte[] bytes = this.specToBinary(spec);
        try {
            this.jdbcTemplate().update(this.UPDATE(), new Object[]{bytes, taskId});
        }
        catch (Exception exception) {
            throw new TaskNotFoundException("pending tasks", taskId);
        }
    }

    private byte[] specToBinary(TaskSpecification spec) {
        byte[] value;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.serializer().toBinary((Object)spec));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                this.logger().error((Function0 & Serializable & scala.Serializable)() -> exception.getMessage(), (Function0 & Serializable & scala.Serializable)() -> exception);
                throw exception;
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        byte[] byArray = value = (byte[])success.value();
        return byArray;
    }

    private KryoAkkaSerializer serializer$lzycompute() {
        SqlPendingTaskRepository sqlPendingTaskRepository = this;
        synchronized (sqlPendingTaskRepository) {
            if ((this.bitmap$0 & 1) == 0) {
                this.serializer = (KryoAkkaSerializer)((Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)((ExtendedActorSystem)TaskActorSystem$.MODULE$.actorSystem()))).serializerFor(Serializable.class);
                this.bitmap$0 |= 1;
            }
        }
        return this.serializer;
    }

    private KryoAkkaSerializer serializer() {
        return (this.bitmap$0 & 1) == 0 ? this.serializer$lzycompute() : this.serializer;
    }

    public void changeOwner(String taskId, String newOwner) {
        this.jdbcTemplate().update(this.UPDATE_OWNER(), new Object[]{newOwner, taskId});
    }

    public void markAsSentToQueue(String taskId) {
        this.jdbcTemplate().update(this.UPDATE_SENT_TO_QUEUE(), new Object[]{Boolean.TRUE, taskId});
    }

    public void schedule(String taskId, DateTime date) {
        this.jdbcTemplate().update(this.UPDATE_SCHEDULED_DATE(), new Object[]{com.xebialabs.deployit.core.sql.package$.MODULE$.toTimestamp(date), taskId});
    }

    public void delete(String taskId) {
        this.jdbcTemplate().update(this.DELETE_METADATA(), new Object[]{taskId});
        this.jdbcTemplate().update(this.DELETE(), new Object[]{taskId});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Try<TaskWithBlock> prepareToEnqueue(String taskId) {
        SimpleSelectBuilder q = this.sqlDialect().lockSelectBuilder(PendingTaskSchema$.MODULE$.tableName(), this.sqlDialect()).select((Selectable)PendingTaskSchema$.MODULE$.task_id()).select((Selectable)PendingTaskSchema$.MODULE$.scheduled_date()).select((Selectable)PendingTaskSchema$.MODULE$.task_specification()).select((Selectable)PendingTaskSchema$.MODULE$.worker_address()).select((Selectable)PendingTaskSchema$.MODULE$.is_sent_to_queue()).where((SqlCondition)SqlCondition$.MODULE$.equals((Selectable)PendingTaskSchema$.MODULE$.task_id(), taskId));
        boolean bl = false;
        Some some = null;
        Option option = package$.MODULE$.firstOrNone(this.jdbcTemplate().query(q.query(), (rs, x$6) -> {
            DateTime scheduledDate = this.extractScheduledDate(rs);
            Option<String> workerAddress = this.extractWorkerAddress(rs);
            return this.pendingTaskFromBinary(this.extractTaskId(rs), this.extractTaskSpecification(rs), scheduledDate, workerAddress, this.extractIsSentToQueue(rs));
        }, new Object[]{taskId}));
        if (None$.MODULE$.equals(option)) {
            return new Failure((Throwable)new RuntimeException(new StringBuilder(21).append("Task [").append(taskId).append("] was not found").toString()));
        }
        if (option instanceof Some) {
            PendingTask pendingTask;
            bl = true;
            some = (Some)option;
            TaskWithBlock task = (TaskWithBlock)some.value();
            if (task instanceof PendingTask && (pendingTask = (PendingTask)task).isSentToQueue()) {
                return new Failure((Throwable)new RuntimeException(new StringBuilder(32).append("Task [").append(taskId).append("] is already sent to queue").toString()));
            }
        }
        if (!bl) throw new MatchError(option);
        TaskWithBlock task = (TaskWithBlock)some.value();
        return new Success((Object)task);
    }

    private String extractTaskId(ResultSet rs) {
        return rs.getString(PendingTaskSchema$.MODULE$.task_id().name());
    }

    private Option<String> extractWorkerAddress(ResultSet rs) {
        return Option$.MODULE$.apply((Object)rs.getString(PendingTaskSchema$.MODULE$.worker_address().name()));
    }

    private DateTime extractScheduledDate(ResultSet rs) {
        return (DateTime)Option$.MODULE$.apply((Object)rs.getTimestamp(PendingTaskSchema$.MODULE$.scheduled_date().name())).map((Function1 & Serializable & scala.Serializable)t -> com.xebialabs.deployit.core.sql.package$.MODULE$.toDateTime(t)).orNull(Predef$.MODULE$.$conforms());
    }

    private byte[] extractTaskSpecification(ResultSet rs) {
        return rs.getBytes(PendingTaskSchema$.MODULE$.task_specification().name());
    }

    private boolean extractIsSentToQueue(ResultSet rs) {
        return rs.getBoolean(PendingTaskSchema$.MODULE$.is_sent_to_queue().name());
    }

    public SqlPendingTaskRepository(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="mainSqlDialect") SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlDialect = sqlDialect;
        Queries.$init$((Queries)this);
        PendingTasksQueries.$init$(this);
        PendingTaskMetadataQueries.$init$(this);
        Logging.$init$((Logging)this);
    }
}

