/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.archive.queue;

import com.xebialabs.deployit.task.archive.BatchSecureCiMessage;
import com.xebialabs.deployit.task.archive.BatchTaskArchiveRepository;
import com.xebialabs.deployit.task.archive.SecureCiMessage;
import com.xebialabs.deployit.task.archive.TaskMessage;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.stereotype.Component;
import scala.;
import scala.$less$colon$less$;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Component
@Autowired
@ScalaSignature(bytes="\u0006\u0005\u00014A!\u0002\u0004\u0001'!A!\u0004\u0001B\u0001B\u0003%1\u0004\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0011\u0015q\u0003\u0001\"\u00010\u0011\u0015!\u0004\u0001\"\u00016\u0005\u0001\"U\r\u001d7ps6,g\u000e^!sG\"Lg/Z'fgN\fw-Z\"p]N,X.\u001a:\u000b\u0005\u001dA\u0011!B9vKV,'BA\u0005\u000b\u0003\u001d\t'o\u00195jm\u0016T!a\u0003\u0007\u0002\tQ\f7o\u001b\u0006\u0003\u001b9\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003\u001fA\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003E\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\r\u0005s\u0017PU3g\u0003U!\u0018m]6Be\u000eD\u0017N^3SKB|7/\u001b;pef\u0004\"\u0001H\u000f\u000e\u0003!I!A\b\u0005\u00035\t\u000bGo\u00195UCN\\\u0017I]2iSZ,'+\u001a9pg&$xN]=\u00025)\f7m[:p]*k7/T3tg\u0006<WmQ8om\u0016\u0014H/\u001a:\u0011\u0005\u0005bS\"\u0001\u0012\u000b\u0005\r\"\u0013!C2p]Z,'\u000f^3s\u0015\t)c%A\u0004tkB\u0004xN\u001d;\u000b\u0005\u001dB\u0013a\u00016ng*\u0011\u0011FK\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t1&A\u0002pe\u001eL!!\f\u0012\u0003!5+7o]1hK\u000e{gN^3si\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u00021eM\u0002\"!\r\u0001\u000e\u0003\u0019AQAG\u0002A\u0002mAQaH\u0002A\u0002\u0001\n!C]3dK&4X\rV3yi6+7o]1hKR\u0011a'\u000f\t\u0003+]J!\u0001\u000f\f\u0003\tUs\u0017\u000e\u001e\u0005\u0006u\u0011\u0001\raO\u0001\b[\u0016\u001c8/Y4f!\ta\u0004)D\u0001>\u0015\t9cHC\u0001@\u0003\u0015Q\u0017M^1y\u0013\t\tUHA\u0006UKb$X*Z:tC\u001e,\u0007F\u0002\u0003D\u0013*cU\n\u0005\u0002E\u000f6\tQI\u0003\u0002GM\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005!+%a\u0003&ng2K7\u000f^3oKJ\f1\u0002Z3ti&t\u0017\r^5p]\u0006\n1*A\u0016$w\u0002\u000b'o\u00195jm\u0016\fV/Z;f\u001d\u0006lWMU3t_24XM\u001d\u0018hKR\fV/Z;f\u001d\u0006lW\rK\u0015~\u0003A\u0019wN\u001c;bS:,'OR1di>\u0014\u00180I\u0001O\u0003uAHNS7t\u0019&\u001cH/\u001a8fe\u000e{g\u000e^1j]\u0016\u0014h)Y2u_JL\bF\u0001\u0001Q!\t\tv+D\u0001S\u0015\t15K\u0003\u0002U+\u00069a-Y2u_JL(B\u0001,)\u0003\u0015\u0011W-\u00198t\u0013\tA&KA\u0005BkR|w/\u001b:fI\"\u0012\u0001A\u0017\t\u00037zk\u0011\u0001\u0018\u0006\u0003;\"\n!b\u001d;fe\u0016|G/\u001f9f\u0013\tyFLA\u0005D_6\u0004xN\\3oi\u0002")
public class DeploymentArchiveMessageConsumer {
    private final BatchTaskArchiveRepository taskArchiveRepository;
    private final MessageConverter jacksonJmsMessageConverter;

    /*
     * Enabled aggressive block sorting
     */
    @JmsListener(destination="#{@archiveQueueNameResolver.getQueueName()}", containerFactory="xlJmsListenerContainerFactory")
    public void receiveTextMessage(TextMessage message) {
        boolean bl = false;
        SecureCiMessage secureCiMessage = null;
        Object object = this.jacksonJmsMessageConverter.fromMessage((Message)message);
        if (object instanceof TaskMessage) {
            TaskMessage taskMessage = (TaskMessage)object;
            this.taskArchiveRepository.store(taskMessage);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (object instanceof SecureCiMessage) {
            bl = true;
            secureCiMessage = (SecureCiMessage)object;
            if (message.getBooleanProperty("isBatch")) {
                this.taskArchiveRepository.updateSecureCi(secureCiMessage.securedCi(), secureCiMessage.environmentIds(), secureCiMessage.applicationIds(), secureCiMessage.otherCiIds());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl) {
            this.taskArchiveRepository.updateSecureCi((Integer)secureCiMessage.primaryKey().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), secureCiMessage.securedCi());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (!(object instanceof BatchSecureCiMessage)) throw new MatchError(object);
        BatchSecureCiMessage batchSecureCiMessage = (BatchSecureCiMessage)object;
        this.taskArchiveRepository.batchUpdateSecureCi(batchSecureCiMessage);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public DeploymentArchiveMessageConsumer(BatchTaskArchiveRepository taskArchiveRepository, MessageConverter jacksonJmsMessageConverter) {
        this.taskArchiveRepository = taskArchiveRepository;
        this.jacksonJmsMessageConverter = jacksonJmsMessageConverter;
    }
}

