package ai.digital.deploy.metrics.repository

import ai.digital.deploy.metrics.model._
import com.xebialabs.deployit.engine.api.dto.{Ordering, Paging}

trait CiMetricsRepository {
  def findCis(ciTypes: List[String], path: Option[String], createdBy: Option[String], createdAt:Option[String], paging: Paging, order: Ordering): List[CiMetrics]
  def getCisCount(ciTypes: List[String], path: Option[String], createdBy: Option[String], createdAt:Option[String], plugins:Option[List[String]]): CiCount
  def getPluginsCountByApplication: Int
  def getPluginsCountByEnvironment: Int
  def getPluginsCountByInfra(ciTypes : List[String]): Int
  def getPluginsDataByApplication(ciIds: List[Int], plugins:Option[List[String]]): List[PluginMetrics]
  def getPluginsDataByEnvironment(ciIds: List[Int], plugins:Option[List[String]]): List[PluginMetrics]
  def getPluginsDataByInfra(ciIds: List[Int], plugins:Option[List[String]]): List[PluginMetrics]
  def getSubFoldersCount(path: Option[String]): FoldersCount
  def getUsersCount(ciTypes: List[String]): UsersCountByCi
}
