package ai.digital.deploy.metrics.api

import ai.digital.deploy.metrics.model._
import com.xebialabs.deployit.engine.api.dto.{Ordering, Paging}

import jakarta.ws.rs.core.MediaType
import jakarta.ws.rs._

@Path("/internal/metrics")
@Consumes(Array(MediaType.APPLICATION_JSON))
@Produces(Array(MediaType.APPLICATION_JSON))
trait CiMetricsService {
  @POST
  @Path("listConfigurationItems")
  def listConfigurationItems(filter: CiMetricsFilter, paging: Paging, order: Ordering): List[CiPluginMetrics]
  @POST
  @Path("getConfigurationItemsCount")
  def getConfigurationItemsCount(filter: CiMetricsFilter): CiCount
  @GET
  @Path("getUsersCountByCI")
  def getUsersCountByCI: UsersCountByCi
  @GET
  @Path("getPluginsCountByCI")
  def getPluginsCountByCI: PluginsCountByCi
  @GET
  @Path("getSubFoldersCountByCI")
  def getSubFoldersCountByCI(@QueryParam("path") path:String): FoldersCount
}
