package com.xebialabs.deployit.plugin.test.v3;

import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployedArtifact;
import com.xebialabs.deployit.plugin.test.v3.step.TestCreateStep;
import com.xebialabs.deployit.plugin.test.v3.step.TestDestroyStep;

@SuppressWarnings("serial")
public class HostDeployedConfigurationFiles extends BaseDeployedArtifact<ConfigurationFiles, DummyHost> {

	@Property(required = false)
	private Set<String> dummySetOfStrings;
	

	@Create
	public void deploy(DeploymentPlanningContext result) {
    	for (int i = 0; i < getContainer().getNumberOfSteps(); i++) {
			result.addStep(new TestCreateStep(getContainer(), i));
		}
    }

    @Modify
    public void upgrade(DeploymentPlanningContext result) {
    	destroy(result);
    	deploy(result);
    }

    @Destroy
	public void destroy(DeploymentPlanningContext result) {
    	for (int i = 0; i < getContainer().getNumberOfSteps(); i++) {
			result.addStep(new TestDestroyStep(getContainer(), i));
		}
    }

	public Set<String> getDummySetOfStrings() {
		return dummySetOfStrings;
	}

	public void setDummySetOfStrings(Set<String> dummySetOfStrings) {
		this.dummySetOfStrings = dummySetOfStrings;
	}
	
	@SuppressWarnings("unused")
    private static final Logger logger = LoggerFactory.getLogger(HostDeployedConfigurationFiles.class);
	
	
	
}
