/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.test.yak.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatchStep
implements Step {
    private transient CountDownLatch countDownLatch;
    private static final Logger logger = LoggerFactory.getLogger(LatchStep.class);

    public LatchStep(CountDownLatch countDownLatch) {
        this.countDownLatch = countDownLatch;
    }

    public String getDescription() {
        return "Waits until latch is triggered";
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        try {
            logger.debug("Executing LatchStep started");
            this.countDownLatch.await();
            logger.debug("CountDownLatch in LatchStep didn't throw InterruptedException");
        }
        catch (InterruptedException e) {
            logger.debug("CountDownLatch in LatchStep thrown InterruptedException");
            Thread currentThread = Thread.currentThread();
            logger.debug("Interrupting thread {}", (Object)currentThread.getId());
            currentThread.interrupt();
            return StepExitCode.FAIL;
        }
        return StepExitCode.FAIL;
    }

    public int getOrder() {
        return 40;
    }
}

