/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.test.yak.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.rules.StepParameter;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;

@StepMetadata(name="reference-check-step")
public class ReferenceCheckStep
implements Step {
    @StepParameter(description="Deployed")
    private Deployed deployed;
    @StepParameter(description="Deployed Application")
    private DeployedApplication deployedApplication;

    public int getOrder() {
        return 50;
    }

    public String getDescription() {
        return "Reference check step";
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        ctx.logOutput("Reference check step integration test started");
        this.checkCiReference((ConfigurationItem)this.deployed, (ConfigurationItem)this.deployedApplication.getDeployeds().iterator().next(), ctx);
        this.checkCiReference((ConfigurationItem)this.deployed.getDeployable(), (ConfigurationItem)this.deployedApplication.getVersion().getDeployables().iterator().next(), ctx);
        this.checkCiReference((ConfigurationItem)this.deployed.getContainer(), (ConfigurationItem)this.deployedApplication.getEnvironment().getMembers().iterator().next(), ctx);
        return StepExitCode.SUCCESS;
    }

    private void checkCiReference(ConfigurationItem first, ConfigurationItem second, ExecutionContext ctx) {
        boolean firstEqual = first.equals(second);
        boolean secondEqual = first == second;
        ctx.logOutput(first.getId() + " equals " + second.getId() + " | " + String.valueOf(firstEqual));
        ctx.logOutput(first.getId() + " == " + second.getId() + " | " + String.valueOf(secondEqual));
        if (!firstEqual || !secondEqual) {
            throw new RuntimeException("reference and equality check failed for CI " + first.getId());
        }
    }
}

