/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.test.v3.step;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.test.v3.VirtualEnvironment;
import java.util.HashSet;
import java.util.Set;

public class DestroyVirtualEnvironmentStep
implements Step {
    private final String environmentId;

    public DestroyVirtualEnvironmentStep(String environmentId) {
        this.environmentId = environmentId;
    }

    public int getOrder() {
        return 40;
    }

    public String getDescription() {
        return "Deleting environment and instances of " + this.environmentId;
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        try {
            Repository repository = ctx.getRepository();
            VirtualEnvironment environment = (VirtualEnvironment)repository.read(this.environmentId);
            HashSet instanceIds = Sets.newHashSet();
            Set instances = environment.getLinkedHosts();
            for (ConfigurationItem instance : instances) {
                instanceIds.add(instance.getId());
            }
            ctx.logOutput("Deleting Environment: " + this.environmentId);
            repository.delete(new String[]{this.environmentId});
            for (String id : instanceIds) {
                ctx.logOutput("Deleting instance: " + id);
                repository.delete(new String[]{id});
            }
            return StepExitCode.SUCCESS;
        }
        catch (Exception e) {
            ctx.logError("Exception while trying to delete environment", (Throwable)e);
            return StepExitCode.FAIL;
        }
    }
}

