package com.xebialabs.gradle.plugins

import org.gradle.api.Plugin
import org.gradle.api.Project

public abstract class AbstractBundlingPluginPlugin implements Plugin<Project> {

  abstract String getPluginExtension()

  @Override
  public void apply(Project project) {
    project.apply plugin: "xebialabs.plugin.base"
    project.apply plugin: "xebialabs.plugin-bundle"

    project.tasks[XLPluginBundlePlugin.BUNDLING_TASK_NAME].configure {
      extension = getPluginExtension()
    }
  }
}
