/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.cli;

import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.domain.profiles.OperatorProfile;
import ai.digital.integration.server.common.util.XlCliUtil;
import de.undercouch.gradle.tasks.download.Download;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.tasks.Copy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/deploy/tasks/cli/DownloadXlCliDistTask;", "Lorg/gradle/api/DefaultTask;", "()V", "Companion", "integration-server-gradle-plugin"})
public class DownloadXlCliDistTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "downloadXlCliDist";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public DownloadXlCliDistTask() {
        this.setGroup("Integration Server");
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        OperatorHelper operatorHelper = OperatorHelper.Companion.getOperatorHelper(project);
        OperatorProfile profile = operatorHelper.getProfile();
        String taskName = "xlCliExec";
        if (profile.getXlCliVersion().isPresent()) {
            Object object = profile.getXlCliVersion().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"profile.xlCliVersion.get()");
            final String version = (String)object;
            Project project2 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            project2.getLogger().lifecycle("Downloading XL cli " + version + '.');
            Object object2 = profile.getCliNightly().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"profile.cliNightly.get()");
            if (((Boolean)object2).booleanValue()) {
                Project project3 = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
                ScriptHandler scriptHandler = project3.getBuildscript();
                Intrinsics.checkExpressionValueIsNotNull((Object)scriptHandler, (String)"project.buildscript");
                scriptHandler.getDependencies().add("xlCliDist", (Object)("com.xebialabs.xlclient:xl-client:" + version + ':' + XlCliUtil.Companion.getOsFolder() + "@bin"));
                Project project4 = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
                ScriptHandler scriptHandler2 = project4.getBuildscript();
                Intrinsics.checkExpressionValueIsNotNull((Object)scriptHandler2, (String)"project.buildscript");
                Configuration configuration = scriptHandler2.getConfigurations().getByName("xlCliDist");
                Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"project.buildscript.conf\u2026ns.getByName(XL_CLI_DIST)");
                File file = configuration.getSingleFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.buildscript.conf\u2026e(XL_CLI_DIST).singleFile");
                final File fromFile = file;
                Object[] objectArray = new Object[1];
                Project project5 = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"project");
                objectArray[0] = project5.getTasks().register(taskName, Copy.class, (Action)new Action<Copy>(){

                    public final void execute(@NotNull Copy $this$register) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$register, (String)"$receiver");
                        $this$register.from(new Object[]{fromFile});
                        Project project = $this$register.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                        $this$register.into((Object)XlCliUtil.Companion.localDir(project));
                        $this$register.rename(fromFile.getName(), "xl");
                    }
                });
                this.dependsOn(objectArray);
            } else {
                Object[] objectArray = new Object[1];
                Project project6 = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project6, (String)"project");
                objectArray[0] = project6.getTasks().register(taskName, Download.class, (Action)new Action<Download>(){

                    public final void execute(@NotNull Download $this$register) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$register, (String)"$receiver");
                        $this$register.src((Object)XlCliUtil.Companion.distUrl(version));
                        Project project = $this$register.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                        $this$register.dest((Object)XlCliUtil.Companion.localDir(project));
                    }
                });
                this.dependsOn(objectArray);
            }
        } else if (profile.getXlCliPath().isPresent()) {
            Object object = profile.getXlCliPath().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"profile.xlCliPath.get()");
            final String path = (String)object;
            if (StringsKt.startsWith$default((String)path, (String)"http", (boolean)false, (int)2, null)) {
                Object[] objectArray = new Object[1];
                Project project7 = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project7, (String)"project");
                objectArray[0] = project7.getTasks().register(taskName, Download.class, (Action)new Action<Download>(){

                    public final void execute(@NotNull Download $this$register) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$register, (String)"$receiver");
                        $this$register.src((Object)path);
                        Project project = $this$register.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                        $this$register.dest((Object)XlCliUtil.Companion.localDir(project));
                    }
                });
                this.dependsOn(objectArray);
            } else {
                Object[] objectArray = new Object[1];
                Project project8 = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project8, (String)"project");
                objectArray[0] = project8.getTasks().register(taskName, Copy.class, (Action)new Action<Copy>(){

                    public final void execute(@NotNull Copy $this$register) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$register, (String)"$receiver");
                        $this$register.from(new Object[]{path});
                        Project project = $this$register.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                        $this$register.into((Object)XlCliUtil.Companion.localDir(project));
                    }
                });
                this.dependsOn(objectArray);
            }
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/cli/DownloadXlCliDistTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

