/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.release.tasks.cluster.operator;

import ai.digital.integration.server.common.constant.OperatorProviderName;
import ai.digital.integration.server.release.tasks.cluster.ReleaseClusterUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/release/tasks/cluster/operator/OperatorBasedInstallReleaseClusterTask;", "Lorg/gradle/api/DefaultTask;", "()V", "launch", "", "Companion", "integration-server-gradle-plugin"})
public class OperatorBasedInstallReleaseClusterTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "operatorBasedInstallReleaseCluster";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        String providerName = ReleaseClusterUtil.Companion.getOperatorProvider(project);
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        project2.getLogger().lifecycle("Operator based Release Cluster with provider " + providerName + " has started.");
    }

    public OperatorBasedInstallReleaseClusterTask() {
        String string;
        this.setGroup("Integration Server");
        Object[] objectArray = new Object[1];
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        String providerName = ReleaseClusterUtil.Companion.getOperatorProvider(project);
        if (Intrinsics.areEqual((Object)providerName, (Object)OperatorProviderName.AWS_EKS.getProviderName())) {
            string = "operatorBasedAwsEksInstallReleaseCluster";
        } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorProviderName.AWS_OPENSHIFT.getProviderName())) {
            string = "operatorBasedAwsOpenShiftInstallReleaseCluster";
        } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorProviderName.AZURE_AKS.getProviderName())) {
            string = "operatorBasedAzureAksInstallReleaseCluster";
        } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorProviderName.GCP_GKE.getProviderName())) {
            string = "operatorBasedGcpGkeInstallReleaseCluster";
        } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorProviderName.ON_PREMISE.getProviderName())) {
            string = "operatorBasedOnPremInstallReleaseCluster";
        } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorProviderName.VMWARE_OPENSHIFT.getProviderName())) {
            string = "operatorBasedVmWareOpenShiftInstallReleaseCluster";
        } else {
            throw (Throwable)new IllegalArgumentException("Provided operator provider name `" + providerName + "` is not supported. Choose one of " + ArraysKt.joinToString$default((Object[])OperatorProviderName.values(), null, null, null, (int)0, null, null, (int)63, null));
        }
        objectArray[0] = string;
        this.dependsOn(objectArray);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/release/tasks/cluster/operator/OperatorBasedInstallReleaseClusterTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

