/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.tls;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010$\u001a\u00020\rH'J\b\u0010%\u001a\u00020&H&J \u0010'\u001a\u0004\u0018\u00010(2\u000e\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00132\u0006\u0010*\u001a\u00020&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR \u0010\f\u001a\u0004\u0018\u00010\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00138\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\t\"\u0004\b\u001a\u0010\u000bR \u0010\u001b\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\t\"\u0004\b\u001d\u0010\u000bR\u001e\u0010\u001e\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\t\"\u0004\b \u0010\u000bR\u001e\u0010!\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\t\"\u0004\b#\u0010\u000b\u00a8\u0006+"}, d2={"Lai/digital/integration/server/common/tls/KeytoolTask;", "Lorg/gradle/api/DefaultTask;", "execOperations", "Lorg/gradle/process/ExecOperations;", "<init>", "(Lorg/gradle/process/ExecOperations;)V", "keyname", "", "getKeyname", "()Ljava/lang/String;", "setKeyname", "(Ljava/lang/String;)V", "workDir", "Ljava/io/File;", "getWorkDir", "()Ljava/io/File;", "setWorkDir", "(Ljava/io/File;)V", "params", "", "getParams", "()Ljava/util/List;", "setParams", "(Ljava/util/List;)V", "keypass", "getKeypass", "setKeypass", "storepass", "getStorepass", "setStorepass", "type", "getType", "setType", "typeExtension", "getTypeExtension", "setTypeExtension", "getOutputFile", "skipIfOutputFileExists", "", "execTask", "Lorg/gradle/process/ExecResult;", "customParams", "skipExec", "integration-server-gradle-plugin"})
public abstract class KeytoolTask
extends DefaultTask {
    @NotNull
    private final ExecOperations execOperations;
    @Input
    @Nullable
    private String keyname;
    @InputDirectory
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @Nullable
    private File workDir;
    @Input
    @NotNull
    private List<String> params;
    @Input
    @Nullable
    private String keypass;
    @Input
    @Nullable
    private String storepass;
    @Input
    @NotNull
    private String type;
    @Input
    @NotNull
    private String typeExtension;

    @Inject
    public KeytoolTask(@NotNull ExecOperations execOperations) {
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        this.execOperations = execOperations;
        this.setGroup("Integration Server");
        Object[] objectArray = new Object[]{"serverCopyOverlays"};
        this.mustRunAfter(objectArray);
        objectArray = new Object[]{"centralConfiguration"};
        this.mustRunAfter(objectArray);
        this.doFirst(new Action(){

            public final void execute(Task $this$doFirst) {
                Intrinsics.checkNotNullParameter((Object)$this$doFirst, (String)"$this$doFirst");
                ArrayList customParams = new ArrayList(this.getParams());
                ExecResult result = this.execTask(customParams, this.skipIfOutputFileExists());
                if (result != null && result.getExitValue() == 1) {
                    throw new RuntimeException("Running keytool with params: " + CollectionsKt.joinToString$default((Iterable)customParams, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + " was not successfully executed.");
                }
            }
        });
        this.params = CollectionsKt.emptyList();
        this.type = "pkcs12";
        this.typeExtension = "p12";
    }

    @Nullable
    public final String getKeyname() {
        return this.keyname;
    }

    public final void setKeyname(@Nullable String string) {
        this.keyname = string;
    }

    @Nullable
    public final File getWorkDir() {
        return this.workDir;
    }

    public final void setWorkDir(@Nullable File file) {
        this.workDir = file;
    }

    @NotNull
    protected final List<String> getParams() {
        return this.params;
    }

    protected final void setParams(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.params = list;
    }

    @Nullable
    public final String getKeypass() {
        return this.keypass;
    }

    public final void setKeypass(@Nullable String string) {
        this.keypass = string;
    }

    @Nullable
    public final String getStorepass() {
        return this.storepass;
    }

    public final void setStorepass(@Nullable String string) {
        this.storepass = string;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    public final void setType(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.type = string;
    }

    @NotNull
    public final String getTypeExtension() {
        return this.typeExtension;
    }

    public final void setTypeExtension(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.typeExtension = string;
    }

    @OutputFile
    @NotNull
    public abstract File getOutputFile();

    public abstract boolean skipIfOutputFileExists();

    @Nullable
    public final ExecResult execTask(@NotNull List<String> customParams, boolean skipExec) {
        ExecResult execResult;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(customParams, (String)"customParams");
        ArrayList<String> strings = new ArrayList<String>((Collection)customParams);
        if (this.keypass != null && !Intrinsics.areEqual((Object)this.type, (Object)"pkcs12")) {
            objectArray = new String[]{"-keypass", this.keypass};
            strings.addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        if (this.storepass != null) {
            objectArray = new String[]{"-storepass", this.storepass};
            strings.addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        if (skipExec && this.getOutputFile().exists()) {
            this.getProject().getLogger().lifecycle("Skipping keytool with args: " + CollectionsKt.joinToString$default((Iterable)strings, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            execResult = null;
        } else {
            this.getProject().getLogger().lifecycle("Executing keytool with args: " + CollectionsKt.joinToString$default((Iterable)strings, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            execResult = this.execOperations.exec(new Action(strings, this){
                final /* synthetic */ ArrayList<String> $strings;
                final /* synthetic */ KeytoolTask this$0;
                {
                    this.$strings = $strings;
                    this.this$0 = $receiver;
                }

                public final void execute(ExecSpec $this$exec) {
                    Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                    $this$exec.setExecutable("keytool");
                    $this$exec.setArgs((List)this.$strings);
                    $this$exec.setWorkingDir(this.this$0.getWorkDir());
                    $this$exec.setIgnoreExitValue(true);
                }
            });
        }
        return execResult;
    }
}

