/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import ai.digital.integration.server.common.domain.DbParameters;
import java.sql.Connection;
import java.sql.Driver;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/common/util/DbConfigurationUtil;", "", "<init>", "()V", "Companion", "integration-server-gradle-plugin"})
public final class DbConfigurationUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0005J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lai/digital/integration/server/common/util/DbConfigurationUtil$Companion;", "", "<init>", "()V", "connectionProperties", "Ljava/util/Properties;", "username", "", "password", "createDriverConnection", "Ljava/sql/Connection;", "driverClass", "url", "properties", "configureConnection", "Lorg/dbunit/database/DatabaseConnection;", "driverConnection", "dbDependency", "Lai/digital/integration/server/common/domain/DbParameters;", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Properties connectionProperties(@NotNull String username, @NotNull String password) {
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            Properties properties = new Properties();
            ((Map)properties).put("user", username);
            ((Map)properties).put("password", password);
            return properties;
        }

        @NotNull
        public final Connection createDriverConnection(@NotNull String driverClass, @NotNull String url, @NotNull Properties properties) {
            Intrinsics.checkNotNullParameter((Object)driverClass, (String)"driverClass");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            Object obj = Class.forName(driverClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type java.sql.Driver");
            Driver driver = (Driver)obj;
            Connection driverConnection = driver.connect(url, properties);
            driverConnection.setAutoCommit(true);
            Intrinsics.checkNotNull((Object)driverConnection);
            return driverConnection;
        }

        @NotNull
        public final DatabaseConnection configureConnection(@NotNull Connection driverConnection, @NotNull DbParameters dbDependency) {
            Intrinsics.checkNotNullParameter((Object)driverConnection, (String)"driverConnection");
            Intrinsics.checkNotNullParameter((Object)dbDependency, (String)"dbDependency");
            DatabaseConnection connection = new DatabaseConnection(driverConnection, "public");
            DatabaseConfig config = connection.getConfig();
            config.setProperty("http://www.dbunit.org/features/caseSensitiveTableNames", (Object)true);
            config.setProperty("http://www.dbunit.org/features/qualifiedTableNames", (Object)true);
            config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)dbDependency.getEscapePattern());
            Object dataTypeFactory = Class.forName(dbDependency.getDataFactory()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", dataTypeFactory);
            String metaFactory = dbDependency.getMetaFactory();
            if (metaFactory != null && ((CharSequence)metaFactory).length() > 0) {
                Object metadataHandler = Class.forName(metaFactory).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                config.setProperty("http://www.dbunit.org/properties/metadataHandler", metadataHandler);
            }
            return connection;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

