/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.centralConfiguration;

import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.WaitForBootUtil;
import ai.digital.integration.server.deploy.domain.CentralConfigurationServer;
import ai.digital.integration.server.deploy.internals.CentralConfigurationServerUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.EnvironmentUtil;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u000e"}, d2={"Lai/digital/integration/server/deploy/tasks/centralConfiguration/StartCentralConfigurationServerTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "launch", "", "waitForBoot", "project", "Lorg/gradle/api/Project;", "process", "Ljava/lang/Process;", "centralConfigurationServer", "Lai/digital/integration/server/deploy/domain/CentralConfigurationServer;", "Companion", "integration-server-gradle-plugin"})
public class StartCentralConfigurationServerTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "startCentralConfigurationServer";

    public StartCentralConfigurationServerTask() {
        this.setGroup("Integration Server");
        Object[] objectArray = new Object[]{"downloadAndExtractCentralConfigurationServer"};
        this.dependsOn(objectArray);
        objectArray = new Object[]{"prepareCentralConfigurationServer"};
        this.dependsOn(objectArray);
        objectArray = new Object[]{"centralConfigurationServerOverlays"};
        this.dependsOn(objectArray);
        objectArray = new Object[]{"centralConfigurationServerYamlPatch"};
        this.dependsOn(objectArray);
        this.onlyIf(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                return CentralConfigurationServerUtil.Companion.hasCentralConfigurationServer(project);
            }
        });
    }

    @TaskAction
    public final void launch() {
        File file;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        CentralConfigurationServer centralConfigServer = CentralConfigurationServerUtil.Companion.getCentralConfigurationServer(project);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        File binDir = CentralConfigurationServerUtil.Companion.getBinDir(project2, centralConfigServer);
        this.getProject().getLogger().lifecycle("Launching central configuration server from '" + binDir + "'.");
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        Map<String, String> environment = EnvironmentUtil.Companion.getEnv(project3, "JDK_JAVA_OPTIONS", centralConfigServer.getDebugSuspend(), centralConfigServer.getDebugPort(), CentralConfigurationServerUtil.Companion.logFileName());
        this.getProject().getLogger().info("Starting central configuration server with environment: " + environment);
        Pair[] pairArray = new Pair[5];
        pairArray[0] = TuplesKt.to((Object)"command", (Object)"run");
        pairArray[1] = TuplesKt.to((Object)"environment", environment);
        pairArray[2] = TuplesKt.to((Object)"workDir", (Object)binDir);
        CharSequence charSequence = centralConfigServer.getStdoutFileName();
        pairArray[3] = TuplesKt.to((Object)"discardIO", (Object)(charSequence == null || charSequence.length() == 0 ? 1 : 0));
        charSequence = centralConfigServer.getStdoutFileName();
        if (!(charSequence == null || charSequence.length() == 0)) {
            Project project4 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
            file = new File(CentralConfigurationServerUtil.Companion.getLogDir(project4, centralConfigServer) + "/" + centralConfigServer.getStdoutFileName());
        } else {
            file = null;
        }
        pairArray[4] = TuplesKt.to((Object)"redirectTo", (Object)file);
        Process process = ProcessUtil.Companion.exec(MapsKt.mapOf((Pair[])pairArray));
        Logger logger = this.getProject().getLogger();
        String string = centralConfigServer.getVersion();
        long l = process.pid();
        String string2 = process.info().commandLine().orElse("");
        Project project5 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"getProject(...)");
        logger.lifecycle("Central Configuration Server '" + string + "' successfully started on PID [" + l + "] with command [" + string2 + "] on port " + CentralConfigurationServerUtil.Companion.readDeployitConfProperty(project5, "http.port"));
        Project project6 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"getProject(...)");
        this.waitForBoot(project6, process, centralConfigServer);
    }

    public final void waitForBoot(@NotNull Project project, @NotNull Process process, @NotNull CentralConfigurationServer centralConfigurationServer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)centralConfigurationServer, (String)"centralConfigurationServer");
        Server server = DeployServerUtil.Companion.getServer(project);
        File file = project.file((Object)(CentralConfigurationServerUtil.Companion.getServerPath(project, centralConfigurationServer) + "/log/" + CentralConfigurationServerUtil.Companion.logFileName() + ".log"));
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file(...)");
        File ccLog = file;
        WaitForBootUtil.Companion.byLog(project, "Central Config Server " + centralConfigurationServer.getVersion(), ccLog, "Started ConfigServerApplication.", process, server.getPingRetrySleepTime(), server.getPingTotalTries());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/centralConfiguration/StartCentralConfigurationServerTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

