/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.server.operator;

import ai.digital.integration.server.common.cluster.util.OperatorUtil;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.DbUtil;
import ai.digital.integration.server.common.util.HTTPUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import com.fasterxml.jackson.core.TreeNode;
import java.io.File;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\u0005H\u0007\u00a8\u0006\r"}, d2={"Lai/digital/integration/server/deploy/tasks/server/operator/OperatorCentralConfigurationTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "overlayRepositoryConfig", "", "serverDir", "", "createCentralConfigurationFiles", "server", "Lai/digital/integration/server/common/domain/Server;", "launch", "Companion", "integration-server-gradle-plugin"})
public class OperatorCentralConfigurationTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "operatorCentralConfiguration";

    public OperatorCentralConfigurationTask() {
        this.setGroup("Integration Server");
    }

    private final void overlayRepositoryConfig(String serverDir) {
        this.getProject().getLogger().lifecycle("Creating a custom deploy-repository.yaml");
        File deployRepositoryYaml = new File(serverDir + "/centralConfiguration/deploy-repository.yaml");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        TreeNode treeNode = DbUtil.Companion.dbConfig(project);
        if (treeNode != null) {
            TreeNode config = treeNode;
            boolean bl = false;
            YamlFileUtil.Companion.writeFileValue$default(YamlFileUtil.Companion, deployRepositoryYaml, config, false, 4, null);
        }
        String string = FilesKt.readText((File)deployRepositoryYaml, (Charset)Charsets.UTF_8);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        String configuredTemplate = StringsKt.replace$default((String)string, (String)"{{DB_PORT}}", (String)String.valueOf(DbUtil.Companion.getPort(project2)), (boolean)false, (int)4, null);
        FilesKt.writeText$default((File)deployRepositoryYaml, (String)configuredTemplate, null, (int)2, null);
    }

    private final void createCentralConfigurationFiles(Server server) {
        this.getProject().getLogger().lifecycle("Generating initial central configuration files for server " + server.getName());
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String serverDir = DeployServerUtil.Companion.getServerWorkingDir(project, server);
        this.overlayRepositoryConfig(serverDir);
        this.getProject().getLogger().lifecycle("Creating custom deploy-server.yaml");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"deploy.server.port", (Object)HTTPUtil.Companion.findFreePort()), TuplesKt.to((Object)"deploy.server.hostname", (Object)"127.0.0.1")};
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, new File(serverDir + "/centralConfiguration/deploy-server.yaml"), MapsKt.mutableMapOf((Pair[])pairArray), null, false, 12, null);
        this.getProject().getLogger().lifecycle("Creating custom deploy-task.yaml");
        pairArray = new Pair[]{TuplesKt.to((Object)"deploy.task.in-process-worker", (Object)"true"), TuplesKt.to((Object)"deploy.task.planner.registries.timeout", (Object)"5 minutes"), TuplesKt.to((Object)"deploy.task.queue.name", (Object)"xld-tasks-queue"), TuplesKt.to((Object)"deploy.task.queue.archive-queue-name", (Object)"xld-archive-queue")};
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, new File(serverDir + "/centralConfiguration/deploy-task.yaml"), MapsKt.mutableMapOf((Pair[])pairArray), null, false, 12, null);
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Server server = new OperatorUtil(project).getOperatorServer();
        if (server.numericVersion() >= 10.2) {
            this.createCentralConfigurationFiles(server);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/server/operator/OperatorCentralConfigurationTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

