/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.operator;

import ai.digital.integration.server.common.cluster.Helper;
import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.cluster.setup.AwsOpenshiftHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.providers.AwsOpenshiftProvider;
import ai.digital.integration.server.common.util.HtmlUtil;
import ai.digital.integration.server.common.util.KubeCtlHelper;
import ai.digital.integration.server.common.util.YamlFileUtil;
import java.io.File;
import java.time.Duration;
import java.util.Base64;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\rJ\u0006\u0010\u0010\u001a\u00020\rJ\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0012H\u0016J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010'\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010(\u001a\u00020\u0012H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006)"}, d2={"Lai/digital/integration/server/common/cluster/operator/AwsOpenshiftOperatorHelper;", "Lai/digital/integration/server/common/cluster/operator/OperatorHelper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "<init>", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "awsOpenshiftHelper", "Lai/digital/integration/server/common/cluster/setup/AwsOpenshiftHelper;", "getAwsOpenshiftHelper", "()Lai/digital/integration/server/common/cluster/setup/AwsOpenshiftHelper;", "launchCluster", "", "updateOperator", "installCluster", "shutdownCluster", "getOcApiServerToken", "", "getProviderHomePath", "getProvider", "Lai/digital/integration/server/common/domain/providers/AwsOpenshiftProvider;", "getStorageClass", "updateInfrastructure", "apiServerURL", "token", "updateCustomOperatorCrValues", "crValuesFile", "Ljava/io/File;", "getKubectlHelper", "Lai/digital/integration/server/common/util/KubeCtlHelper;", "hasIngress", "", "getCrName", "getWorkerPodName", "position", "", "getMasterPodName", "getPostgresPodName", "getRabbitMqPodName", "getProviderCrContextPath", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nAwsOpenshiftOperatorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwsOpenshiftOperatorHelper.kt\nai/digital/integration/server/common/cluster/operator/AwsOpenshiftOperatorHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1#2:126\n*E\n"})
public class AwsOpenshiftOperatorHelper
extends OperatorHelper {
    @NotNull
    private final AwsOpenshiftHelper awsOpenshiftHelper;

    public AwsOpenshiftOperatorHelper(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)productName), (String)"productName");
        super(project, productName);
        this.awsOpenshiftHelper = new AwsOpenshiftHelper(project, productName, this.getProfile());
    }

    @NotNull
    public final AwsOpenshiftHelper getAwsOpenshiftHelper() {
        return this.awsOpenshiftHelper;
    }

    public final void launchCluster() {
        this.awsOpenshiftHelper.launchCluster();
    }

    public final void updateOperator() {
        this.awsOpenshiftHelper.ocLogin();
        Object object = this.getProvider().getCleanUpWaitTimeout().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this.cleanUpCluster((Duration)object);
        this.updateInfrastructure(this.awsOpenshiftHelper.getApiServerUrl(), this.getOcApiServerToken());
        this.updateOperatorApplications();
        this.updateOperatorDeployment();
        this.updateOperatorDeploymentCr();
        this.updateOperatorEnvironment();
        this.updateDeploymentValues();
        this.updateOperatorCrValues();
    }

    public final void installCluster() {
        this.applyYamlFiles();
        this.turnOnLogging();
        this.awsOpenshiftHelper.ocLogin();
        Helper helper = this;
        Object object = this.getProfile().getIngressType().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String string = (String)object;
        Object object2 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        Helper.waitForDeployment$default(helper, string, ((Number)object2).intValue(), false, 4, null);
        Object object3 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        this.waitForMasterPods(((Number)object3).intValue());
        Object object4 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        this.waitForWorkerPods(((Number)object4).intValue());
        this.createClusterMetadata();
        this.waitForBoot(this.getContextRoot(), this.getFqdn());
        this.turnOffLogging();
    }

    public final void shutdownCluster() {
        this.awsOpenshiftHelper.ocLogin();
        this.undeployCluster();
        this.awsOpenshiftHelper.ocLogout();
    }

    @NotNull
    public final String getOcApiServerToken() {
        Base64.Encoder encoder = Base64.getEncoder();
        String string = this.awsOpenshiftHelper.getOcLogin() + ":" + this.awsOpenshiftHelper.getOcPassword();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String basicAuthToken = encoder.encodeToString(byArray);
        Object object = this.getProvider().getOauthHostName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String oauthHostName = (String)object;
        this.awsOpenshiftHelper.ocLogout();
        String command1Output = this.exec("curl -vvv -L -k -c cookie -b cookie  -H \"Authorization: Basic " + basicAuthToken + "\" https://" + oauthHostName + "/oauth/token/request");
        Document doc1 = HtmlUtil.Companion.htmlToDocument(command1Output);
        String string2 = doc1.select("form input[name=\"code\"]").val();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"val(...)");
        String code = string2;
        String string3 = doc1.select("form input[name=\"csrf\"]").val();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"val(...)");
        String csrf = string3;
        String command2Output = this.exec("curl -vvv -L -k -c cookie -b cookie -d 'code=" + code + "&csrf=" + csrf + "' -H \"Authorization: Basic " + basicAuthToken + "\" https://" + oauthHostName + "/oauth/token/display");
        Document doc2 = HtmlUtil.Companion.htmlToDocument(command2Output);
        String string4 = doc2.select("code").text();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"text(...)");
        return string4;
    }

    @Override
    @NotNull
    public String getProviderHomePath() {
        return this.getName() + "-operator-openshift";
    }

    @Override
    @NotNull
    public AwsOpenshiftProvider getProvider() {
        return this.getProfile().getAwsOpenshift();
    }

    @Override
    @NotNull
    public String getStorageClass() {
        return this.awsOpenshiftHelper.getStorageClass();
    }

    private final void updateInfrastructure(String apiServerURL, String token) {
        this.getProject().getLogger().lifecycle("Updating operator's infrastructure");
        super.updateInfrastructure();
        File file = new File(this.getProviderHomeDir(), this.getOPERATOR_INFRASTRUCTURE_PATH());
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"spec[0].children[0].serverUrl", (Object)apiServerURL), TuplesKt.to((Object)"spec[0].children[0].openshiftToken", (Object)token)};
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, null, false, 12, null);
    }

    @Override
    public void updateCustomOperatorCrValues(@NotNull File crValuesFile) {
        Intrinsics.checkNotNullParameter((Object)crValuesFile, (String)"crValuesFile");
        Pair[] pairArray = new Pair[2];
        String[] stringArray = new String[]{this.getHost()};
        pairArray[0] = TuplesKt.to((Object)"spec.route.hosts", (Object)stringArray);
        pairArray[1] = TuplesKt.to((Object)"spec.keycloak.route.host", (Object)("keycloak-" + this.getHost()));
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, crValuesFile, pairs, null, false, 4, null);
    }

    @Override
    @NotNull
    public KubeCtlHelper getKubectlHelper() {
        return new KubeCtlHelper(this.getProject(), this.getNamespace(), true);
    }

    @Override
    public boolean hasIngress() {
        return false;
    }

    @Override
    @NotNull
    public String getCrName() {
        Object object;
        block3: {
            block2: {
                object = this.getNamespace();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = "-" + it;
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        String operatorNamespace = object;
        return "dai-ocp-" + this.getPrefixName() + operatorNamespace;
    }

    @Override
    @NotNull
    public String getWorkerPodName(int position) {
        return "pod/" + this.getCrName() + "-digitalai-" + this.getName() + "-ocp-worker-" + position;
    }

    @Override
    @NotNull
    public String getMasterPodName(int position) {
        return "pod/" + this.getCrName() + "-digitalai-" + this.getName() + "-ocp-" + this.getMasterPodNameSuffix(position);
    }

    @Override
    @NotNull
    public String getPostgresPodName(int position) {
        return "pod/" + this.getCrName() + "-postgresql-" + position;
    }

    @Override
    @NotNull
    public String getRabbitMqPodName(int position) {
        return "pod/" + this.getCrName() + "-rabbitmq-" + position;
    }

    @Override
    @NotNull
    public String getProviderCrContextPath() {
        return "spec.route.path";
    }
}

