/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.tasks.database;

import ai.digital.integration.server.common.util.DbUtil;
import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.common.util.IntegrationServerUtil;
import com.palantir.gradle.docker.DockerComposeUp;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.security.CodeSource;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0017J\b\u0010\n\u001a\u00020\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lai/digital/integration/server/common/tasks/database/DatabaseStartTask;", "Lcom/palantir/gradle/docker/DockerComposeUp;", "execOperations", "Lorg/gradle/process/ExecOperations;", "<init>", "(Lorg/gradle/process/ExecOperations;)V", "getDescription", "", "getDockerComposeFile", "Ljava/io/File;", "run", "", "Companion", "integration-server-gradle-plugin"})
public abstract class DatabaseStartTask
extends DockerComposeUp {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecOperations execOperations;
    @NotNull
    public static final String NAME = "databaseStart";

    @Inject
    public DatabaseStartTask(@NotNull ExecOperations execOperations) {
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        this.execOperations = execOperations;
        this.setGroup("Integration Server");
        Object[] objectArray = new Object[]{"applicationConfigurationOverride", "downloadAndExtractCli", "downloadAndExtractCentralConfigurationServer"};
        this.mustRunAfter(objectArray);
    }

    @NotNull
    public String getDescription() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return "Starts database instance using `docker-compose` and " + DbUtil.Companion.dockerComposeFileName(project) + " file.";
    }

    @InputFiles
    @NotNull
    public File getDockerComposeFile() {
        CodeSource src;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DbUtil.Companion.assertNotDerby(project, "Docker compose tasks do not support Derby database.");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Path resultComposeFilePath = DbUtil.Companion.getResolveDbFilePath(project2);
        CodeSource codeSource = src = DatabaseStartTask.class.getProtectionDomain().getCodeSource();
        if (codeSource != null) {
            ZipEntry entry;
            CodeSource codeSource2 = codeSource;
            boolean bl = false;
            Project project3 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
            String dbName = DbUtil.Companion.databaseName(project3);
            new File(resultComposeFilePath.getParent().toFile().getPath(), dbName + "-docker").mkdirs();
            URL jar = codeSource2.getLocation();
            ZipInputStream zip = new ZipInputStream(jar.openStream());
            while ((entry = zip.getNextEntry()) != null) {
                String dockerFileName;
                String name = entry.getName();
                String folderName = "database-compose/" + dbName + "-docker/";
                Intrinsics.checkNotNull((Object)name);
                if (!StringsKt.startsWith$default((String)name, (String)folderName, (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name, (Object)folderName)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)name.substring(StringsKt.indexOf$default((CharSequence)name, (char)'/', (int)0, (boolean)false, (int)6, null) + 1), (String)"substring(...)");
                InputStream inputStream = zip;
                Project project4 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
                FileUtil.Companion.copyFile(inputStream, IntegrationServerUtil.Companion.getRelativePathInIntegrationServerDist(project4, dockerFileName));
            }
        }
        Project project5 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"getProject(...)");
        DbUtil.Companion.getResolvedDBDockerComposeFile(resultComposeFilePath, project5);
        File file = this.getProject().file((Object)resultComposeFilePath);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file(...)");
        return file;
    }

    @TaskAction
    public void run() {
        this.getProject().getLogger().lifecycle("Cleaning up previous database containers and networks.");
        this.execOperations.exec(new Action(this){
            final /* synthetic */ DatabaseStartTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(ExecSpec $this$exec) {
                Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                $this$exec.setExecutable("docker-compose");
                Object[] objectArray = new String[]{"-f", this.this$0.getDockerComposeFile().getPath(), "down", "--remove-orphans"};
                $this$exec.setArgs(CollectionsKt.listOf((Object[])objectArray));
            }
        });
        this.execOperations.exec(new Action(this){
            final /* synthetic */ DatabaseStartTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(ExecSpec $this$exec) {
                Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                $this$exec.setExecutable("docker-compose");
                Object[] objectArray = new String[]{"-f", this.this$0.getDockerComposeFile().getPath(), "up", "-d"};
                $this$exec.setArgs(CollectionsKt.listOf((Object[])objectArray));
            }
        });
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String dbName = DbUtil.Companion.databaseName(project);
        if (StringsKt.startsWith$default((String)dbName, (String)"oracle", (boolean)false, (int)2, null)) {
            this.getProject().getLogger().lifecycle("Waiting for 1 minute to start oracle db");
            TimeUnit.SECONDS.sleep(60L);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/common/tasks/database/DatabaseStartTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

