/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import ai.digital.integration.server.common.util.HTTPUtil;
import java.io.File;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/common/util/WaitForBootUtil;", "", "<init>", "()V", "Companion", "integration-server-gradle-plugin"})
public final class WaitForBootUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fJ4\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0002J4\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fJR\u0010\u0004\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\u0014\b\u0002\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0019JD\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f\u00a8\u0006\u001d"}, d2={"Lai/digital/integration/server/common/util/WaitForBootUtil$Companion;", "", "<init>", "()V", "byPort", "", "project", "Lorg/gradle/api/Project;", "name", "", "url", "pingRetrySleepTime", "", "pingTotalTries", "waitForNext", "process", "Ljava/lang/Process;", "triesLeft", "success", "", "byFile", "file", "Ljava/io/File;", "Ljava/time/LocalDateTime;", "callback", "Lkotlin/Function1;", "byLog", "logFile", "containsLine", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final void byPort(@NotNull Project project, @NotNull String name, @NotNull String url, int pingRetrySleepTime, int pingTotalTries) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            ai.digital.integration.server.common.util.WaitForBootUtil$Companion.byPort$default(this, project, name, url, null, pingRetrySleepTime, pingTotalTries, null, 64, null);
        }

        public static /* synthetic */ void byPort$default(Companion companion, Project project, String string, String string2, int n, int n2, int n3, Object object) {
            if ((n3 & 8) != 0) {
                n = 10;
            }
            if ((n3 & 0x10) != 0) {
                n2 = 60;
            }
            companion.byPort(project, string, string2, n, n2);
        }

        private final int waitForNext(Project project, Process process, int triesLeft, boolean success, int pingRetrySleepTime) {
            if (!success) {
                project.getLogger().lifecycle("Retrying after " + pingRetrySleepTime + " second(s). (" + triesLeft + ")");
                if (process != null) {
                    if (process.waitFor(pingRetrySleepTime, TimeUnit.SECONDS)) {
                        return -1;
                    }
                } else {
                    TimeUnit.SECONDS.sleep(pingRetrySleepTime);
                }
            }
            return triesLeft - 1;
        }

        static /* synthetic */ int waitForNext$default(Companion companion, Project project, Process process, int n, boolean bl, int n2, int n3, Object object) {
            if ((n3 & 0x10) != 0) {
                n2 = 10;
            }
            return companion.waitForNext(project, process, n, bl, n2);
        }

        public final void byFile(@NotNull Project project, @Nullable Process process, @NotNull File file, int pingRetrySleepTime, int pingTotalTries) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            project.getLogger().lifecycle("Waiting for " + file + " to be created.");
            int triesLeft = pingTotalTries;
            boolean success = false;
            while (triesLeft > 0 && !success) {
                if (file.exists()) {
                    success = true;
                }
                triesLeft = this.waitForNext(project, process, triesLeft, success, pingRetrySleepTime);
            }
            if (!success) {
                throw new GradleException(file + " has failed to be created.");
            }
        }

        public static /* synthetic */ void byFile$default(Companion companion, Project project, Process process, File file, int n, int n2, int n3, Object object) {
            if ((n3 & 8) != 0) {
                n = 10;
            }
            if ((n3 & 0x10) != 0) {
                n2 = 60;
            }
            companion.byFile(project, process, file, n, n2);
        }

        @NotNull
        public final LocalDateTime byPort(@NotNull Project project, @NotNull String name, @NotNull String url, @Nullable Process process, int pingRetrySleepTime, int pingTotalTries, @NotNull Function1<? super LocalDateTime, LocalDateTime> callback) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            project.getLogger().lifecycle("Waiting for " + name + " to start on URL: " + url + ".");
            int triesLeft = pingTotalTries;
            boolean success = false;
            LocalDateTime lastTry = LocalDateTime.now().minusDays(1L);
            HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
            while (triesLeft > 0 && !success) {
                try {
                    HttpRequest request = HTTPUtil.Companion.buildRequest$default(HTTPUtil.Companion, url, null, null, 6, null).GET().build();
                    HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                    int n = response.statusCode();
                    boolean bl = 200 <= n ? n < 400 : false;
                    if (bl) {
                        success = true;
                    } else {
                        LocalDateTime localDateTime = lastTry;
                        Intrinsics.checkNotNull((Object)localDateTime);
                        lastTry = (LocalDateTime)callback.invoke((Object)localDateTime);
                    }
                }
                catch (Exception ignored) {
                    LocalDateTime localDateTime = lastTry;
                    Intrinsics.checkNotNull((Object)localDateTime);
                    lastTry = (LocalDateTime)callback.invoke((Object)localDateTime);
                }
                triesLeft = this.waitForNext(project, process, triesLeft, success, pingRetrySleepTime);
            }
            if (!success) {
                throw new GradleException(name + " failed to start.");
            }
            LocalDateTime localDateTime = lastTry;
            Intrinsics.checkNotNull((Object)localDateTime);
            return localDateTime;
        }

        public static /* synthetic */ LocalDateTime byPort$default(Companion companion, Project project, String string, String string2, Process process, int n, int n2, Function1 function1, int n3, Object object) {
            if ((n3 & 0x10) != 0) {
                n = 10;
            }
            if ((n3 & 0x20) != 0) {
                n2 = 60;
            }
            if ((n3 & 0x40) != 0) {
                function1 = Companion::byPort$lambda$0;
            }
            return companion.byPort(project, string, string2, process, n, n2, (Function1<? super LocalDateTime, LocalDateTime>)function1);
        }

        public final void byLog(@NotNull Project project, @NotNull String name, @NotNull File logFile, @NotNull String containsLine, @Nullable Process process, int pingRetrySleepTime, int pingTotalTries) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)logFile, (String)"logFile");
            Intrinsics.checkNotNullParameter((Object)containsLine, (String)"containsLine");
            project.getLogger().lifecycle("Waiting for " + name + " to start with log: '" + containsLine + "'.");
            int triesLeft = pingTotalTries;
            Ref.BooleanRef success = new Ref.BooleanRef();
            while (triesLeft > 0 && !success.element) {
                try {
                    FilesKt.forEachLine$default((File)logFile, null, arg_0 -> Companion.byLog$lambda$1(containsLine, project, name, success, arg_0), (int)1, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                triesLeft = this.waitForNext(project, process, triesLeft, success.element, pingRetrySleepTime);
            }
            if (!success.element) {
                throw new GradleException(name + " failed to start.");
            }
        }

        public static /* synthetic */ void byLog$default(Companion companion, Project project, String string, File file, String string2, Process process, int n, int n2, int n3, Object object) {
            if ((n3 & 0x20) != 0) {
                n = 10;
            }
            if ((n3 & 0x40) != 0) {
                n2 = 60;
            }
            companion.byLog(project, string, file, string2, process, n, n2);
        }

        private static final LocalDateTime byPort$lambda$0(LocalDateTime it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return LocalDateTime.now().minusDays(1L);
        }

        private static final Unit byLog$lambda$1(String $containsLine, Project $project, String $name, Ref.BooleanRef $success, String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            if (StringsKt.contains$default((CharSequence)line, (CharSequence)$containsLine, (boolean)false, (int)2, null)) {
                $project.getLogger().lifecycle($name + " successfully started.");
                $success.element = true;
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

