/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.release.tasks.cluster.operator;

import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.util.GitUtil;
import ai.digital.integration.server.release.internals.ReleaseExtensionUtil;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lai/digital/integration/server/release/tasks/cluster/operator/ProvideReleaseKubernetesOperatorTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "launch", "", "cloneRepository", "branch", "", "copyCurrentRepository", "operatorHelper", "Lai/digital/integration/server/common/cluster/operator/OperatorHelper;", "Companion", "integration-server-gradle-plugin"})
public class ProvideReleaseKubernetesOperatorTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "provideReleaseKubernetesOperator";

    public ProvideReleaseKubernetesOperatorTask() {
        this.getProject().afterEvaluate(new Action(){

            public final void execute(Project $this$afterEvaluate) {
                Intrinsics.checkNotNullParameter((Object)$this$afterEvaluate, (String)"$this$afterEvaluate");
                Project project = $this$afterEvaluate.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (ReleaseExtensionUtil.Companion.getExtension(project).getClusterProfiles().operator().getActiveProviderName().isPresent()) {
                    Project project2 = $this$afterEvaluate.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                    OperatorHelper operatorHelper = OperatorHelper.Companion.getOperatorHelper(project2, ProductName.RELEASE);
                    if (operatorHelper.getProvider().getOperatorPackageVersion().isPresent()) {
                        $this$afterEvaluate.getProject().getDependencies().add("operatorDist", (Object)("ai.digital.release.operator:" + operatorHelper.getProviderHomePath() + ":" + operatorHelper.getProvider().getOperatorPackageVersion().get() + "@zip"));
                        String taskName = "downloadAndExtractOperator" + operatorHelper.getProviderHomePath();
                        TaskProvider taskProvider = $this$afterEvaluate.getProject().getTasks().register(taskName, Copy.class, new Action(operatorHelper){
                            final /* synthetic */ OperatorHelper $operatorHelper;
                            {
                                this.$operatorHelper = $operatorHelper;
                            }

                            public final void execute(Copy $this$register) {
                                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                                Object[] objectArray = new Object[]{$this$register.getProject().zipTree((Object)$this$register.getProject().getConfigurations().getByName("operatorDist").getSingleFile())};
                                $this$register.from(objectArray);
                                $this$register.into((Object)this.$operatorHelper.getProviderHomeDir());
                            }
                        });
                        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
                        TaskProvider task2 = taskProvider;
                        Object[] objectArray = new Object[]{task2};
                        this.dependsOn(objectArray);
                    }
                } else {
                    $this$afterEvaluate.getProject().getLogger().warn("Active provider name is not set - ProvideReleaseKubernetesOperatorTask");
                }
            }
        });
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        OperatorHelper operatorHelper = OperatorHelper.Companion.getOperatorHelper(project, ProductName.RELEASE);
        if (operatorHelper.getProvider().getOperatorBranch().isPresent()) {
            Object object = operatorHelper.getProvider().getOperatorBranch().getOrElse((Object)"master");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrElse(...)");
            String branch = (String)object;
            this.getProject().getLogger().lifecycle("Checking out xl-release-kubernetes-operator branch " + branch);
            this.cloneRepository(branch);
        } else if (operatorHelper.getProvider().getOperatorPackageVersion().isPresent()) {
            Object object = operatorHelper.getProvider().getOperatorPackageVersion().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            String version = (String)object;
            this.getProject().getLogger().lifecycle("Downloading package xl-release-kubernetes-operator version " + version);
        } else {
            this.getProject().getLogger().lifecycle("Using current repository as operator source");
            this.copyCurrentRepository(operatorHelper);
        }
    }

    private final void cloneRepository(String branch) {
        Path path = ((Directory)this.getProject().getLayout().getBuildDirectory().get()).getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        GitUtil.Companion.checkout("xl-release-kubernetes-operator", path, branch);
    }

    private final void copyCurrentRepository(OperatorHelper operatorHelper) {
        String providerHomePath = operatorHelper.getProviderHomePath();
        File file = this.getProject().getRootDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getRootDir(...)");
        FilesKt.copyRecursively$default((File)FilesKt.resolve((File)file, (String)providerHomePath), (File)new File(operatorHelper.getProviderHomeDir()), (boolean)true, null, (int)4, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/release/tasks/cluster/operator/ProvideReleaseKubernetesOperatorTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

