package com.xebialabs.xlplatform.extensions.exportcis.route

import java.nio.file.Paths

import akka.actor.ActorSystem
import akka.http.scaladsl.model.StatusCodes.NotFound
import com.xebialabs.deployit.repository.RepositoryServiceHolder.getRepositoryService
import com.xebialabs.xlplatform.config.{ConfigLoader, ConfigurationHolder}
import com.xebialabs.xlplatform.endpoints.{AuthenticatedData, ExtensionRoutes}
import com.xebialabs.xlplatform.extensions.exportcis.CisExportSupport
import com.xebialabs.xlplatform.extensions.exportcis.archive.RepositoryExporter.RepositoryRootAlias
import de.schlichtherle.truezip.util.UriDecoder
import grizzled.slf4j.Logging

class ExportCisRoute extends ExtensionRoutes with Logging with CisExportSupport {

  private lazy val defaultExportDir = ConfigLoader.loadWithDynamic(ConfigurationHolder.get()).getString("xl.export-cis.export-dir")

  private val uriDecoder = new UriDecoder()

  def route(system: ActorSystem) = (auth: AuthenticatedData) => pathPrefix("export" / "citree") {
    post {
      path(Remaining){ ciIdEncoded =>
        rejectNonAdmin(auth) {
          val ciId = uriDecoder.decode(ciIdEncoded)
          parameter('exportDir.?(defaultExportDir)) { exportDir =>
            logger.info(s"Trying to export CI tree starting from $ciId into $exportDir")
            ciId match {
              case "/" | "" => complete(export(RepositoryRootAlias, Paths.get(exportDir))(auth))
              case _ if getRepositoryService.exists(ciId) => complete(export(ciId, Paths.get(exportDir))(auth))
              case _ => complete(NotFound -> s"CI does not exist [$ciId]")
            }
          }
        }
      }
    }
  }
}
